/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.featuremodifiereditcomposite;

import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.modifier.DoubleRangeModifier;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.IntegerRangeModifier;
import org.eclipse.stem.core.modifier.LongRangeModifier;
import org.eclipse.stem.core.modifier.STEMTimeRangeModifier;
import org.eclipse.stem.ui.adapters.featuremodifiereditcomposite.FeatureModifierEditCompositeAdapter;
import org.eclipse.stem.ui.wizards.NewModifierPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class RangeFeatureModifierEditCompositeAdapter
extends FeatureModifierEditCompositeAdapter {
    public void setSelectedButton(Button button, Button button2, Button button3) {
        button.setSelection(false);
        button2.setSelection(true);
        button3.setSelection(false);
    }

    public static class DoubleRangeFeatureModifierEditCompositeAdapter
    extends NumericRangeFeatureModifierEditCompositeAdapter {
        protected void initializeFeatureModifier(Identifiable identifiable) {
            DoubleRangeModifier doubleRangeModifier = (DoubleRangeModifier)this.getFeatureModifier();
            doubleRangeModifier.setStartValue(((Double)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature())).doubleValue());
            doubleRangeModifier.setEndValue(doubleRangeModifier.getStartValue());
        }

        protected String getInitialEndText() {
            return Double.toString(((DoubleRangeModifier)this.getFeatureModifier()).getEndValue());
        }

        protected String getInitialIncrementText() {
            return Double.toString(((DoubleRangeModifier)this.getFeatureModifier()).getIncrement());
        }

        protected String getInitialStartText() {
            return Double.toString(((DoubleRangeModifier)this.getFeatureModifier()).getStartValue());
        }

        protected NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite composite, NewModifierPage newModifierPage) {
            NewModifierPage.FeatureModifierEditComposite featureModifierEditComposite = new NewModifierPage.FeatureModifierEditComposite(composite, newModifierPage, (FeatureModifier)this.getTarget()){

                protected boolean validate() {
                    boolean bl = true;
                    String string = null;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    if (bl) {
                        try {
                            d = Double.parseDouble(DoubleRangeFeatureModifierEditCompositeAdapter.this.startText.getText());
                            ((DoubleRangeModifier)this.featureModifier).setStartValue(d);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "Start value not valid";
                        }
                    }
                    if (bl) {
                        try {
                            d2 = Double.parseDouble(DoubleRangeFeatureModifierEditCompositeAdapter.this.endText.getText());
                            ((DoubleRangeModifier)this.featureModifier).setEndValue(d2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "End value not valid";
                        }
                    }
                    if (bl) {
                        try {
                            d3 = Double.parseDouble(DoubleRangeFeatureModifierEditCompositeAdapter.this.incText.getText());
                            ((DoubleRangeModifier)this.featureModifier).setIncrement(d3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "Increment value not valid";
                        }
                    }
                    if (bl) {
                        if (d <= d2 && d3 < 0.0) {
                            bl = false;
                            string = "If the start is <= the end, then the increment cannont be < 0.0";
                        } else if (d > d2 && d3 >= 0.0) {
                            bl = false;
                            string = "If the start is > the end, then the increment cannont be >= 0.0";
                        }
                    }
                    if (string != null) {
                        this.parentNewModifierPage.setErrorMessage(string);
                    }
                    if (bl) {
                        bl = this.parentNewModifierPage.validatePage();
                    }
                    return bl;
                }
            };
            return featureModifierEditComposite;
        }
    }

    public static class IntegerRangeFeatureModifierEditCompositeAdapter
    extends NumericRangeFeatureModifierEditCompositeAdapter {
        protected void initializeFeatureModifier(Identifiable identifiable) {
            IntegerRangeModifier integerRangeModifier = (IntegerRangeModifier)this.getFeatureModifier();
            integerRangeModifier.setStartValue(((Integer)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature())).intValue());
            integerRangeModifier.setEndValue(integerRangeModifier.getStartValue());
        }

        protected String getInitialEndText() {
            return Integer.toString(((IntegerRangeModifier)this.getFeatureModifier()).getEndValue());
        }

        protected String getInitialIncrementText() {
            return Integer.toString(((IntegerRangeModifier)this.getFeatureModifier()).getIncrement());
        }

        protected String getInitialStartText() {
            return Integer.toString(((IntegerRangeModifier)this.getFeatureModifier()).getStartValue());
        }

        protected NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite composite, NewModifierPage newModifierPage) {
            NewModifierPage.FeatureModifierEditComposite featureModifierEditComposite = new NewModifierPage.FeatureModifierEditComposite(composite, newModifierPage, (FeatureModifier)this.getTarget()){

                protected boolean validate() {
                    boolean bl = true;
                    String string = null;
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    if (bl) {
                        try {
                            n = Integer.parseInt(IntegerRangeFeatureModifierEditCompositeAdapter.this.startText.getText());
                            ((IntegerRangeModifier)this.featureModifier).setStartValue(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "Start value not valid";
                        }
                    }
                    if (bl) {
                        try {
                            n2 = Integer.parseInt(IntegerRangeFeatureModifierEditCompositeAdapter.this.endText.getText());
                            ((IntegerRangeModifier)this.featureModifier).setEndValue(n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "End value not valid";
                        }
                    }
                    if (bl) {
                        try {
                            n3 = Integer.parseInt(IntegerRangeFeatureModifierEditCompositeAdapter.this.incText.getText());
                            ((IntegerRangeModifier)this.featureModifier).setIncrement(n3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "Increment value not valid";
                        }
                    }
                    if (bl) {
                        if (n <= n2 && (long)n3 < 0L) {
                            bl = false;
                            string = "If the start is <= the end, then the increment cannont be < 0.0";
                        } else if (n > n2 && (long)n3 >= 0L) {
                            bl = false;
                            string = "If the start is > the end, then the increment cannont be >= 0.0";
                        }
                    }
                    if (string != null) {
                        this.parentNewModifierPage.setErrorMessage(string);
                    }
                    if (bl) {
                        bl = this.parentNewModifierPage.validatePage();
                    }
                    return bl;
                }
            };
            return featureModifierEditComposite;
        }
    }

    public static class LongRangeFeatureModifierEditCompositeAdapter
    extends NumericRangeFeatureModifierEditCompositeAdapter {
        protected void initializeFeatureModifier(Identifiable identifiable) {
            LongRangeModifier longRangeModifier = (LongRangeModifier)this.getFeatureModifier();
            longRangeModifier.setStartValue(((Long)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature())).longValue());
            longRangeModifier.setEndValue(longRangeModifier.getStartValue());
        }

        protected String getInitialEndText() {
            return Long.toString(((LongRangeModifier)this.getFeatureModifier()).getEndValue());
        }

        protected String getInitialIncrementText() {
            return Long.toString(((LongRangeModifier)this.getFeatureModifier()).getIncrement());
        }

        protected String getInitialStartText() {
            return Long.toString(((LongRangeModifier)this.getFeatureModifier()).getStartValue());
        }

        protected NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite composite, NewModifierPage newModifierPage) {
            NewModifierPage.FeatureModifierEditComposite featureModifierEditComposite = new NewModifierPage.FeatureModifierEditComposite(composite, newModifierPage, (FeatureModifier)this.getTarget()){

                protected boolean validate() {
                    boolean bl = true;
                    String string = null;
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    if (bl) {
                        try {
                            l = Long.parseLong(LongRangeFeatureModifierEditCompositeAdapter.this.startText.getText());
                            ((LongRangeModifier)this.featureModifier).setStartValue(l);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "Start value not valid";
                        }
                    }
                    if (bl) {
                        try {
                            l2 = Long.parseLong(LongRangeFeatureModifierEditCompositeAdapter.this.endText.getText());
                            ((LongRangeModifier)this.featureModifier).setEndValue(l2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "End value not valid";
                        }
                    }
                    if (bl) {
                        try {
                            l3 = Long.parseLong(LongRangeFeatureModifierEditCompositeAdapter.this.incText.getText());
                            ((LongRangeModifier)this.featureModifier).setIncrement(l3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                            string = "Increment value not valid";
                        }
                    }
                    if (bl) {
                        if (l <= l2 && l3 < 0L) {
                            bl = false;
                            string = "If the start is <= the end, then the increment cannont be < 0.0";
                        } else if (l > l2 && l3 >= 0L) {
                            bl = false;
                            string = "If the start is > the end, then the increment cannont be >= 0.0";
                        }
                    }
                    if (string != null) {
                        this.parentNewModifierPage.setErrorMessage(string);
                    }
                    if (bl) {
                        bl = this.parentNewModifierPage.validatePage();
                    }
                    return bl;
                }
            };
            return featureModifierEditComposite;
        }
    }

    protected static abstract class NumericRangeFeatureModifierEditCompositeAdapter
    extends RangeFeatureModifierEditCompositeAdapter {
        private static final int TEXT_WIDTH = 30;
        protected Text startText;
        protected Text endText;
        protected Text incText;

        protected NumericRangeFeatureModifierEditCompositeAdapter() {
        }

        protected abstract void initializeFeatureModifier(Identifiable var1);

        protected abstract String getInitialStartText();

        protected abstract String getInitialEndText();

        protected abstract String getInitialIncrementText();

        public NewModifierPage.FeatureModifierEditComposite createEditComposite(Composite composite, Identifiable identifiable, NewModifierPage newModifierPage) {
            this.initializeFeatureModifier(identifiable);
            NewModifierPage.FeatureModifierEditComposite featureModifierEditComposite = this.getFeatureModifierEditComposite(composite, newModifierPage);
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 0;
            formLayout.marginWidth = 0;
            featureModifierEditComposite.setLayout((Layout)formLayout);
            this.startText = new Text((Composite)featureModifierEditComposite, 133120);
            this.startText.setText(this.getInitialStartText());
            this.startText.setToolTipText("Starting value");
            this.startText.addModifyListener(featureModifierEditComposite.getModifyListener());
            Label label = new Label((Composite)featureModifierEditComposite, 0);
            label.setText(" to ");
            this.endText = new Text((Composite)featureModifierEditComposite, 133120);
            this.endText.setText(this.getInitialEndText());
            this.endText.setToolTipText("Ending value");
            this.endText.addModifyListener(featureModifierEditComposite.getModifyListener());
            Label label2 = new Label((Composite)featureModifierEditComposite, 0);
            label2.setText(" by ");
            this.incText = new Text((Composite)featureModifierEditComposite, 133120);
            this.incText.setText(this.getInitialIncrementText());
            this.incText.setToolTipText("Increment");
            this.incText.addModifyListener(featureModifierEditComposite.getModifyListener());
            FormData formData = null;
            formData = new FormData();
            formData.width = 30;
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.startText.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.startText, 0, 131072);
            formData.bottom = new FormAttachment((Control)this.startText, 0, 1024);
            label.setLayoutData((Object)formData);
            formData = new FormData();
            formData.width = 30;
            formData.left = new FormAttachment((Control)label, 0, 131072);
            formData.bottom = new FormAttachment((Control)label, 0, 1024);
            this.endText.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.endText, 0, 131072);
            formData.bottom = new FormAttachment((Control)this.endText, 0, 1024);
            label2.setLayoutData((Object)formData);
            formData = new FormData();
            formData.width = 30;
            formData.left = new FormAttachment((Control)label2, 0, 131072);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment((Control)label2, 0, 1024);
            this.incText.setLayoutData((Object)formData);
            return featureModifierEditComposite;
        }

        protected abstract NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite var1, NewModifierPage var2);
    }

    public static class STEMTimeRangeFeatureModifierEditCompositeAdapter
    extends RangeFeatureModifierEditCompositeAdapter {
        public NewModifierPage.FeatureModifierEditComposite createEditComposite(Composite composite, Identifiable identifiable, NewModifierPage newModifierPage) {
            NewModifierPage.FeatureModifierEditComposite featureModifierEditComposite = new NewModifierPage.FeatureModifierEditComposite(composite, newModifierPage, (FeatureModifier)this.getTarget()){

                protected boolean validate() {
                    boolean bl = this.parentNewModifierPage.validatePage();
                    return bl;
                }
            };
            featureModifierEditComposite.setLayout((Layout)new RowLayout());
            Label label = new Label((Composite)featureModifierEditComposite, 0);
            STEMTimeRangeModifier sTEMTimeRangeModifier = (STEMTimeRangeModifier)this.getFeatureModifier();
            sTEMTimeRangeModifier.setStartValue((STEMTime)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature()));
            sTEMTimeRangeModifier.setEndValue(sTEMTimeRangeModifier.getStartValue());
            StringBuilder stringBuilder = new StringBuilder(sTEMTimeRangeModifier.getStartValue().toString());
            stringBuilder.append(" to ");
            stringBuilder.append(sTEMTimeRangeModifier.getEndValue().toString());
            stringBuilder.append(" by ");
            stringBuilder.append(sTEMTimeRangeModifier.getIncrement());
            label.setText(stringBuilder.toString());
            return featureModifierEditComposite;
        }
    }
}

