/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.provider.CommonItemProviderAdapterFactory;
import org.eclipse.stem.core.experiment.provider.ExperimentItemProviderAdapterFactory;
import org.eclipse.stem.core.graph.provider.GraphItemProviderAdapterFactory;
import org.eclipse.stem.core.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.stem.core.scenario.provider.ScenarioItemProviderAdapterFactory;
import org.eclipse.stem.core.sequencer.provider.SequencerItemProviderAdapterFactory;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.PropertySheet;

public abstract class IdentifiableEditor
extends MultiPageEditorPart
implements IMenuListener,
ISelectionProvider,
IEditingDomainProvider {
    protected static final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected Viewer currentViewer;
    private final WorkspaceModifyOperation saveOperation = new WorkspaceModifyOperation(){

        protected void execute(IProgressMonitor iProgressMonitor) {
            for (Resource resource : IdentifiableEditor.this.editingDomain.getResourceSet().getResources()) {
                if (resource.getContents().isEmpty() || IdentifiableEditor.this.editingDomain.isReadOnly(resource)) continue;
                try {
                    resource.save(saveOptions);
                }
                catch (Exception exception) {
                    Activator.logError((String)"Problem saving", (Throwable)exception);
                }
            }
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (!(iWorkbenchPart instanceof ContentOutline) && !(iWorkbenchPart instanceof PropertySheet) && iWorkbenchPart == IdentifiableEditor.this) {
                IdentifiableEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            IdentifiableEditor.this.setSelection(selectionChangedEvent.getSelection());
        }
    };
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;

    static {
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
    }

    public IdentifiableEditor() {
        this.adapterFactory = this.createAdapterFactory();
        this.editingDomain = this.createEditingDomain((AdapterFactory)this.adapterFactory);
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new CommonItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ExperimentItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new GraphItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ModelItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ScenarioItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new SequencerItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return composedAdapterFactory;
    }

    private AdapterFactoryEditingDomain createEditingDomain(AdapterFactory adapterFactory) {
        BasicCommandStack basicCommandStack = new BasicCommandStack();
        basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject eventObject) {
                IdentifiableEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IdentifiableEditor.this.firePropertyChange(257);
                        Command command = ((CommandStack)eventObject.getSource()).getMostRecentCommand();
                        if (command != null) {
                            this.setSelectionToViewer(command.getAffectedObjects());
                        }
                    }

                    private void setSelectionToViewer(final Collection<?> collection) {
                        if (collection != null && !collection.isEmpty()) {
                            new Runnable(){

                                public void run() {
                                    if (((this).this).IdentifiableEditor.this.currentViewer != null) {
                                        ((this).this).IdentifiableEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection((Object)collection));
                                    }
                                }
                            }.run();
                        }
                    }
                });
            }
        });
        return new AdapterFactoryEditingDomain(adapterFactory, (CommandStack)basicCommandStack, new HashMap()){

            public Command createCommand(Class<? extends Command> clazz, CommandParameter commandParameter) {
                if (clazz == DeleteCommand.class) {
                    return super.createCommand(clazz, commandParameter);
                }
                return super.createCommand(clazz, commandParameter);
            }
        };
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        iEditorSite.setSelectionProvider((ISelectionProvider)this);
        iEditorSite.getPage().addPartListener(this.partListener);
    }

    protected void createPages() {
        this.loadIdentifiable();
        if (!this.editingDomain.getResourceSet().getResources().isEmpty() && !((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            TreeViewer treeViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)treeViewer);
            treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            treeViewer.setInput(this.editingDomain.getResourceSet().getResources().get(0));
            new AdapterFactoryTreeEditor(treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenu((StructuredViewer)treeViewer);
            this.addDragNDropSupport((StructuredViewer)treeViewer);
            int n = this.addPage((Control)tree);
            this.setPageText(n, "tree editor");
            this.createIdentifiableSpecificPages();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IdentifiableEditor.this.setActivePage(0);
                }
            });
        }
    }

    private void loadIdentifiable() {
        URI uRI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            this.editingDomain.getResourceSet().getResource(uRI, true);
        }
        catch (Exception exception) {
            this.editingDomain.getResourceSet().getResource(uRI, false);
        }
    }

    private void setCurrentViewer(Viewer viewer) {
        if (viewer != this.currentViewer) {
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(viewer == null ? StructuredSelection.EMPTY : viewer.getSelection()));
        }
    }

    private void createContextMenu(StructuredViewer structuredViewer) {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)structuredViewer);
    }

    private void addDragNDropSupport(StructuredViewer structuredViewer) {
        Transfer[] transferArray = new Transfer[]{LocalTransfer.getInstance(), TextTransfer.getInstance()};
        structuredViewer.addDragSupport(7, transferArray, (DragSourceListener)new ViewerDragAdapter((Viewer)structuredViewer));
        structuredViewer.addDropSupport(7, transferArray, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)structuredViewer){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                dropTargetEvent.detail = 4;
                super.dragEnter(dropTargetEvent);
            }

            protected Collection<?> extractDragSource(Object object) {
                if (object instanceof Collection) {
                    return (Collection)object;
                }
                return super.extractDragSource(object);
            }
        });
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(iMenuManager);
    }

    protected EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
    }

    protected void createIdentifiableSpecificPages() {
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)this.saveOperation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            Activator.logError((String)"Problem saving", (Throwable)exception);
        }
    }

    public void doSaveAs() {
        IFile iFile;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath != null && (iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true), new FileEditorInput(iFile));
        }
    }

    private void doSaveAs(URI uRI, FileEditorInput fileEditorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uRI);
        this.setInputWithNotify((IEditorInput)fileEditorInput);
        this.setPartName(fileEditorInput.getName());
        EditingDomainActionBarContributor editingDomainActionBarContributor = (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
        IStatusLineManager iStatusLineManager = editingDomainActionBarContributor.getActionBars().getStatusLineManager();
        IProgressMonitor iProgressMonitor = iStatusLineManager != null ? iStatusLineManager.getProgressMonitor() : new NullProgressMonitor();
        this.doSave(iProgressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection iSelection) {
        this.editorSelection = iSelection;
        for (ISelectionChangedListener iSelectionChangedListener : this.selectionChangedListeners) {
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
        }
    }
}

