/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class EditorActionProvider
extends CommonActionProvider {
    IAction openAction = null;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        ICommonViewerSite iCommonViewerSite = iCommonActionExtensionSite.getViewSite();
        if (iCommonViewerSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite iCommonViewerWorkbenchSite = (ICommonViewerWorkbenchSite)iCommonViewerSite;
            this.openAction = new OpenIdentifiableAction(iCommonViewerWorkbenchSite.getPage(), iCommonViewerWorkbenchSite.getSelectionProvider());
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        if (this.openAction.isEnabled()) {
            iActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.openAction);
        }
    }

    public static class OpenIdentifiableAction
    extends AbstractAction
    implements IAction {
        private final IWorkbenchPage page;
        private final ISelectionProvider selectionProvider;
        private Identifiable selectedIdentifiable;

        public OpenIdentifiableAction(IWorkbenchPage iWorkbenchPage, ISelectionProvider iSelectionProvider) {
            this.page = iWorkbenchPage;
            this.selectionProvider = iSelectionProvider;
        }

        public void run() {
            Path path = new Path(this.selectedIdentifiable.getURI().toPlatformString(true));
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (iFile != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)this.page, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    Activator.logError("Problem opening editor", partInitException);
                }
            } else {
                Activator.logError("Could not find file \"" + path.toString() + "\"", null);
            }
        }

        public boolean isEnabled() {
            IStructuredSelection iStructuredSelection;
            boolean bl = false;
            ISelection iSelection = this.selectionProvider.getSelection();
            if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof Identifiable) {
                this.selectedIdentifiable = (Identifiable)iStructuredSelection.getFirstElement();
                bl = true;
            }
            return bl;
        }

        public int getAccelerator() {
            return 0;
        }

        public String getActionDefinitionId() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public ImageDescriptor getDisabledImageDescriptor() {
            return null;
        }

        public HelpListener getHelpListener() {
            return null;
        }

        public ImageDescriptor getHoverImageDescriptor() {
            return null;
        }

        public String getId() {
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public IMenuCreator getMenuCreator() {
            return null;
        }

        public int getStyle() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public boolean isChecked() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }

        public void runWithEvent(Event event) {
        }

        public void setAccelerator(int n) {
        }

        public void setActionDefinitionId(String string) {
        }

        public void setChecked(boolean bl) {
        }

        public void setDescription(String string) {
        }

        public void setDisabledImageDescriptor(ImageDescriptor imageDescriptor) {
        }

        public void setEnabled(boolean bl) {
        }

        public void setHelpListener(HelpListener helpListener) {
        }

        public void setHoverImageDescriptor(ImageDescriptor imageDescriptor) {
        }

        public void setId(String string) {
        }

        public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        }

        public void setMenuCreator(IMenuCreator iMenuCreator) {
        }

        public void setText(String string) {
        }

        public void setToolTipText(String string) {
        }
    }
}

