/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.jobs.execution.IExecutable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class STEMExecutionCommandHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        boolean bl = false;
        ISelection iSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection) {
            for (Object e : ((StructuredSelection)iSelection).toList()) {
                IExecutable iExecutable = (IExecutable)Platform.getAdapterManager().getAdapter(e, IExecutable.class);
                if (iExecutable != null) {
                    bl = true;
                    this.doit(iExecutable);
                    continue;
                }
                Activator.logError("STEM Internal error execution command applied to \"" + e.getClass().getName() + "\"", null);
            }
        }
        if (bl) {
            Activator.switchToPerspective("org.eclipse.stem.ui.STEMSimulationPerspective");
        }
        return null;
    }

    protected abstract void doit(IExecutable var1);

    public static class PauseCommandHandler
    extends STEMExecutionCommandHandler {
        protected void doit(IExecutable iExecutable) {
            iExecutable.pause();
        }
    }

    public static class ResetCommandHandler
    extends STEMExecutionCommandHandler {
        protected void doit(IExecutable iExecutable) {
            iExecutable.reset();
        }
    }

    public static class RunCommandHandler
    extends STEMExecutionCommandHandler {
        protected void doit(IExecutable iExecutable) {
            iExecutable.run();
        }
    }

    public static class StepCommandHandler
    extends STEMExecutionCommandHandler {
        protected void doit(IExecutable iExecutable) {
            iExecutable.step();
        }
    }

    public static class StopCommandHandler
    extends STEMExecutionCommandHandler {
        protected void doit(IExecutable iExecutable) {
            iExecutable.stop();
        }
    }
}

