/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.preferences.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SolverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final int DEFAULT_SIMULATION_THREADS = 2;
    public static final String DEFAULT_SOLVER = "org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl";

    public SolverPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("DMPPageTITLE"));
    }

    public void createFieldEditors() {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor("simulationThreads", Messages.getString("DMPPageSimThreads"), this.getFieldEditorParent());
        this.addField((FieldEditor)integerFieldEditor);
        Solver[] solverArray = SolverPreferencePage.getSolvers();
        String[][] stringArray = new String[solverArray.length][solverArray.length];
        int n = 0;
        while (n < solverArray.length) {
            stringArray[n][0] = solverArray[n].getClass().getSimpleName();
            stringArray[n][1] = solverArray[n].getClass().getName();
            ++n;
        }
        ComboFieldEditor comboFieldEditor = new ComboFieldEditor("defaultSolver", Messages.getString("DMPPageDefaultSolver"), stringArray, this.getFieldEditorParent());
        this.addField((FieldEditor)comboFieldEditor);
    }

    public static Solver[] getSolvers() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.stem.core.solver");
        ArrayList<Solver> arrayList = new ArrayList<Solver>();
        Solver[] solverArray = new Solver[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("classdef")) {
                try {
                    arrayList.add((Solver)iConfigurationElement.createExecutableExtension("class"));
                }
                catch (CoreException coreException) {
                    Activator.logError("Can't create solver", coreException);
                }
            }
            ++n;
        }
        solverArray = arrayList.toArray(new Solver[0]);
        return solverArray;
    }

    public void init(IWorkbench iWorkbench) {
    }
}

