/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.batch.BatchManager;
import org.eclipse.stem.jobs.batch.BatchManagerEvent;
import org.eclipse.stem.jobs.batch.IBatch;
import org.eclipse.stem.jobs.batch.IBatchManagerListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class ActiveBatchesView
extends ViewPart {
    public static final String ID_ACTIVE_BATCHES_VIEW = "org.eclipse.stem.ui.views.activebatches";
    private ListViewer lv = null;

    public void createPartControl(Composite composite) {
        this.lv = new ListViewer(composite);
        this.lv.setContentProvider((IContentProvider)new ActiveBatchesContentProvider());
        this.lv.setLabelProvider((IBaseLabelProvider)new ActiveBatchesLabelProvider());
        this.lv.setInput((Object)BatchManager.INSTANCE);
        this.getSite().setSelectionProvider((ISelectionProvider)this.lv);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.getSite().setSelectionProvider(null);
        this.lv = null;
    }

    protected static class ActiveBatchesContentProvider
    implements IStructuredContentProvider,
    IBatchManagerListener {
        private ListViewer viewer = null;
        private BatchManager batchManager = null;

        protected ActiveBatchesContentProvider() {
        }

        public Object[] getElements(Object object) {
            return ((BatchManager)object).getActiveBatches().toArray();
        }

        public void dispose() {
            this.viewer = null;
            this.batchManager = null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.viewer = (ListViewer)viewer;
            if (this.batchManager != null) {
                this.batchManager.removeListener((IBatchManagerListener)this);
            }
            this.batchManager = (BatchManager)object2;
            if (this.batchManager != null) {
                this.batchManager.addBatchManagerListener((IBatchManagerListener)this);
            }
        }

        public void batchesChanged(BatchManagerEvent batchManagerEvent) {
            this.viewer.getList().setRedraw(false);
            try {
                this.viewer.remove((Object[])batchManagerEvent.getBatchesRemoved());
                this.viewer.add((Object[])batchManagerEvent.getBatchesAdded());
            }
            finally {
                this.viewer.getList().setRedraw(true);
            }
        }
    }

    protected static class ActiveBatchesLabelProvider
    implements ILabelProvider {
        protected ActiveBatchesLabelProvider() {
        }

        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            IBatch iBatch = (IBatch)object;
            return iBatch.getNameWithSequenceNumber();
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

