/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public abstract class ExecutablePluginView
extends ViewPart {
    private ListViewer lv;

    protected abstract ExecutableViewModel getInput();

    public void createPartControl(Composite composite) {
        this.lv = new ListViewer(composite);
        this.lv.setContentProvider((IContentProvider)new ExecutableContentProvider());
        this.lv.setLabelProvider((IBaseLabelProvider)new ExecutableLabelProvider());
        this.lv.setInput((Object)this.getInput());
        this.getSite().setSelectionProvider((ISelectionProvider)this.lv);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    public static class ExecutableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            return ((ExecutableViewModel)object).getExecutables().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    protected static class ExecutableLabelProvider
    implements ILabelProvider {
        protected ExecutableLabelProvider() {
        }

        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
            String string = iConfigurationElement.getAttribute("name");
            return string;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ExecutableViewModel {
        private List<IConfigurationElement> executables = new ArrayList<IConfigurationElement>();

        protected ExecutableViewModel(String string, String string2) {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (string2.equals(iConfigurationElement.getName())) {
                    this.executables.add(iConfigurationElement);
                } else {
                    Activator.logError(MessageFormat.format(Messages.getString("IPView.Unexpected_Element"), iConfigurationElement.getName(), string), null);
                }
                ++n;
            }
        }

        protected final List<IConfigurationElement> getExecutables() {
            return this.executables;
        }
    }
}

