/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.jobs.execution.IExecutable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.IdentifiableDelegate;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class IdentifiablePluginView
extends ViewPart {
    protected TreeViewer treeViewer;
    private DublinCoreToolTipHandler dcTTipHandler;
    protected ISelection selection;
    protected Map<URI, Identifiable> deserializedIdentifiablesMap = new HashMap<URI, Identifiable>();

    public void createPartControl(Composite composite) {
        this.dcTTipHandler = new DublinCoreToolTipHandler(composite.getShell());
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.setContentProvider((IContentProvider)new IdentifiablePluginViewTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getIdentifiablePluginViewLabelContentProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.getInput());
        this.dcTTipHandler.addDCToolTipHelp((Control)this.treeViewer.getTree());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("execution"));
        this.treeViewer.getControl().setMenu(menuManager.createContextMenu(this.treeViewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IExecutable iExecutable = (IExecutable)Platform.getAdapterManager().getAdapter(((StructuredSelection)doubleClickEvent.getSelection()).toList().get(0), IExecutable.class);
                if (iExecutable != null) {
                    iExecutable.run();
                    Activator.switchToPerspective("org.eclipse.stem.ui.STEMSimulationPerspective");
                }
            }
        });
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getTransfer(), LocalTransfer.getInstance()};
        this.treeViewer.addDragSupport(7, transferArray, new DragSourceListener(){

            public void dragStart(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.doit = true;
                IdentifiablePluginView.this.selection = IdentifiablePluginView.this.treeViewer.getSelection();
            }

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = this.extractURIStringsFromIdentifiableDelegates((IStructuredSelection)IdentifiablePluginView.this.selection);
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)((IStructuredSelection)dragSourceEvent.data));
                } else if (LocalTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                    dragSourceEvent.data = this.extractURIStringsFromIdentifiableDelegates((IStructuredSelection)IdentifiablePluginView.this.selection);
                }
            }

            private IStructuredSelection extractURIStringsFromIdentifiableDelegates(IStructuredSelection iStructuredSelection) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object e : iStructuredSelection) {
                    String string;
                    if (!(e instanceof IdentifiableDelegate) || (string = ((IdentifiableDelegate)e).getDublinCore().getIdentifier()) == null) continue;
                    arrayList.add(string);
                }
                return new IStructuredSelection(arrayList){
                    final List<String> list;
                    {
                        this.list = list;
                    }

                    public Object getFirstElement() {
                        return this.list.get(0);
                    }

                    public Iterator<String> iterator() {
                        return this.list.iterator();
                    }

                    public int size() {
                        return this.list.size();
                    }

                    public Object[] toArray() {
                        return this.list.toArray();
                    }

                    public List<String> toList() {
                        return this.list;
                    }

                    public boolean isEmpty() {
                        return this.list.isEmpty();
                    }
                };
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
                IdentifiablePluginView.this.selection = null;
                LocalTransfer.getInstance().javaToNative(null, null);
            }
        });
    }

    public void setFocus() {
    }

    protected abstract IdentifiableViewModel getInput();

    protected abstract IdentifiablePluginViewLabelContentProvider getIdentifiablePluginViewLabelContentProvider();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Category
    implements Comparable<Object> {
        Category parent;
        String parentId;
        String categoryId;
        String categoryName;
        List<Category> childCategories;
        List<IdentifiableDelegate> childIdentifiables;

        protected Category(String string, String string2, String string3) {
            this.categoryName = string;
            this.categoryId = string2;
            this.parentId = string3;
            this.parent = null;
            this.childCategories = new ArrayList<Category>();
            this.childIdentifiables = new ArrayList<IdentifiableDelegate>();
        }

        protected Category(IConfigurationElement iConfigurationElement) {
            this(Category.getNLSCatagoryName(iConfigurationElement.getAttribute("name")), iConfigurationElement.getAttribute("id"), iConfigurationElement.getAttribute("parent_id"));
        }

        public void addChildCategory(Category category) {
            this.childCategories.add(category);
        }

        public void addIdentifiableDelegate(IdentifiableDelegate identifiableDelegate) {
            this.childIdentifiables.add(identifiableDelegate);
        }

        private static String getNLSCatagoryName(String string) {
            String string2 = GeographicNames.getName((String)string);
            return string2.startsWith("!") ? string : string2;
        }

        protected final String getCategoryId() {
            return this.categoryId;
        }

        protected final String getParentId() {
            return this.parentId;
        }

        protected final Category getParent() {
            return this.parent;
        }

        protected final void setParent(Category category) {
            this.parent = category;
        }

        public Object[] getChildren() {
            ArrayList<Comparable<Object>> arrayList = new ArrayList<Comparable<Object>>();
            Collections.sort(this.childCategories);
            Collections.sort(this.childIdentifiables);
            arrayList.addAll(this.childCategories);
            arrayList.addAll(this.childIdentifiables);
            return arrayList.toArray();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.categoryName);
            stringBuilder.append(", ");
            stringBuilder.append(this.categoryId);
            stringBuilder.append(", ");
            stringBuilder.append(this.parentId);
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.categoryId == null ? 0 : this.categoryId.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Category category = (Category)object;
            return !(this.categoryId == null ? category.categoryId != null : !this.categoryId.equals(category.categoryId));
        }

        @Override
        public int compareTo(Object object) {
            int n = 0;
            if (object instanceof Category) {
                Category category = (Category)object;
                n = this.categoryName.compareTo(category.categoryName);
            } else if (object instanceof IdentifiableDelegate) {
                n = 1;
            }
            return n;
        }
    }

    private static class DublinCoreToolTipHandler {
        protected static final int Y_OFFSET = 16;
        protected Shell dcTipShell;
        Label dcDescriptionText;
        Label dcCreatorText;
        Label dcValidText;
        Label dcSourceText;

        DublinCoreToolTipHandler(Shell shell) {
            Display display = shell.getDisplay();
            this.dcTipShell = new Shell(shell, 16388);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            this.dcTipShell.setLayout((Layout)gridLayout);
            Color color = display.getSystemColor(29);
            Color color2 = display.getSystemColor(28);
            this.dcTipShell.setBackground(color);
            this.dcDescriptionText = this.createDCAttributeLabel(this.dcTipShell, color, color2);
            this.dcCreatorText = this.createDCAttributeLabel(this.dcTipShell, color, color2);
            this.dcValidText = this.createDCAttributeLabel(this.dcTipShell, color, color2);
            this.dcSourceText = this.createDCAttributeLabel(this.dcTipShell, color, color2);
            this.dcTipShell.pack();
        }

        private Label createDCAttributeLabel(Shell shell, Color color, Color color2) {
            Label label = new Label((Composite)shell, 0);
            label.setBackground(color);
            label.setForeground(color2);
            label.setLayoutData((Object)new GridData(772));
            return label;
        }

        public void addDCToolTipHelp(final Control control) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    if (DublinCoreToolTipHandler.this.dcTipShell.isVisible()) {
                        DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                    }
                }
            });
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent mouseEvent) {
                    Point point = new Point(mouseEvent.x, mouseEvent.y);
                    if (mouseEvent.widget instanceof Tree) {
                        Tree tree = (Tree)mouseEvent.widget;
                        TreeItem treeItem = tree.getItem(point);
                        if (treeItem != null) {
                            Object object = treeItem.getData();
                            if (object instanceof IdentifiableDelegate) {
                                IdentifiableDelegate identifiableDelegate = (IdentifiableDelegate)object;
                                DublinCoreImpl dublinCoreImpl = identifiableDelegate.getDublinCore();
                                String string = dublinCoreImpl.getDescription();
                                String string2 = dublinCoreImpl.getCreator();
                                String string3 = dublinCoreImpl.getValid();
                                String string4 = dublinCoreImpl.getSource();
                                if (string != null && !string.equals("")) {
                                    DublinCoreToolTipHandler.this.dcDescriptionText.setText(string);
                                    DublinCoreToolTipHandler.this.dcDescriptionText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcDescriptionText.setVisible(false);
                                }
                                if (string2 != null && !string2.equals("")) {
                                    DublinCoreToolTipHandler.this.dcCreatorText.setText(string2);
                                    DublinCoreToolTipHandler.this.dcCreatorText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcCreatorText.setVisible(false);
                                }
                                if (string3 != null && !string3.equals("")) {
                                    DublinCoreToolTipHandler.this.dcValidText.setText(string3);
                                    DublinCoreToolTipHandler.this.dcValidText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcValidText.setVisible(false);
                                }
                                if (string4 != null && !string4.equals("")) {
                                    DublinCoreToolTipHandler.this.dcSourceText.setText(string4);
                                    DublinCoreToolTipHandler.this.dcSourceText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcSourceText.setVisible(false);
                                }
                                DublinCoreToolTipHandler.this.dcTipShell.pack();
                                DublinCoreToolTipHandler.this.dcTipShell.setBounds(this.computeHoverLocation(DublinCoreToolTipHandler.this.dcTipShell, control.toDisplay(point)));
                                DublinCoreToolTipHandler.this.dcTipShell.setVisible(true);
                            } else {
                                DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                            }
                        } else {
                            DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                        }
                    }
                }

                private Rectangle computeHoverLocation(Shell shell, Point point) {
                    Rectangle rectangle = shell.getBounds();
                    Rectangle rectangle2 = shell.getDisplay().getBounds();
                    rectangle.x = Math.max(Math.min(point.x, rectangle2.width - rectangle.width), 0);
                    rectangle.y = Math.max(Math.min(point.y + 16, rectangle2.height - rectangle.height), 0);
                    return rectangle;
                }

                public void mouseExit(MouseEvent mouseEvent) {
                    if (DublinCoreToolTipHandler.this.dcTipShell.isVisible()) {
                        DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                    }
                }
            });
        }
    }

    protected static abstract class IdentifiablePluginViewLabelContentProvider
    implements ILabelProvider {
        private static Image categoryIcon = null;
        static boolean categoryIconFirstTime = true;
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

        public Image getImage(Object object) {
            Image image = null;
            if (object instanceof Category) {
                image = this.getCategoryIcon();
            }
            return image;
        }

        protected Image getCategoryIcon() {
            if (categoryIconFirstTime && categoryIcon == null) {
                categoryIconFirstTime = false;
                categoryIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return categoryIcon;
        }

        public String getText(Object object) {
            String string = "";
            if (object instanceof Category) {
                Category category = (Category)object;
                string = category.categoryName;
            } else if (object instanceof IdentifiableDelegate) {
                IdentifiableDelegate identifiableDelegate = (IdentifiableDelegate)object;
                string = identifiableDelegate.toString();
            }
            return string;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.add(iLabelProviderListener);
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.listeners.remove(iLabelProviderListener);
        }
    }

    protected static class IdentifiablePluginViewTreeContentProvider
    implements ITreeContentProvider {
        protected IdentifiablePluginViewTreeContentProvider() {
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = null;
            if (object instanceof Category) {
                Category category = (Category)object;
                ArrayList<Comparable<Object>> arrayList = new ArrayList<Comparable<Object>>();
                Collections.sort(category.childCategories);
                Collections.sort(category.childIdentifiables);
                arrayList.addAll(category.childCategories);
                arrayList.addAll(category.childIdentifiables);
                objectArray = arrayList.toArray();
            }
            return objectArray;
        }

        public Object getParent(Object object) {
            Object object2 = null;
            object2 = object instanceof Category ? ((Category)object).parent : ((IdentifiableDelegate)object).getParent();
            return object2;
        }

        public boolean hasChildren(Object object) {
            boolean bl = false;
            if (object instanceof Category) {
                Category category = (Category)object;
                bl = category.childCategories.size() > 0 || category.childIdentifiables.size() > 0;
            }
            return bl;
        }

        public Object[] getElements(Object object) {
            IdentifiableViewModel identifiableViewModel = (IdentifiableViewModel)object;
            Arrays.sort(identifiableViewModel.getRoot().getChildren());
            return identifiableViewModel.getRoot().getChildren();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    protected static abstract class IdentifiableViewModel {
        private final Category root = new Category("/", "/", "");
        private final Map<String, Category> categoryMap = new HashMap<String, Category>();

        public IdentifiableViewModel(String string) {
            IConfigurationElement iConfigurationElement;
            IConfigurationElement[] iConfigurationElementArray;
            this.categoryMap.put(this.root.getCategoryId(), this.root);
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                iConfigurationElement = iConfigurationElementArray2[n2];
                if ("stem_category".equals(iConfigurationElement.getName())) {
                    this.addCategory(iConfigurationElement);
                }
                ++n2;
            }
            this.resolveCategories();
            iConfigurationElementArray2 = iConfigurationElementArray;
            n = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n) {
                iConfigurationElement = iConfigurationElementArray2[n2];
                if (!"stem_category".equals(iConfigurationElement.getName())) {
                    if ("dublin_core".equals(iConfigurationElement.getName())) {
                        Category category = this.root;
                        String string2 = iConfigurationElement.getAttribute("category_id");
                        if (string2 != null) {
                            category = this.categoryMap.get(string2);
                            if (category == null) {
                                Activator.logError(MessageFormat.format(Messages.getString("IPView.No_Category"), string2), null);
                                category = this.root;
                            }
                            category = category == null ? this.root : category;
                        }
                        this.addIdentifiableDelegate(category, iConfigurationElement);
                    } else if (iConfigurationElement.getAttribute("name") != null) {
                        this.addIdentifiableDelegate(this.root, iConfigurationElement);
                    } else {
                        Activator.logError(MessageFormat.format(Messages.getString("IPView.Unexpected_Element"), iConfigurationElement.getName(), string), null);
                    }
                }
                ++n2;
            }
        }

        private void addIdentifiableDelegate(Category category, IConfigurationElement iConfigurationElement) {
            IdentifiableDelegate identifiableDelegate = new IdentifiableDelegate(iConfigurationElement);
            category.addIdentifiableDelegate(identifiableDelegate);
        }

        private Category addCategory(IConfigurationElement iConfigurationElement) {
            Category category = new Category(iConfigurationElement);
            Category category2 = this.categoryMap.get(category.getCategoryId());
            if (category2 == null) {
                category2 = category;
                this.categoryMap.put(category.getCategoryId(), category);
            }
            return category2;
        }

        private void resolveCategories() {
            for (Category category : this.categoryMap.values()) {
                if (category == this.root) continue;
                Category category2 = this.categoryMap.get(category.getParentId());
                if (category2 == null) {
                    Activator.logInformation("When organizing categories, the specified parent category \"" + category.getParentId() + "\" for the category \"" + category.getCategoryId() + "\" could not be found.  Using \"/\" instead.", null);
                    category2 = this.root;
                }
                category.setParent(category2);
                category2.addChildCategory(category);
            }
        }

        protected final Category getRoot() {
            return this.root;
        }
    }
}

