/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class SimulationControl
extends Composite
implements ISimulationListener,
ControlListener {
    protected ISimulation simulation = null;
    private boolean reset = false;
    private static ImageRegistry imageRegistry = null;
    private static ColorRegistry colorRegistry = null;
    private static FontRegistry fontRegistry = null;
    private Composite mainContainer = null;
    private Composite btnContainer = null;
    private Text simulationProgressText;
    private Text simulationStateText;
    private Text simulationTimeText;
    private ProgressBar pb = null;
    private Text simulationTitleText = null;
    private static int BEGIN_WORK = 0;
    private boolean UNKNOWN_DURATION = false;
    private static final int STANDARD_LENGTH = 100;
    private static final int STANDARD_HEIGHT = 18;
    private static final int CONTAINER_HEIGHT = 225;
    private static final int MARGIN = 10;

    public SimulationControl(Composite composite, ISimulation iSimulation) {
        super(composite, 0);
        Activator activator;
        iSimulation.addSimulationListener((ISimulationListener)this);
        this.simulation = iSimulation;
        Sequencer sequencer = iSimulation.getScenario().getSequencer();
        boolean bl = this.UNKNOWN_DURATION = sequencer.getDuration() == -1L;
        if (imageRegistry == null) {
            activator = Activator.getDefault();
            imageRegistry = activator.getImageRegistry();
        }
        if (colorRegistry == null) {
            activator = Activator.getDefault();
            colorRegistry = activator.getColorRegistry();
        }
        if (fontRegistry == null) {
            activator = Activator.getDefault();
            fontRegistry = activator.getFontRegistry();
        }
        this.setLayoutData(new GridData(4, 0, true, false));
        this.createContents(this);
        composite.redraw();
    }

    public void controlResized(ControlEvent controlEvent) {
        Rectangle rectangle = null;
        if (this.getParent() != null && this.getParent().getParent() != null) {
            rectangle = this.getParent().getParent().getClientArea();
        }
        if (rectangle == null) {
            return;
        }
        int n = rectangle.width - 50;
        int n2 = 18;
        Rectangle rectangle2 = this.computeTrim(this.pb.getBounds().x, this.pb.getBounds().y, n, n2);
        Rectangle rectangle3 = this.computeTrim(this.simulationTitleText.getBounds().x, this.simulationTitleText.getBounds().y, n, n2);
        Rectangle rectangle4 = this.computeTrim(this.simulationStateText.getBounds().x, this.simulationStateText.getBounds().y, n, n2);
        Rectangle rectangle5 = this.computeTrim(this.simulationTimeText.getBounds().x, this.simulationTimeText.getBounds().y, n, n2);
        Rectangle rectangle6 = this.computeTrim(this.simulationProgressText.getBounds().x, this.simulationProgressText.getBounds().y, n, n2);
        Rectangle rectangle7 = this.computeTrim(rectangle.x, rectangle.y, rectangle.width - 10, 225);
        Rectangle rectangle8 = this.computeTrim(this.btnContainer.getBounds().x, this.btnContainer.getBounds().y, n, n2 + 20);
        this.pb.setBounds(rectangle2);
        this.simulationTitleText.setBounds(rectangle3);
        this.simulationStateText.setBounds(rectangle4);
        this.simulationTimeText.setBounds(rectangle5);
        this.simulationProgressText.setBounds(rectangle6);
        this.btnContainer.setBounds(rectangle8);
        this.mainContainer.setBounds(rectangle7);
        this.mainContainer.redraw();
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    protected void resetProgressBar() {
        if (this.pb == null || this.pb.isDisposed()) {
            return;
        }
        this.pb.setMinimum(BEGIN_WORK);
        this.pb.setMaximum(100);
        this.pb.setSelection(BEGIN_WORK);
        this.pb.redraw();
    }

    protected void updateStateLabel(SimulationState simulationState) {
        if (this.simulationStateText == null || this.simulationStateText.isDisposed()) {
            return;
        }
        Rectangle rectangle = this.simulationStateText.getBounds();
        if (simulationState.equals((Object)SimulationState.RUNNING) || simulationState.equals((Object)SimulationState.COMPLETED_CYCLE)) {
            this.simulationStateText.setText(Messages.getString("SCtrl.Running"));
            this.simulationStateText.setBackground(colorRegistry.get("green"));
        } else if (simulationState.equals((Object)SimulationState.PAUSED)) {
            this.simulationStateText.setText(Messages.getString("SCtrl.Paused"));
            this.simulationStateText.setBackground(colorRegistry.get("yellow"));
        } else if (simulationState.equals((Object)SimulationState.RESET)) {
            this.simulationStateText.setText(Messages.getString("SCtrl.Reset"));
            this.simulationStateText.setBackground(colorRegistry.get("orange"));
            this.pb.setSelection(0);
        }
        this.simulationStateText.setBounds(rectangle);
        this.simulationStateText.redraw();
    }

    protected void updateProgressLabel(int n, SimulationState simulationState) {
        Rectangle rectangle = this.simulationProgressText.getBounds();
        Sequencer sequencer = this.simulation.getScenario().getSequencer();
        int n2 = sequencer.getCycle();
        if (this.UNKNOWN_DURATION) {
            this.simulationProgressText.setText(String.valueOf(Messages.getString("SCtrl.Progress")) + " : unknown duration");
            n2 %= 100;
        } else if (n <= 100) {
            this.simulationProgressText.setText(String.valueOf(Messages.getString("SCtrl.Progress")) + " : " + n + "%");
        }
        this.simulationProgressText.setBounds(rectangle);
        this.simulationProgressText.redraw();
        this.pb.setSelection(n2);
    }

    protected void updateTimeLabel(SimulationState simulationState) {
        Rectangle rectangle = this.simulationTimeText.getBounds();
        Sequencer sequencer = this.simulation.getScenario().getSequencer();
        STEMTime sTEMTime = sequencer.getCurrentTime();
        if (!simulationState.name().equals("RUNNING")) {
            simulationState.name().equals("COMPLETED_CYCLE");
        }
        if (sequencer.getCycle() > 0 && this.reset) {
            this.reset = false;
            return;
        }
        String string = "[" + sequencer.getCycle() + "] " + Messages.getString("SCtrl.Time") + " : " + sTEMTime.toString();
        this.simulationTimeText.setText(string);
        this.simulationTimeText.setToolTipText(string);
        this.simulationTimeText.setBounds(rectangle);
        this.simulationTimeText.redraw();
    }

    public ISimulation getSimulation() {
        return this.simulation;
    }

    private void createContents(Composite composite) {
        this.mainContainer = new Composite(composite, 67584);
        this.mainContainer.setLayoutData((Object)this.getMainContainerGridData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.mainContainer.setLayout((Layout)gridLayout);
        this.simulationTitleText = new Text(this.mainContainer, 66);
        this.simulationTitleText.setText(this.simulation.getNameWithSequenceNumber());
        this.simulationTitleText.setToolTipText(this.simulation.getName());
        this.simulationTitleText.setBackground(colorRegistry.get("gray"));
        this.simulationTitleText.setFont(fontRegistry.get("default"));
        this.simulationTitleText.setEditable(false);
        this.simulationTitleText.setLayoutData((Object)this.getTextGridData());
        this.simulationProgressText = new Text(this.mainContainer, 67584);
        this.simulationProgressText.setBackground(colorRegistry.get("green"));
        this.simulationProgressText.setEditable(false);
        this.simulationProgressText.setFont(fontRegistry.get("default"));
        this.simulationProgressText.setLayoutData((Object)this.getTextGridData());
        this.simulationStateText = new Text(this.mainContainer, 67584);
        this.simulationStateText.setBackground(colorRegistry.get("green"));
        this.simulationStateText.setEditable(false);
        this.simulationStateText.setFont(fontRegistry.get("default"));
        this.simulationStateText.setLayoutData((Object)this.getTextGridData());
        this.pb = new ProgressBar(this.mainContainer, 67584);
        this.pb.setFont(fontRegistry.get("default"));
        this.pb.setLayoutData((Object)this.getProgressBarGridData());
        this.simulationTimeText = new Text(this.mainContainer, 67584);
        this.simulationTimeText.setBackground(colorRegistry.get("green"));
        this.simulationTimeText.setEditable(false);
        this.simulationTimeText.setFont(fontRegistry.get("default"));
        this.simulationTimeText.setLayoutData((Object)this.getTextGridData());
        this.createControlButtons(this.mainContainer);
        this.resetProgressBar();
        this.updateStateLabel(this.simulation.getSimulationState());
        this.updateProgressLabel(BEGIN_WORK, this.simulation.getSimulationState());
        this.updateTimeLabel(this.simulation.getSimulationState());
    }

    protected GridData getDefaultGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 18;
        gridData.minimumHeight = 18;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        gridData.horizontalAlignment = 16384;
        return gridData;
    }

    protected GridData getTextGridData() {
        GridData gridData = new GridData(4, 0, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 18;
        gridData.minimumHeight = 16;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    protected GridData getProgressBarGridData() {
        GridData gridData = new GridData(4, 0, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    protected GridData getMainContainerGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        gridData.heightHint = 225;
        gridData.minimumHeight = 225;
        return gridData;
    }

    protected GridData getButtonGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        gridData.heightHint = 26;
        gridData.minimumHeight = 16;
        return gridData;
    }

    protected void createControlButtons(Composite composite) {
        this.btnContainer = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = true;
        this.btnContainer.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 44;
        gridData.minimumHeight = 44;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        this.btnContainer.setLayoutData((Object)gridData);
        Button button = new Button(this.btnContainer, 8);
        Button button2 = new Button(this.btnContainer, 8);
        Button button3 = new Button(this.btnContainer, 8);
        Button button4 = new Button(this.btnContainer, 8);
        Button button5 = new Button(this.btnContainer, 8);
        button.setBackground(composite.getDisplay().getSystemColor(15));
        button.setToolTipText(Messages.getString("SCtrl.StartSim"));
        button.setLayoutData((Object)this.getButtonGridData());
        button2.setBackground(composite.getDisplay().getSystemColor(15));
        button2.setToolTipText(Messages.getString("SCtrl.PauseSim"));
        button2.setLayoutData((Object)this.getButtonGridData());
        button3.setBackground(composite.getDisplay().getSystemColor(15));
        button3.setToolTipText(Messages.getString("SCtrl.RestoreSim"));
        button3.setLayoutData((Object)this.getButtonGridData());
        button4.setBackground(composite.getDisplay().getSystemColor(15));
        button4.setToolTipText(Messages.getString("SCtrl.StepSim"));
        button4.setLayoutData((Object)this.getButtonGridData());
        button5.setBackground(composite.getDisplay().getSystemColor(15));
        button5.setToolTipText(Messages.getString("SCtrl.StopSim"));
        button5.setLayoutData((Object)this.getButtonGridData());
        button.setImage(imageRegistry.get("run.image"));
        button2.setImage(imageRegistry.get("pause.image"));
        button3.setImage(imageRegistry.get("reset.image"));
        button4.setImage(imageRegistry.get("step.image"));
        button5.setImage(imageRegistry.get("stop.image"));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        SimulationControl.this.run();
                    }
                }
            }
        });
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        SimulationControl.this.pause();
                    }
                }
            }
        });
        button3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        SimulationControl.this.reset();
                    }
                }
            }
        });
        button4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        SimulationControl.this.step();
                    }
                }
            }
        });
        button5.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        SimulationControl.this.stop();
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation = null;
        }
        if (this.mainContainer != null) {
            this.mainContainer.dispose();
        }
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        SimulationState simulationState = simulationEvent.getSimulationState();
        Sequencer sequencer = this.simulation.getScenario().getSequencer();
        if (sequencer == null) {
            return;
        }
        switch (simulationState) {
            case STOPPED: {
                return;
            }
            case COMPLETED_CYCLE: {
                int n = (int)sequencer.getWorkComplete();
                if (n >= 100) break;
                if (this.pb.isDisposed()) {
                    return;
                }
                this.pb.setSelection(n);
                this.updateProgressLabel(n, simulationState);
                break;
            }
            case RUNNING: {
                break;
            }
        }
        this.updateStateLabel(simulationState);
        this.updateTimeLabel(simulationState);
    }

    protected void resetTimeLabel() {
        this.simulationTimeText.setText("[ 0 ] " + Messages.getString("SCtrl.Time") + " : " + 0);
        this.simulationTimeText.redraw();
    }

    public void run() {
        this.simulation.run();
    }

    public void pause() {
        this.simulation.pause();
    }

    public void reset() {
        this.simulation.reset();
        this.reset = true;
        this.resetTimeLabel();
    }

    public void step() {
        this.simulation.step();
    }

    public void stop() {
        this.simulation.stop();
    }
}

