/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.stem.ui.views.SimulationControl;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationControlView
extends ViewPart
implements ISimulationManagerListener {
    private SimulationManager simulationManager = null;
    private List<SimulationControl> controlList = new ArrayList<SimulationControl>();
    public static final String ID_SIMULATION_CONTROL_VIEW = "org.eclipse.stem.ui.views.simulationcontrolview";
    private ScrolledComposite scrollComposite = null;
    private Composite controlComposite = null;
    Action runAction;
    Action resetAction;
    Action pauseAction;
    Action stepAction;
    Action stopAction;
    IActionBars actionBars = null;
    IMenuManager dropDownMenu = null;
    IToolBarManager toolBar = null;
    private static final int SCROLL_MIN_LENGTH = 100;
    private static final int SCROLL_MIN_HEIGTH = 1600;

    public SimulationControlView() {
        this.simulationManager = SimulationManager.getManager();
        this.simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
    }

    public void createPartControl(Composite composite) {
        this.scrollComposite = new ScrolledComposite(composite, 2560);
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
        this.scrollComposite.setMinSize(100, 1600);
        this.scrollComposite.setLayout((Layout)new GridLayout());
        this.controlComposite = new Composite((Composite)this.scrollComposite, 0);
        this.scrollComposite.setContent((Control)this.controlComposite);
        GridData gridData = new GridData(1808);
        this.controlComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.controlComposite.setLayout((Layout)gridLayout);
        this.runAction = new Action(Messages.getString("SCView.Run"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("run.image"))){

            public void run() {
                SimulationControlView.this.masterRunAction();
            }
        };
        this.pauseAction = new Action(Messages.getString("SCView.Pause"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("pause.image"))){

            public void run() {
                SimulationControlView.this.masterPauseAction();
            }
        };
        this.resetAction = new Action(Messages.getString("SCView.Reset"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("reset.image"))){

            public void run() {
                SimulationControlView.this.masterResetAction();
            }
        };
        this.stepAction = new Action(Messages.getString("SCView.Step"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("step.image"))){

            public void run() {
                SimulationControlView.this.masterStepAction();
            }
        };
        this.stopAction = new Action(Messages.getString("SCView.Stop"), ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("stop.image"))){

            public void run() {
                SimulationControlView.this.masterStopAction();
            }
        };
        this.runAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_run.image")));
        this.pauseAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_pause.image")));
        this.resetAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_reset.image")));
        this.stepAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_step.image")));
        this.stopAction.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)Activator.getDefault().getImageRegistry().get("disabled_stop.image")));
        this.runAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.resetAction.setEnabled(false);
        this.stepAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.actionBars = this.getViewSite().getActionBars();
        this.dropDownMenu = this.actionBars.getMenuManager();
        this.toolBar = this.actionBars.getToolBarManager();
        this.dropDownMenu.add((IAction)this.runAction);
        this.dropDownMenu.add((IAction)this.pauseAction);
        this.dropDownMenu.add((IAction)this.resetAction);
        this.dropDownMenu.add((IAction)this.stepAction);
        this.dropDownMenu.add((IAction)this.stopAction);
        this.toolBar.add((IAction)this.runAction);
        this.toolBar.add((IAction)this.pauseAction);
        this.toolBar.add((IAction)this.resetAction);
        this.toolBar.add((IAction)this.stepAction);
        this.toolBar.add((IAction)this.stopAction);
        List list = this.simulationManager.getActiveSimulations();
        for (ISimulation iSimulation : list) {
            this.addSimulation(iSimulation);
        }
    }

    protected void enableMasterControl(boolean bl) {
        this.runAction.setEnabled(bl);
        this.pauseAction.setEnabled(bl);
        this.resetAction.setEnabled(bl);
        this.stepAction.setEnabled(bl);
        this.stopAction.setEnabled(bl);
    }

    protected void masterRunAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.run();
        }
    }

    protected void masterPauseAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.pause();
        }
    }

    protected void masterResetAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.reset();
        }
    }

    protected void masterStepAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.step();
        }
    }

    protected void masterStopAction() {
        for (SimulationControl simulationControl : this.controlList) {
            simulationControl.stop();
        }
    }

    public List<SimulationControl> getSimulationControlList() {
        return this.controlList;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.simulationManager != null) {
            this.simulationManager.removeListener((ISimulationManagerListener)this);
        }
        if (!this.controlList.isEmpty()) {
            ListIterator<SimulationControl> listIterator = this.controlList.listIterator();
            while (listIterator.hasNext()) {
                SimulationControl simulationControl = (SimulationControl)((Object)listIterator.next());
                simulationControl.dispose();
                listIterator.remove();
            }
        }
    }

    public void simulationsChanged(SimulationManagerEvent simulationManagerEvent) {
        ISimulation[] iSimulationArray = null;
        iSimulationArray = simulationManagerEvent.getSimulationsAdded();
        int n = 0;
        while (n < iSimulationArray.length) {
            this.addSimulation(iSimulationArray[n]);
            ++n;
        }
        iSimulationArray = simulationManagerEvent.getSimulationsRemoved();
        n = 0;
        while (n < iSimulationArray.length) {
            this.removeSimulation(iSimulationArray[n]);
            ++n;
        }
        this.scrollComposite.setContent((Control)this.controlComposite);
        this.controlComposite.layout(true);
        this.scrollComposite.layout(true);
        this.scrollComposite.redraw();
    }

    private void addSimulation(ISimulation iSimulation) {
        this.controlComposite.setRedraw(true);
        this.scrollComposite.setRedraw(true);
        SimulationControl simulationControl = new SimulationControl(this.controlComposite, iSimulation);
        this.controlComposite.addControlListener((ControlListener)simulationControl);
        this.controlList.add(simulationControl);
        if (this.controlList.size() > 0) {
            this.enableMasterControl(true);
        }
        this.controlComposite.layout(true);
        this.scrollComposite.layout(true);
        this.scrollComposite.redraw();
    }

    private void removeSimulation(ISimulation iSimulation) {
        this.controlComposite.setRedraw(true);
        this.scrollComposite.setRedraw(true);
        Control[] controlArray = this.controlComposite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            SimulationControl simulationControl = (SimulationControl)controlArray[n];
            if (iSimulation.equals(simulationControl.getSimulation())) {
                this.controlComposite.removeControlListener((ControlListener)simulationControl);
                this.controlList.remove((Object)simulationControl);
                Composite composite = new Composite((Composite)this.scrollComposite, 0);
                simulationControl.setParent(composite);
                composite.dispose();
                simulationControl.dispose();
                break;
            }
            ++n;
        }
        if (this.controlList.size() == 0) {
            this.enableMasterControl(false);
        }
        this.controlComposite.layout(true);
        this.scrollComposite.layout(true);
        this.scrollComposite.redraw();
    }
}

