/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class IdentifiableDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public boolean isSupportedType(TransferData transferData) {
        boolean bl = LocalSelectionTransfer.getTransfer().isSupportedType(transferData);
        return bl;
    }

    public IStatus handleDrop(CommonDropAdapter commonDropAdapter, DropTargetEvent dropTargetEvent, Object object) {
        IStatus iStatus = Status.CANCEL_STATUS;
        if (dropTargetEvent.data instanceof IStructuredSelection) {
            for (Object e : ((IStructuredSelection)dropTargetEvent.data).toList()) {
                if (!(e instanceof String)) continue;
                String string = (String)e;
                try {
                    URI uRI = URI.createURI((String)string);
                    Identifiable identifiable = Utility.getIdentifiable((URI)uRI);
                    DublinCore dublinCore = identifiable.getDublinCore();
                    URI uRI2 = this.createSerializationURI(uRI, (IdentifiableTreeNode)object);
                    identifiable.setURI(uRI2);
                    dublinCore.setTitle("Copy of \"" + dublinCore.getTitle() + "\"");
                    dublinCore.setDescription("Copy of \"" + dublinCore.getDescription() + "\"");
                    dublinCore.populate();
                    Utility.serializeIdentifiable((Identifiable)identifiable, (URI)uRI2);
                    iStatus = Status.OK_STATUS;
                }
                catch (Exception exception) {
                    Activator.logError((String)("Problem deserializing Identifiable from \"" + string + "\""), (Throwable)exception);
                }
            }
        }
        return iStatus;
    }

    private URI createSerializationURI(URI uRI, IdentifiableTreeNode identifiableTreeNode) {
        StringBuilder stringBuilder = new StringBuilder(identifiableTreeNode.getProject().getName());
        stringBuilder.append("/");
        stringBuilder.append(identifiableTreeNode.getFolderName());
        stringBuilder.append("/");
        stringBuilder.append(uRI.segment(uRI.segmentCount() - 1));
        return URI.createPlatformResourceURI((String)stringBuilder.toString(), (boolean)false);
    }

    public IStatus validateDrop(Object object, int n, TransferData transferData) {
        return Status.OK_STATUS;
    }
}

