/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableInstanceTreeNode;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.swt.widgets.Display;

public class IdentifiableInstanceTreeNodeContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    Viewer viewer;

    public IdentifiableInstanceTreeNodeContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object object) {
        Object[] objectArray = null;
        if (object instanceof IdentifiableTreeNode) {
            ArrayList<IdentifiableInstanceTreeNode> arrayList = new ArrayList<IdentifiableInstanceTreeNode>();
            IdentifiableTreeNode identifiableTreeNode = (IdentifiableTreeNode)object;
            IFolder iFolder = identifiableTreeNode.getProject().getFolder(identifiableTreeNode.getFolderName());
            if (iFolder.exists()) {
                try {
                    IResource[] iResourceArray = iFolder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource iResource = iResourceArray[n2];
                        String string = iResource.getName();
                        String string2 = iResource.getFileExtension();
                        String string3 = string.substring(0, string.lastIndexOf(string2) - 1);
                        arrayList.add(new IdentifiableInstanceTreeNode(identifiableTreeNode, string3, string2));
                        ++n2;
                    }
                }
                catch (CoreException coreException) {
                    Activator.logError("", coreException);
                }
            }
            objectArray = arrayList.toArray();
        }
        return objectArray;
    }

    public Object getParent(Object object) {
        IdentifiableTreeNode identifiableTreeNode = null;
        if (object instanceof IdentifiableInstanceTreeNode) {
            identifiableTreeNode = ((IdentifiableInstanceTreeNode)object).getParent();
        }
        return identifiableTreeNode;
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public Object[] getElements(Object object) {
        return null;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.viewer = viewer;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        try {
            iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            Activator.logError("", coreException);
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    IdentifiableInstanceTreeNodeContentProvider.this.viewer.refresh();
                }
            });
        }
        return true;
    }
}

