/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.data.geography.centers.GeographicCenters;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderChangedListener;
import org.eclipse.stem.ui.views.geographic.GeographicRenderer;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.stem.ui.views.geographic.map.StemPolygon;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.stem.ui.widgets.GeoViewOptionsBar;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public abstract class GeographicControl
extends Composite
implements ISimulationListener,
ISelectionProvider,
IColorProviderChangedListener,
Preferences.IPropertyChangeListener,
ISelectionChangedListener,
GeoViewOptionsBar.PropertySelectionListener {
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;
    private ISimulation simulation = null;
    ISelection selection = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected GeographicRenderer geographicRenderer;
    protected String selectedEdge = "";
    boolean refreshPending = false;
    Job refreshJob;
    protected ColorProviderAdapter colorProviderAdapter = null;
    private Label simulationNameLabel;
    private GeoViewOptionsBar optionsBar;
    protected final Map<Decorator, DecoratorDisplayData> decoratorToDecoratorDisplayDataMap = new HashMap<Decorator, DecoratorDisplayData>();
    private final Map<LatLong, StemPolygonsList> polygonListMap = new HashMap<LatLong, StemPolygonsList>();

    public GeographicControl(Composite composite, int n) {
        super(composite, n);
        Activator.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.setPreferences();
        this.createContextMenu(this);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        this.setLayout((Layout)formLayout);
        Composite composite2 = this.createTopComposite(this);
        this.geographicRenderer = this.createGeographicRenderer();
        this.geographicRenderer.setColorProviderAdapter(this.colorProviderAdapter);
        this.geographicRenderer.addSelectionChangedListener(this);
        Composite composite3 = this.createBottomComposite(this);
        FormData formData = new FormData();
        composite2.setLayoutData((Object)formData);
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        FormData formData2 = new FormData();
        this.geographicRenderer.setLayoutData(formData2);
        formData2.top = new FormAttachment((Control)composite2, 0);
        formData2.bottom = new FormAttachment((Control)composite3, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        FormData formData3 = new FormData();
        composite3.setLayoutData((Object)formData3);
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment(0, 0);
        formData3.right = new FormAttachment(100, 0);
        this.pack();
    }

    protected abstract GeographicRenderer createGeographicRenderer();

    protected void setPreferences() {
    }

    public final ISimulation getSimulation() {
        return this.simulation;
    }

    public final void setSimulation(ISimulation iSimulation) {
        if (this.simulation == iSimulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.simulation = iSimulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListener((ISimulationListener)this);
            this.initializeFromSimulation(this.simulation);
        }
        this.refresh();
    }

    protected void initializeFromSimulation(ISimulation iSimulation) {
        this.simulationNameLabel.setText(iSimulation.getName());
        this.optionsBar.setSimulation(iSimulation);
    }

    void refresh() {
        if (!this.refreshPending) {
            if (this.refreshJob == null) {
                this.refreshJob = new Job(Messages.getString("IMView.MRefresh")){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        final StemPolygonsList stemPolygonsList = GeographicControl.this.createPolygonsToDraw(iProgressMonitor);
                        if (stemPolygonsList == null) {
                            return Status.OK_STATUS;
                        }
                        Display display = Display.getDefault();
                        if (!display.isDisposed()) {
                            try {
                                display.asyncExec(new Runnable(){

                                    public void run() {
                                        if (!(this).GeographicControl.this.geographicRenderer.isDisposed()) {
                                            (this).GeographicControl.this.geographicRenderer.render(stemPolygonsList);
                                            (this).GeographicControl.this.refreshJob = null;
                                            if ((this).GeographicControl.this.refreshPending) {
                                                (this).GeographicControl.this.refreshPending = false;
                                                Display display = Display.getDefault();
                                                if (!display.isDisposed()) {
                                                    display.asyncExec(new Runnable(){

                                                        public void run() {
                                                            GeographicControl.this.refresh();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                        iProgressMonitor.done();
                        return Status.OK_STATUS;
                    }
                };
                this.refreshPending = false;
                this.refreshJob.schedule();
            } else {
                this.refreshPending = true;
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.optionsBar.removeColorProviderChangedListener(this);
        this.optionsBar.removePropertySelectionListener(this);
        this.geographicRenderer.removeSelectionChangedListener(this);
        assert (this.listeners.size() == 0);
        Activator.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    private void createContextMenu(Composite composite) {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new ResetRenderer());
        menuManager.add((IContributionItem)new Separator("additions"));
        Menu menu = menuManager.createContextMenu((Control)composite);
        composite.setMenu(menu);
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        this.setPreferences();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelection(selectionChangedEvent.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
        this.fireSelection(iSelection);
    }

    public void fireSelection(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    protected Composite createBottomComposite(Composite composite) {
        this.optionsBar = new GeoViewOptionsBar(composite, 0);
        this.optionsBar.addColorProviderChangedListener(this);
        this.optionsBar.addPropertySelectionListener(this);
        return this.optionsBar;
    }

    public void propertySelected(GeoViewOptionsBar.PropertySelectionEvent propertySelectionEvent) {
        if (propertySelectionEvent == null) {
            this.selectedEdge = "";
        } else if (propertySelectionEvent.getSource() instanceof String) {
            this.selectedEdge = (String)propertySelectionEvent.getSource();
        }
        this.refresh();
    }

    protected Composite createTopComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout(512);
        composite2.setLayout((Layout)fillLayout);
        this.simulationNameLabel = new Label(composite2, 0x1000000);
        this.simulationNameLabel.setText("");
        return composite2;
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        switch (simulationEvent.getSimulationState()) {
            case COMPLETED_CYCLE: {
                if (!this.optionsBar.isInitialized()) {
                    this.optionsBar.setSimulation(this.getSimulation());
                }
                this.refresh();
                break;
            }
            case RESET: {
                this.refresh();
                break;
            }
        }
    }

    protected DecoratorDisplayData getDecoratorDisplayData(Decorator decorator, IProgressMonitor iProgressMonitor) {
        DecoratorDisplayData decoratorDisplayData = this.decoratorToDecoratorDisplayDataMap.get(decorator);
        if (decoratorDisplayData == null) {
            DynamicNodeLabel dynamicNodeLabel;
            decoratorDisplayData = new DecoratorDisplayData();
            this.decoratorToDecoratorDisplayDataMap.put(decorator, decoratorDisplayData);
            if (decorator.getLabelsToUpdate() == null || decorator.getLabelsToUpdate().isEmpty()) {
                return decoratorDisplayData;
            }
            DynamicNodeLabel dynamicNodeLabel2 = (DynamicNodeLabel)decorator.getLabelsToUpdate().get(0);
            if (dynamicNodeLabel2 != null) {
                Object object = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicNodeLabel2, RelativeValueProvider.class);
                if (object == null) {
                    return null;
                }
                decoratorDisplayData.setRelativeValueProviderAdapter((RelativeValueProviderAdapter)object);
                Iterator iterator = dynamicNodeLabel2.getNode();
                dynamicNodeLabel = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)iterator, LatLongProvider.class);
                decoratorDisplayData.setLatLongProviderAdapter((LatLongProviderAdapter)dynamicNodeLabel);
            }
            for (Object object : decorator.getLabelsToUpdate()) {
                dynamicNodeLabel = (DynamicNodeLabel)object;
                decoratorDisplayData.addLabel(dynamicNodeLabel);
            }
        }
        if (!decoratorDisplayData.hasAllLatLong()) {
            iProgressMonitor.subTask(decorator.getDublinCore().getTitle());
            decoratorDisplayData.updateLatLong(iProgressMonitor);
        }
        return decoratorDisplayData;
    }

    protected StemPolygonsList createPolygonsToDraw(IProgressMonitor iProgressMonitor) {
        return this.createPolygonsToDraw(this.optionsBar.getSelectedDecorator(), iProgressMonitor);
    }

    StemPolygonsList createPolygonsToDraw(Decorator decorator, IProgressMonitor iProgressMonitor) {
        StemPolygonsList stemPolygonsList = new StemPolygonsList();
        if (decorator != null) {
            AbstractList abstractList;
            Object object;
            Identifiable identifiable;
            DecoratorDisplayData decoratorDisplayData = this.getDecoratorDisplayData(decorator, iProgressMonitor);
            if (decoratorDisplayData == null) {
                return null;
            }
            RelativeValueProviderAdapter relativeValueProviderAdapter = decoratorDisplayData.getRelativeValueProviderAdapter();
            if (relativeValueProviderAdapter == null) {
                return null;
            }
            iProgressMonitor.beginTask(decorator.getDublinCore().getTitle(), decoratorDisplayData.getLabelData().size());
            for (DecoratorDisplayData.LabelData object2 : decoratorDisplayData.getLabelData()) {
                identifiable = object2.getLabel().getIdentifiable();
                iProgressMonitor.subTask(identifiable.getDublinCore().getTitle());
                object = object2.getLatLongData();
                if (object.size() > 0) {
                    abstractList = this.getStemPolygonsList((LatLong)object, identifiable, relativeValueProviderAdapter, object2);
                    stemPolygonsList.addAll(abstractList);
                }
                iProgressMonitor.worked(1);
            }
            if (this.selectedEdge != null && !this.selectedEdge.equals("")) {
                Object object2;
                LinkedList<Object> linkedList = new LinkedList<Object>();
                Graph graph = decorator.getGraph();
                identifiable = graph.getEdges();
                object = identifiable.keySet().iterator();
                abstractList = new ArrayList();
                while (object.hasNext()) {
                    object2 = (URI)object.next();
                    if (linkedList.contains(object2)) {
                        linkedList.add(object2);
                    }
                    if (!object2.toString().startsWith(this.selectedEdge)) continue;
                    abstractList.add((Edge)identifiable.get(object2));
                }
                if (!abstractList.isEmpty()) {
                    object2 = abstractList.iterator();
                    ArrayList<URI> arrayList = new ArrayList<URI>();
                    while (object2.hasNext()) {
                        Object object3;
                        double[] dArray;
                        String string;
                        Edge edge = (Edge)object2.next();
                        Node node = edge.getA();
                        Node node2 = edge.getB();
                        if (node == null || node2 == null) continue;
                        String string2 = node.getURI().lastSegment();
                        double[] dArray2 = GeographicCenters.getCenter((String)string2);
                        if (dArray2 == null) {
                            string = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node, LatLongProvider.class);
                            string.setTarget((Notifier)node);
                            dArray2 = string.getCenter();
                        }
                        if ((dArray = GeographicCenters.getCenter((String)(string = node2.getURI().lastSegment()))) == null) {
                            object3 = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node2, LatLongProvider.class);
                            object3.setTarget((Notifier)node2);
                            dArray = object3.getCenter();
                        }
                        if (dArray2 == null || dArray == null) continue;
                        object3 = new double[2][2];
                        object3[0][0] = (LatLongProviderAdapter)dArray2[0];
                        object3[0][1] = (LatLongProviderAdapter)dArray2[1];
                        object3[1][0] = (LatLongProviderAdapter)dArray[0];
                        object3[1][1] = (LatLongProviderAdapter)dArray[1];
                        if (arrayList.contains(edge.getURI())) continue;
                        LatLong.Segment segment = new LatLong.Segment((double[][])object3);
                        StemPolygon stemPolygon = new StemPolygon(segment, (Identifiable)edge);
                        stemPolygonsList.add(stemPolygon);
                        arrayList.add(edge.getURI());
                    }
                }
            }
        }
        return stemPolygonsList;
    }

    private StemPolygonsList getStemPolygonsList(LatLong latLong, Identifiable identifiable, RelativeValueProviderAdapter relativeValueProviderAdapter, DecoratorDisplayData.LabelData labelData) {
        StemPolygonsList stemPolygonsList = this.polygonListMap.get(latLong);
        relativeValueProviderAdapter.setTarget((Notifier)labelData.getLabel());
        if (stemPolygonsList == null) {
            stemPolygonsList = new StemPolygonsList(latLong, identifiable);
            this.polygonListMap.put(latLong, stemPolygonsList);
        }
        return stemPolygonsList;
    }

    public GeographicRenderer getGeographicRenderer() {
        return this.geographicRenderer;
    }

    public void colorProviderChanged(Class clazz) {
        Decorator decorator = this.optionsBar.getSelectedDecorator();
        if (decorator == null) {
            return;
        }
        AdapterFactory adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(clazz);
        Adapter adapter = adapterFactory.adapt((Notifier)decorator.getGraph(), (Object)clazz);
        if (adapter instanceof ColorProviderAdapter) {
            this.colorProviderAdapter = (ColorProviderAdapter)adapter;
            this.colorProviderAdapter.setSelectedDecorator(this.optionsBar.getSelectedDecorator());
            this.geographicRenderer.setColorProviderAdapter(this.colorProviderAdapter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DecoratorDisplayData {
        private RelativeValueProviderAdapter rvp;
        private LatLongProviderAdapter latLongProvider;
        private final List<LabelData> labelDatas = new ArrayList<LabelData>();
        private final List<LabelData> labelsWithUnresolvedLatLong = new ArrayList<LabelData>();

        public boolean hasAllLatLong() {
            return this.labelsWithUnresolvedLatLong.size() == 0;
        }

        public List<LabelData> getLabelData() {
            return this.labelDatas;
        }

        public RelativeValueProviderAdapter getRelativeValueProviderAdapter() {
            return this.rvp;
        }

        void updateLatLong(IProgressMonitor iProgressMonitor) {
            Iterator<LabelData> iterator = this.labelsWithUnresolvedLatLong.iterator();
            while (iterator.hasNext()) {
                LabelData labelData = iterator.next();
                this.latLongProvider.setTarget((Notifier)labelData.getLabel().getNode());
                labelData.setLatLongData(this.latLongProvider.getLatLongNoWait());
                if (labelData.getLatLongData().size() == 0) continue;
                iterator.remove();
            }
        }

        public void addLabel(DynamicNodeLabel dynamicNodeLabel) {
            LabelData labelData = new LabelData(dynamicNodeLabel);
            this.labelDatas.add(labelData);
            this.labelsWithUnresolvedLatLong.add(labelData);
        }

        public void setLatLongProviderAdapter(LatLongProviderAdapter latLongProviderAdapter) {
            this.latLongProvider = latLongProviderAdapter;
        }

        public void setRelativeValueProviderAdapter(RelativeValueProviderAdapter relativeValueProviderAdapter) {
            this.rvp = relativeValueProviderAdapter;
        }

        public static class LabelData {
            private final DynamicNodeLabel label;
            private LatLong latLongData;

            public LabelData(DynamicNodeLabel dynamicNodeLabel) {
                this.label = dynamicNodeLabel;
            }

            public DynamicNodeLabel getLabel() {
                return this.label;
            }

            public LatLong getLatLongData() {
                return this.latLongData;
            }

            public void setLatLongData(LatLong latLong) {
                this.latLongData = latLong;
            }
        }
    }

    protected class ResetRenderer
    extends Action {
        protected ResetRenderer() {
        }

        public String getText() {
            return Messages.getString("MapMenu.Reset");
        }

        public void run() {
            GeographicControl.this.geographicRenderer.reset();
            GeographicControl.this.geographicRenderer.redraw();
        }
    }
}

