/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.text.NumberFormatter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public abstract class GeographicRenderer
extends Composite
implements ISelectionProvider {
    protected static final float INITIAL_GAIN_FACTOR = 1.0f;
    protected static final boolean INITIAL_DRAW_POLYGON_BORDERS = true;
    protected static final boolean INITIAL_USE_LOG_SCALING = true;
    protected static final int MARGIN_HEIGHT = 5;
    protected static final int MARGIN_WIDTH = 5;
    private static NumberFormatter formatter = new NumberFormatter();
    protected boolean drawPolygonBorders = true;
    protected Stroke polygonStroke = new BasicStroke(1.0f);
    protected boolean useLogScaling = true;
    protected float gainFactor = 1.0f;
    private GainFactorAction defaultGainFactorAction;
    GainFactorAction lastGainFactorAction;
    private LogarithmicAction logarithmicAction;
    private DrawPolygonBordersAction drawPolygonBordersAction;
    protected ColorProviderAdapter colorProviderAdapter = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private ISelection selection;

    public GeographicRenderer(Composite composite, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!GeographicRenderer.this.isDisposed()) {
                    GeographicRenderer.this.dispose();
                }
            }
        });
    }

    public abstract void render(StemPolygonsList var1);

    protected Color getColorForRelativeValue(double d) {
        return null;
    }

    public void dispose() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
        this.fireSelection(iSelection);
    }

    public void fireSelection(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public void reset() {
        this.lastGainFactorAction.setChecked(false);
        this.defaultGainFactorAction.run();
        this.defaultGainFactorAction.setChecked(true);
        this.useLogScaling = true;
        this.logarithmicAction.setChecked(this.useLogScaling);
        this.drawPolygonBorders = true;
        this.drawPolygonBordersAction.setChecked(this.drawPolygonBorders);
    }

    protected void setGainFactor(float f) {
        this.gainFactor = f;
    }

    protected void toggleDrawPolygonBordersChoice() {
        this.drawPolygonBorders = !this.drawPolygonBorders;
        this.redraw();
    }

    protected void toggleUseLogScaling() {
        this.useLogScaling = !this.useLogScaling;
        this.redraw();
    }

    public MenuManager createContextMenuManager() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)this.createGainFactorMenu());
        this.logarithmicAction = new LogarithmicAction();
        menuManager.add((IAction)this.logarithmicAction);
        menuManager.add((IContributionItem)new Separator());
        this.drawPolygonBordersAction = new DrawPolygonBordersAction();
        menuManager.add((IAction)this.drawPolygonBordersAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)this.createReportsSelectionMenu());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new ResetMapCanvasAction());
        menuManager.add((IContributionItem)new Separator("additions"));
        return menuManager;
    }

    private MenuManager createGainFactorMenu() {
        MenuManager menuManager = new MenuManager(Messages.getString("MapMenu.GainFactor"));
        menuManager.add((IAction)new GainFactorAction(0.001));
        menuManager.add((IAction)new GainFactorAction(0.01));
        menuManager.add((IAction)new GainFactorAction(0.1));
        this.lastGainFactorAction = this.defaultGainFactorAction = new GainFactorAction(1.0);
        menuManager.add((IAction)this.defaultGainFactorAction);
        menuManager.add((IAction)new GainFactorAction(10.0));
        menuManager.add((IAction)new GainFactorAction(100.0));
        menuManager.add((IAction)new GainFactorAction(1000.0));
        menuManager.add((IAction)new GainFactorAction(10000.0));
        menuManager.add((IAction)new GainFactorAction(100000.0));
        menuManager.add((IAction)new GainFactorAction(1000000.0));
        menuManager.add((IAction)new GainFactorAction(1.0E7));
        return menuManager;
    }

    private MenuManager createReportsSelectionMenu() {
        MenuManager menuManager = new MenuManager(Messages.getString("MapMenu.Reports_Select"), "reports");
        menuManager.add((IContributionItem)new Separator("additions"));
        return menuManager;
    }

    String getText(double d) {
        String string = "";
        try {
            string = formatter.valueToString(new Double(d));
        }
        catch (ParseException parseException) {
            Activator.logError("Problem parsing gain factor value \"" + d + "\"", parseException);
        }
        return string;
    }

    public void setColorProviderAdapter(ColorProviderAdapter colorProviderAdapter) {
        this.colorProviderAdapter = colorProviderAdapter;
    }

    protected class DrawPolygonBordersAction
    extends Action {
        public DrawPolygonBordersAction() {
            super(Messages.getString("MapMenu.Polygon_Borders"), 2);
            if (GeographicRenderer.this.drawPolygonBorders) {
                this.setChecked(true);
            }
        }

        public String getText() {
            return Messages.getString("MapMenu.Polygon_Borders");
        }

        public void run() {
            GeographicRenderer.this.toggleDrawPolygonBordersChoice();
        }
    }

    protected class GainFactorAction
    extends Action {
        private final double factor;

        GainFactorAction(double d) {
            super(GeographicRenderer.this.getText(d), 8);
            this.factor = d;
            this.setChecked(d == 1.0);
        }

        public String getText() {
            return GeographicRenderer.this.getText(this.factor);
        }

        public void run() {
            GeographicRenderer.this.setGainFactor((float)this.factor);
            GeographicRenderer.this.lastGainFactorAction = this;
        }
    }

    protected class LogarithmicAction
    extends Action {
        public LogarithmicAction() {
            super(Messages.getString("MapMenu.Logrithmic_Scaling"), 2);
            this.setChecked(GeographicRenderer.this.useLogScaling);
        }

        public String getText() {
            return Messages.getString("MapMenu.Logrithmic_Scaling");
        }

        public void run() {
            GeographicRenderer.this.toggleUseLogScaling();
        }
    }

    protected class ResetMapCanvasAction
    extends Action {
        protected ResetMapCanvasAction() {
        }

        public String getText() {
            return Messages.getString("MapMenu.Reset");
        }

        public void run() {
            GeographicRenderer.this.reset();
        }
    }
}

