/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.views.IContextMenuUpdatesListener;
import org.eclipse.stem.ui.views.geographic.GeographicControl;
import org.eclipse.stem.ui.views.geographic.GeographicControlFactory;
import org.eclipse.stem.ui.views.geographic.GeographicRenderer;
import org.eclipse.stem.ui.views.geographic.map.MapRenderer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListener {
    private final Set<ISimulation> simulationsToDisplay = new LinkedHashSet<ISimulation>();
    private SimulationManager simulationManager;
    private ISelection selection = null;
    private Composite composite;
    private GeographicControlFactory gcf;
    private List<IContextMenuUpdatesListener> contextMenuUpdateListeners = new ArrayList<IContextMenuUpdatesListener>();

    public GeographicViewer(Composite composite, GeographicControlFactory geographicControlFactory) {
        this.composite = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout(256);
        this.composite.setLayout((Layout)fillLayout);
        this.gcf = geographicControlFactory;
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.composite;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            this.simulationsToDisplay.clear();
            this.simulationsToDisplay.addAll(this.simulationManager.getActiveSimulations());
        }
        this.populateView();
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object object) {
        SimulationManager simulationManager = this.simulationManager;
        this.simulationManager = (SimulationManager)object;
        this.inputChanged(object, simulationManager);
    }

    protected void inputChanged(Object object, Object object2) {
        if (object2 != null) {
            ((SimulationManager)object2).removeListener((ISimulationManagerListener)this);
        }
        if (object != null) {
            ((SimulationManager)object).addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        this.selection = iSelection;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelectionProvider() instanceof GeographicControl) {
            this.selection = selectionChangedEvent.getSelection();
            this.fireSelectionChanged(selectionChangedEvent);
        }
    }

    public void simulationsChanged(SimulationManagerEvent simulationManagerEvent) {
        this.addToDisplayedSimulationSet(Arrays.asList(simulationManagerEvent.getSimulationsAdded()));
        this.removeFromDisplayedSimulationSet(Arrays.asList(simulationManagerEvent.getSimulationsRemoved()));
        this.populateView();
    }

    private void addToDisplayedSimulationSet(List<ISimulation> list) {
        if (!list.isEmpty()) {
            this.simulationsToDisplay.addAll(list);
        }
    }

    private void removeFromDisplayedSimulationSet(List<ISimulation> list) {
        if (!list.isEmpty()) {
            this.simulationsToDisplay.removeAll(list);
        }
    }

    private void populateView() {
        ISimulation iSimulation;
        GeographicControl geographicControl;
        ISimulation iSimulation22;
        if (this.composite.isDisposed()) {
            return;
        }
        this.selection = null;
        HashSet<ISimulation> hashSet = new HashSet<ISimulation>();
        for (ISimulation iSimulation22 : this.simulationsToDisplay) {
            if (this.isDisplayed(iSimulation22)) continue;
            hashSet.add(iSimulation22);
        }
        ISimulation iSimulation3 = iSimulation22 = this.composite.getChildren();
        int n = ((ISimulation)iSimulation3).length;
        int n2 = 0;
        while (n2 < n) {
            ISimulation iSimulation4 = iSimulation3[n2];
            geographicControl = (GeographicControl)iSimulation4;
            if (!this.simulationsToDisplay.contains(geographicControl.getSimulation()) && !hashSet.isEmpty()) {
                iSimulation = (ISimulation)hashSet.toArray()[0];
                geographicControl.setSimulation(iSimulation);
                this.notifyContextMenuUpdateListeners(geographicControl);
                hashSet.remove(iSimulation);
            }
            ++n2;
        }
        iSimulation3 = iSimulation22;
        n = ((ISimulation)iSimulation3).length;
        n2 = 0;
        while (n2 < n) {
            ISimulation iSimulation5 = iSimulation3[n2];
            geographicControl = (GeographicControl)iSimulation5;
            iSimulation = geographicControl.getSimulation();
            if (iSimulation != null && !this.simulationsToDisplay.contains(iSimulation)) {
                geographicControl.removeSelectionChangedListener(this);
                geographicControl.dispose();
            }
            ++n2;
        }
        for (ISimulation iSimulation6 : hashSet) {
            GeographicControl geographicControl2 = this.gcf.create(this.composite);
            this.notifyContextMenuUpdateListeners(geographicControl2);
            geographicControl2.addSelectionChangedListener(this);
            geographicControl2.setSimulation(iSimulation6);
        }
        if (this.composite.getChildren().length == 0) {
            GeographicControl geographicControl3 = this.gcf.create(this.composite);
            geographicControl3.addSelectionChangedListener(this);
        }
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    private boolean isDisplayed(ISimulation iSimulation) {
        Control[] controlArray;
        boolean bl = false;
        Control[] controlArray2 = controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            GeographicControl geographicControl = (GeographicControl)control;
            ISimulation iSimulation2 = geographicControl.getSimulation();
            if (iSimulation2 != null && iSimulation2.equals(iSimulation)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void addContextMenuUpdateListener(IContextMenuUpdatesListener iContextMenuUpdatesListener) {
        if (!this.contextMenuUpdateListeners.contains(iContextMenuUpdatesListener)) {
            this.contextMenuUpdateListeners.add(iContextMenuUpdatesListener);
        }
    }

    public void removeContextMenuUpdateListener(IContextMenuUpdatesListener iContextMenuUpdatesListener) {
        this.contextMenuUpdateListeners.remove(iContextMenuUpdatesListener);
    }

    private void notifyContextMenuUpdateListeners(GeographicControl geographicControl) {
        GeographicRenderer geographicRenderer = geographicControl.getGeographicRenderer();
        if (geographicRenderer instanceof MapRenderer) {
            MapRenderer mapRenderer = (MapRenderer)geographicRenderer;
            this.notifyContextMenuUpdateListeners(mapRenderer.getMenuManager(), mapRenderer);
        }
    }

    private void notifyContextMenuUpdateListeners(MenuManager menuManager, ISelectionProvider iSelectionProvider) {
        for (IContextMenuUpdatesListener iContextMenuUpdatesListener : this.contextMenuUpdateListeners) {
            iContextMenuUpdatesListener.onContextMenuUpdate(menuManager, iSelectionProvider);
        }
    }
}

