/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Graphics2DRenderer {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private BufferedImage awtImage;
    private Image swtImage;
    private ImageData swtImageData;
    private int[] awtPixels;
    private static final int TRANSPARENT_COLOR = 1193046;

    public void prepareRendering(GC gC) {
        Rectangle rectangle = gC.getClipping();
        this.prepareRendering(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void prepareRendering(int n, int n2, int n3, int n4) {
        this.checkOffScreenImages(n3, n4);
        Graphics graphics = this.awtImage.getGraphics();
        graphics.setColor(new Color(1193046));
        graphics.fillRect(n, n2, n3, n4);
    }

    public Graphics2D getGraphics2D() {
        if (this.awtImage == null) {
            return null;
        }
        return (Graphics2D)this.awtImage.getGraphics();
    }

    public void render(GC gC) {
        if (this.awtImage == null) {
            return;
        }
        Rectangle rectangle = gC.getClipping();
        this.transferPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        gC.drawImage(this.swtImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void transferPixels(int n, int n2, int n3, int n4) {
        int n5 = this.swtImageData.depth / 8;
        byte[] byArray = this.swtImageData.data;
        this.awtImage.getRGB(n, n2, n3, n4, this.awtPixels, 0, n3);
        int n6 = 0;
        while (n6 < n4) {
            int n7 = (n2 + n6) * this.swtImageData.bytesPerLine + n * n5;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = this.awtPixels[n8 + n6 * n3];
                int n10 = this.swtImageData.depth - 8;
                while (n10 >= 0) {
                    byArray[n7++] = (byte)(n9 >> n10 & 0xFF);
                    n10 -= 8;
                }
                ++n8;
            }
            ++n6;
        }
        if (this.swtImage != null) {
            this.swtImage.dispose();
        }
        this.swtImage = new Image((Device)Display.getDefault(), this.swtImageData);
    }

    public void dispose() {
        if (this.awtImage != null) {
            this.awtImage.flush();
        }
        if (this.swtImage != null) {
            this.swtImage.dispose();
        }
        this.awtImage = null;
        this.swtImageData = null;
        this.awtPixels = null;
    }

    private void checkOffScreenImages(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.swtImage != null) {
            n3 = this.swtImage.getImageData().width;
            n4 = this.swtImage.getImageData().height;
        }
        if (n > n3 || n2 > n4) {
            this.dispose();
            n = Math.max(n, n3);
            n2 = Math.max(n2, n4);
            this.awtImage = new BufferedImage(n, n2, 2);
            this.swtImageData = new ImageData(n, n2, 24, PALETTE_DATA);
            this.swtImageData.transparentPixel = 1193046;
            this.awtPixels = new int[n * n2];
        }
    }
}

