/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.StandardColorProvider;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;
import org.eclipse.stem.ui.views.geographic.map.SelectedReportsManager;
import org.eclipse.stem.ui.views.geographic.map.StemPolygon;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonTransform;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MapCanvas
extends Canvas
implements ISelectionProvider,
PaintListener,
MouseWheelListener,
MouseMoveListener,
DisposeListener {
    private static final double INITIAL_ZOOM_FACTOR = 1.0;
    private static final double INITIAL_X_TRANSLATION = 0.0;
    private static final double INITIAL_Y_TRANSLATION = 0.0;
    protected static final double ZOOMING_FACTOR = 1.1;
    protected static final double UNZOOMING_FACTOR = 0.9090909090909091;
    private StemPolygonsList polygonsToRender;
    double zoomFactor = 1.0;
    private float gainFactor = 1.0f;
    private double xTranslation = 0.0;
    private double yTranslation = 0.0;
    boolean drawPolygonBorders = true;
    StemPolygonTransform pointsTransformer = new StemPolygonTransform();
    boolean toUpdateTranform = true;
    private final StandardColorProvider stdColorProvider = new StandardColorProvider((Device)this.getDisplay());
    private ColorProviderAdapter colorProvider = null;
    private boolean useLogScaling = true;
    boolean leftMouseButtonPressed = false;
    int lastOffsetX;
    int lastOffsetY;
    private ISelection selection;
    protected final List<ISelectionChangedListener> selectionChangedListeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    private Rectangle polygonsBoundsRect = null;
    private static final int MARGIN = 10;
    private final MouseTrackHandler mouseTrackHandler = new MouseTrackHandler();
    private final MouseButtonHandler mouseButtonHandler = new MouseButtonHandler();
    private final MouseHoverHandler mouseHoverHandler = new MouseHoverHandler();
    private final KeyHandler keyHandler = new KeyHandler();

    public MapCanvas(Composite composite, int n) {
        super(composite, 0x20040000);
        this.addPaintListener(this);
        this.addMouseWheelListener(this);
        this.addMouseTrackListener((MouseTrackListener)this.mouseTrackHandler);
        this.addMouseMoveListener(this);
        this.addKeyListener((KeyListener)this.keyHandler);
        this.addDisposeListener(this);
        this.addMouseListener((MouseListener)this.mouseButtonHandler);
        this.addMouseTrackListener((MouseTrackListener)this.mouseHoverHandler);
    }

    public void paintControl(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Point point = ((Control)paintEvent.getSource()).getSize();
        this.toUpdateTranform = true;
        this.draw(gC, 0, 0, point.x, point.y);
    }

    public void mouseScrolled(MouseEvent mouseEvent) {
        if (mouseEvent.count >= 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        this.setToolTipText(null);
        if (this.leftMouseButtonPressed) {
            int n = mouseEvent.x - this.lastOffsetX;
            int n2 = mouseEvent.y - this.lastOffsetY;
            this.lastOffsetX = mouseEvent.x;
            this.lastOffsetY = mouseEvent.y;
            if (n != 0 || n2 != 0) {
                this.addTranslation(n, n2);
            }
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (!this.isDisposed()) {
            this.dispose();
        }
    }

    public void render(StemPolygonsList stemPolygonsList) {
        this.polygonsToRender = stemPolygonsList;
        this.redraw();
    }

    public final void setDrawPolygonBorders(boolean bl) {
        this.drawPolygonBorders = bl;
    }

    public final void setGainFactor(float f) {
        this.gainFactor = f;
    }

    public final void setUseLogScaling(boolean bl) {
        this.useLogScaling = bl;
    }

    public void reset() {
        this.xTranslation = 0.0;
        this.yTranslation = 0.0;
        this.zoomFactor = 1.0;
    }

    void draw(GC gC, int n, int n2, int n3, int n4) {
        Object object2;
        gC.setBackground(this.stdColorProvider.getBackgroundColor());
        this.drawBackground(gC, n, n2, n3, n4);
        gC.setLineWidth(0);
        if (this.polygonsToRender == null || this.polygonsToRender.isEmpty()) {
            return;
        }
        if (this.toUpdateTranform) {
            this.computeTransform(this.polygonsToRender);
            for (Object object2 : this.polygonsToRender) {
                ((StemPolygon)object2).setPointsTransformer(this.pointsTransformer);
            }
            this.toUpdateTranform = false;
        }
        object2 = this.stdColorProvider.getBordersColor();
        for (Object object3 : this.polygonsToRender) {
            Identifiable identifiable = ((StemPolygon)object3).getIdentifiable();
            if (identifiable instanceof Node) {
                this.colorProvider.setTarget((Notifier)identifiable);
                this.colorProvider.updateGC(gC, this.gainFactor, this.useLogScaling);
                gC.fillPolygon(((StemPolygon)object3).transformedPoints);
                if (this.drawPolygonBorders) {
                    gC.setForeground((Color)object2);
                    gC.setAlpha(255);
                    gC.drawPolygon(((StemPolygon)object3).transformedPoints);
                }
            }
            if (!(identifiable instanceof Edge)) continue;
            gC.setForeground(this.stdColorProvider.getEdgesColor());
            if (((StemPolygon)object3).transformedPoints == null) {
                ((StemPolygon)object3).setPointsTransformer(this.pointsTransformer);
            }
            gC.drawLine(((StemPolygon)object3).transformedPoints[0], ((StemPolygon)object3).transformedPoints[1], ((StemPolygon)object3).transformedPoints[2], ((StemPolygon)object3).transformedPoints[3]);
        }
        gC.setForeground(this.getDisplay().getSystemColor(2));
    }

    private void computeTransform(StemPolygonsList stemPolygonsList) {
        if (this.polygonsBoundsRect == null) {
            this.polygonsBoundsRect = stemPolygonsList.getBounds();
            if (this.polygonsBoundsRect == null) {
                return;
            }
        }
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width - 20;
        int n2 = rectangle.height - 20;
        double d = this.polygonsBoundsRect.width;
        double d2 = this.polygonsBoundsRect.height;
        double d3 = (double)n / d;
        double d4 = (double)n2 / d2;
        double d5 = Math.min(d3, d4) * this.zoomFactor;
        int n3 = 0;
        int n4 = 0;
        if (d > 0.0 && d2 > 0.0) {
            n3 = (n - (int)(d * d5)) / 2;
            n4 = (n2 - (int)(d2 * d5)) / 2;
        }
        int n5 = this.polygonsBoundsRect.x;
        int n6 = this.polygonsBoundsRect.y;
        this.pointsTransformer.setOffsetX((double)(-n5) * d5 + 10.0 + (double)n3 + this.xTranslation * this.zoomFactor);
        this.pointsTransformer.setOffsetY((double)(-n6) * d5 + 10.0 + (double)n4 + this.yTranslation * this.zoomFactor);
        this.pointsTransformer.setScale(d5);
    }

    void zoomIn() {
        this.zoomFactor *= 1.1;
        this.toUpdateTranform = true;
        this.redraw();
    }

    void zoomOut() {
        this.zoomFactor *= 0.9090909090909091;
        this.toUpdateTranform = true;
        this.redraw();
    }

    StemPolygon getPolygon(MouseEvent mouseEvent) {
        Point point = this.pointsTransformer.getInversedPoint(mouseEvent.x, mouseEvent.y);
        return this.getPolygon(point);
    }

    StemPolygon getPolygon(Point point) {
        StemPolygon stemPolygon = null;
        if (point != null && this.polygonsToRender != null) {
            stemPolygon = this.polygonsToRender.getContainingRegionPolygon(point);
        }
        return stemPolygon;
    }

    protected void addTranslation(double d, double d2) {
        this.xTranslation += d / this.zoomFactor;
        this.yTranslation += d2 / this.zoomFactor;
        this.toUpdateTranform = true;
        this.redraw();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
        this.fireSelection(iSelection);
    }

    void fireSelection(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.selectionChangedListeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public void setColorProvider(ColorProviderAdapter colorProviderAdapter) {
        this.colorProvider = colorProviderAdapter;
    }

    public void dispose() {
        this.removePaintListener(this);
        this.removeMouseWheelListener(this);
        this.removeMouseTrackListener((MouseTrackListener)this.mouseTrackHandler);
        this.removeMouseMoveListener(this);
        this.removeKeyListener((KeyListener)this.keyHandler);
        this.removeDisposeListener(this);
        this.removeMouseListener((MouseListener)this.mouseButtonHandler);
        this.removeMouseTrackListener((MouseTrackListener)this.mouseHoverHandler);
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: {
                    MapCanvas.this.zoomIn();
                    break;
                }
                case 0x1000002: {
                    MapCanvas.this.zoomOut();
                    break;
                }
            }
        }
    }

    protected class MouseButtonHandler
    extends MouseAdapter {
        protected MouseButtonHandler() {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                MapCanvas.this.lastOffsetX = mouseEvent.x;
                MapCanvas.this.lastOffsetY = mouseEvent.y;
                MapCanvas.this.leftMouseButtonPressed = true;
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                int n = mouseEvent.x - MapCanvas.this.lastOffsetX;
                int n2 = mouseEvent.y - MapCanvas.this.lastOffsetY;
                if (n != 0 || n2 != 0) {
                    MapCanvas.this.addTranslation(n, n2);
                } else {
                    StemPolygon stemPolygon = MapCanvas.this.getPolygon(mouseEvent);
                    if (stemPolygon != null) {
                        GeographicSelectionElements geographicSelectionElements = new GeographicSelectionElements();
                        Point point = MapCanvas.this.pointsTransformer.getInversedPoint(mouseEvent.x, mouseEvent.y);
                        double d = stemPolygon.unScaleLongitude(point.x);
                        double d2 = stemPolygon.unScaleLatitude(point.y);
                        geographicSelectionElements.setPoint(d, d2);
                        Identifiable identifiable = stemPolygon.getIdentifiable();
                        Object[] objectArray = new Object[]{identifiable, geographicSelectionElements};
                        StructuredSelection structuredSelection = new StructuredSelection(objectArray);
                        MapCanvas.this.fireSelection((ISelection)structuredSelection);
                    }
                }
                MapCanvas.this.leftMouseButtonPressed = false;
            }
            SelectedReportsManager.getInstance().setRecentClickedMapCanvas((MapCanvas)((Object)mouseEvent.getSource()));
        }
    }

    protected class MouseHoverHandler
    extends MouseTrackAdapter {
        protected MouseHoverHandler() {
        }

        public void mouseHover(MouseEvent mouseEvent) {
            Point point = MapCanvas.this.pointsTransformer.getInversedPoint(mouseEvent.x, mouseEvent.y);
            StemPolygon stemPolygon = MapCanvas.this.getPolygon(point);
            if (stemPolygon != null) {
                Identifiable identifiable = stemPolygon.getIdentifiable();
                DublinCore dublinCore = identifiable.getDublinCore();
                String string = dublinCore.getIdentifier();
                String string2 = string.substring(string.lastIndexOf("/") + 1);
                if (string2 != null && !string2.equals("")) {
                    String string3 = GeographicNames.getName((String)string2);
                    StringBuilder stringBuilder = new StringBuilder(string3);
                    stringBuilder.append(" (");
                    stringBuilder.append(string2);
                    stringBuilder.append(")");
                    Region region = (Region)identifiable;
                    for (NodeLabel nodeLabel : region.getLabels()) {
                        if (nodeLabel instanceof PopulationLabel) {
                            stringBuilder.append("\nPopulation: " + nodeLabel);
                        }
                        if (!(nodeLabel instanceof AreaLabel)) continue;
                        stringBuilder.append("\nArea: " + nodeLabel);
                    }
                    if (point != null) {
                        double d = -1.0 * StemPolygon.getUnscaledLatitude(point.y);
                        double d2 = -1.0 * StemPolygon.getUnscaledLongitude(point.x);
                        stringBuilder.append("\nLatitude: " + d + ", Longitude: " + d2);
                    }
                    MapCanvas.this.setToolTipText(stringBuilder.toString());
                } else {
                    MapCanvas.this.setToolTipText(stemPolygon.getTitle());
                }
            } else {
                MapCanvas.this.setToolTipText(null);
            }
        }
    }

    protected class MouseTrackHandler
    extends MouseTrackAdapter {
        protected MouseTrackHandler() {
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            MapCanvas.this.forceFocus();
        }
    }
}

