/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.views.geographic.GeographicRenderer;
import org.eclipse.stem.ui.views.geographic.map.MapCanvas;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MapRenderer
extends GeographicRenderer
implements ISelectionChangedListener {
    private MapCanvas mapCanvas;
    private MenuManager menuManager;

    public MapRenderer(Composite composite, int n) {
        super(composite, n);
        this.setSize(-1, 100);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        this.setLayout((Layout)fillLayout);
        this.mapCanvas = new MapCanvas(this, 0);
        this.mapCanvas.setGainFactor(this.gainFactor);
        this.mapCanvas.setDrawPolygonBorders(this.drawPolygonBorders);
        this.mapCanvas.setColorProvider(this.colorProviderAdapter);
        this.pack();
        this.mapCanvas.addSelectionChangedListener(this);
        this.menuManager = this.createContextMenuManager();
        this.mapCanvas.setMenu(this.menuManager.createContextMenu((Control)this));
    }

    public void render(StemPolygonsList stemPolygonsList) {
        this.mapCanvas.setGainFactor(this.gainFactor);
        this.mapCanvas.setUseLogScaling(this.useLogScaling);
        this.mapCanvas.render(stemPolygonsList);
    }

    public void reset() {
        super.reset();
        this.mapCanvas.reset();
        this.mapCanvas.setDrawPolygonBorders(this.drawPolygonBorders);
        this.mapCanvas.setGainFactor(this.gainFactor);
        this.mapCanvas.setUseLogScaling(this.useLogScaling);
    }

    protected void toggleDrawPolygonBordersChoice() {
        super.toggleDrawPolygonBordersChoice();
        this.mapCanvas.setDrawPolygonBorders(this.drawPolygonBorders);
        this.redraw();
    }

    protected void toggleUseLogScaling() {
        super.toggleUseLogScaling();
        this.mapCanvas.setUseLogScaling(this.useLogScaling);
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public void setColorProviderAdapter(ColorProviderAdapter colorProviderAdapter) {
        super.setColorProviderAdapter(colorProviderAdapter);
        this.mapCanvas.setColorProvider(colorProviderAdapter);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fireSelection(selectionChangedEvent.getSelection());
    }

    public void dispose() {
        super.dispose();
        this.mapCanvas.removeSelectionChangedListener(this);
    }
}

