/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.ui.views.geographic.map.MapCanvas;

public class SelectedReportsManager {
    private static SelectedReportsManager instance;
    private final Map<MapCanvas, List<String>> enabledReportsMap = new HashMap<MapCanvas, List<String>>();
    private final Map<MapCanvas, List<String>> alreadySelectedReports = new HashMap<MapCanvas, List<String>>();
    private MapCanvas recentClickedMapCanvas = null;

    private SelectedReportsManager() {
    }

    public static SelectedReportsManager getInstance() {
        if (instance == null) {
            instance = new SelectedReportsManager();
        }
        return instance;
    }

    public void enableReportForIdentifiable(String string) {
        List<String> list = null;
        if (this.enabledReportsMap.containsKey((Object)this.recentClickedMapCanvas)) {
            list = this.enabledReportsMap.get((Object)this.recentClickedMapCanvas);
            this.enabledReportsMap.remove((Object)this.recentClickedMapCanvas);
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(string);
        this.enabledReportsMap.put(this.recentClickedMapCanvas, list);
    }

    public void disableReportForIdentifiable(String string) {
        List<String> list;
        List<String> list2 = null;
        if (this.enabledReportsMap.containsKey((Object)this.recentClickedMapCanvas)) {
            list2 = this.enabledReportsMap.get((Object)this.recentClickedMapCanvas);
            this.enabledReportsMap.remove((Object)this.recentClickedMapCanvas);
        }
        if (list2 != null) {
            list2.remove(string);
        }
        if ((list = this.alreadySelectedReports.get((Object)this.recentClickedMapCanvas)) == null) {
            list = new ArrayList<String>();
        }
        list.add(string);
        if (this.alreadySelectedReports.containsKey((Object)this.recentClickedMapCanvas)) {
            this.alreadySelectedReports.remove((Object)this.recentClickedMapCanvas);
        }
        this.alreadySelectedReports.put(this.recentClickedMapCanvas, list);
    }

    public boolean isReportEnabled(String string) {
        List<String> list = this.alreadySelectedReports.get((Object)this.recentClickedMapCanvas);
        if (list == null || !list.contains(string)) {
            return true;
        }
        if (!this.enabledReportsMap.containsKey((Object)this.recentClickedMapCanvas)) {
            return false;
        }
        List<String> list2 = this.enabledReportsMap.get((Object)this.recentClickedMapCanvas);
        return list2 != null && list2.contains(string);
    }

    public MapCanvas getRecentClickedMapCanvas() {
        return this.recentClickedMapCanvas;
    }

    public void setRecentClickedMapCanvas(MapCanvas mapCanvas) {
        this.recentClickedMapCanvas = mapCanvas;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

