/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonTransform;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class StemPolygon {
    private static final int LATITUDE_DIRECTION = -1;
    private static final long serialVersionUID = 1L;
    private static final int scalingFactorForData = 1000000;
    private transient Identifiable identifiable;
    public int[] points = null;
    public int[] transformedPoints = null;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;

    public StemPolygon() {
    }

    public StemPolygon(LatLong.Segment segment, Identifiable identifiable) {
        this.identifiable = identifiable;
        int n = segment.size();
        this.points = new int[2 * n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            this.addPoint(segment.longitude(n2), segment.latitude(n2), n3);
            ++n2;
            n3 += 2;
        }
    }

    private void addPoint(double d, double d2, int n) {
        int n2 = (int)(d * 1000000.0);
        int n3 = (int)(d2 * 1000000.0 * -1.0);
        this.points[n] = n2;
        this.points[n + 1] = n3;
        this.maxX = Math.max(n2, this.maxX);
        this.maxY = Math.max(n3, this.maxY);
        this.minX = Math.min(n2, this.minX);
        this.minY = Math.min(n3, this.minY);
    }

    public void setPointsTransformer(StemPolygonTransform stemPolygonTransform) {
        this.transformedPoints = new int[this.getNumberOfPoints() * 2];
        int n = 0;
        while (n < this.getNumberOfPoints()) {
            int n2 = this.points[2 * n];
            int n3 = this.points[2 * n + 1];
            int n4 = (int)((double)n2 * stemPolygonTransform.getScale() + stemPolygonTransform.getOffsetX());
            int n5 = (int)((double)n3 * stemPolygonTransform.getScale() + stemPolygonTransform.getOffsetY());
            this.transformedPoints[2 * n] = n4;
            this.transformedPoints[2 * n + 1] = n5;
            ++n;
        }
    }

    public double unScaleLongitude(double d) {
        return d / 1000000.0;
    }

    public double unScaleLatitude(double d) {
        return d / 1000000.0 * -1.0;
    }

    public String getTitle() {
        return this.identifiable.getDublinCore().getTitle();
    }

    public final Identifiable getIdentifiable() {
        return this.identifiable;
    }

    public final void setIdentifiable(Identifiable identifiable) {
        this.identifiable = identifiable;
    }

    public Rectangle getBounds() {
        if (this.minX == Integer.MAX_VALUE && this.maxY == Integer.MIN_VALUE) {
            return null;
        }
        Rectangle rectangle = new Rectangle(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
        return rectangle;
    }

    public boolean containsPoint(Point point) {
        return this.containsPoint(point.x, point.y);
    }

    public boolean containsPoint(int n, int n2) {
        boolean bl = false;
        int n3 = this.points.length / 2;
        int n4 = 0;
        int n5 = (n3 - 1) * 2;
        while (n4 < this.points.length - 1) {
            if ((this.points[n4 + 1] <= n2 && n2 < this.points[n5 + 1] || this.points[n5 + 1] <= n2 && n2 < this.points[n4 + 1]) && n < (this.points[n5] - this.points[n4]) * (n2 - this.points[n4 + 1]) / (this.points[n5 + 1] - this.points[n4 + 1]) + this.points[n4]) {
                bl = !bl;
            }
            n5 = n4;
            n4 += 2;
        }
        return bl;
    }

    public int getNumberOfPoints() {
        if (this.points == null) {
            return 0;
        }
        return this.points.length / 2;
    }

    public double getNonScaledLatitude(int n) {
        return (double)this.points[2 * n + 1] / 1000000.0;
    }

    public double getNonScaledLongitude(int n) {
        return (double)this.points[2 * n] / 1000000.0 * -1.0;
    }

    public static double getUnscaledLatitude(int n) {
        return (double)n / 1000000.0;
    }

    public static double getUnscaledLongitude(int n) {
        return (double)n / 1000000.0 * -1.0;
    }
}

