/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.swt.graphics.Point;

public class StemPolygonTransform {
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double scale = 1.0;

    private Point2D getInversedPoint(java.awt.Point point) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(this.offsetX, this.offsetY);
        affineTransform.scale(this.scale, this.scale);
        Point2D point2D = new Point2D.Double(0.0, 0.0);
        try {
            point2D = affineTransform.inverseTransform(point, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            Activator.logError((String)("Problem inverting point " + point), (Throwable)noninvertibleTransformException);
            return new java.awt.Point();
        }
        return point2D;
    }

    public Point getInversedPoint(int n, int n2) {
        Point2D point2D = this.getInversedPoint(new java.awt.Point(n, n2));
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double d) {
        this.offsetX = d;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double d) {
        this.offsetY = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }
}

