/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.util.LinkedList;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.ui.views.geographic.map.StemPolygon;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StemPolygonsList
extends LinkedList<StemPolygon> {
    private static final long serialVersionUID = 1L;
    private transient Rectangle bounds = null;

    public StemPolygonsList() {
    }

    public StemPolygonsList(LatLong latLong, Identifiable identifiable) {
        for (LatLong.Segment segment : latLong.getSegments()) {
            this.add(new StemPolygon(segment, identifiable));
        }
    }

    private void updateBounds(StemPolygon stemPolygon) {
        if (stemPolygon.getIdentifiable() instanceof Edge) {
            return;
        }
        this.bounds = this.bounds != null ? this.bounds.union(stemPolygon.getBounds()) : stemPolygon.getBounds();
    }

    public final Rectangle getBounds() {
        for (StemPolygon stemPolygon : this) {
            this.updateBounds(stemPolygon);
        }
        return this.bounds;
    }

    public StemPolygon getContainingRegionPolygon(Point point) {
        StemPolygon stemPolygon = null;
        for (StemPolygon stemPolygon2 : this) {
            if (!stemPolygon2.containsPoint(point) || !(stemPolygon2.getIdentifiable() instanceof Region)) continue;
            stemPolygon = stemPolygon2;
            break;
        }
        return stemPolygon;
    }
}

