/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorProviderPropertiesComposite
extends Composite {
    private final List<PropertySelectionListener> propertySelectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    private String initialPropertyName;
    Combo propertiesCombo;
    List<ItemPropertyDescriptor> properties;
    ItemPropertyDescriptor selectedProperty;
    private PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (relativeValueProviderAdapter != null) {
                relativeValueProviderAdapter.setTarget((Notifier)dynamicLabel);
                for (Object e : relativeValueProviderAdapter.getProperties()) {
                    ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)e;
                    arrayList.add(itemPropertyDescriptor);
                }
            }
            return arrayList;
        }
    };

    public ColorProviderPropertiesComposite(Composite composite, int n) {
        super(composite, n);
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.propertiesCombo = new Combo((Composite)this, 0x100000C);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.propertiesCombo.setLayoutData((Object)formData);
        this.propertiesCombo.setEnabled(false);
        this.pack();
        this.propertiesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemPropertyDescriptor itemPropertyDescriptor;
                if (!ColorProviderPropertiesComposite.this.properties.isEmpty() && ColorProviderPropertiesComposite.this.selectedProperty != (itemPropertyDescriptor = ColorProviderPropertiesComposite.this.properties.get(ColorProviderPropertiesComposite.this.propertiesCombo.getSelectionIndex()))) {
                    ColorProviderPropertiesComposite.this.selectedProperty = itemPropertyDescriptor;
                    ColorProviderPropertiesComposite.this.notifyPropertySelection(ColorProviderPropertiesComposite.this.selectedProperty);
                }
            }
        });
    }

    void notifyPropertySelection(ItemPropertyDescriptor itemPropertyDescriptor) {
        if (itemPropertyDescriptor != null) {
            this.firePropertySelectionEvent(new PropertySelectionEvent(itemPropertyDescriptor, (Object)this));
        }
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            arrayList.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return arrayList;
    }

    public ItemPropertyDescriptor getDefaultSelectedProperty() {
        for (ItemPropertyDescriptor itemPropertyDescriptor : this.properties) {
            if (!itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor).equals(this.initialPropertyName)) continue;
            return itemPropertyDescriptor;
        }
        if (!this.properties.isEmpty()) {
            return this.properties.get(0);
        }
        return null;
    }

    public void initialize(Decorator decorator) {
        this.properties = this.getPropertiesToDisplay(decorator);
        this.selectedProperty = this.getDefaultSelectedProperty();
        boolean bl = decorator != null;
        this.initializeCombo(this.propertiesCombo, this.getPropertyNames(this.properties), this.getPropertyIndex(this.selectedProperty, this.properties), bl);
        this.notifyPropertySelection(this.selectedProperty);
    }

    void initializeCombo(Combo combo, String[] stringArray, int n, boolean bl) {
        combo.setItems(stringArray);
        combo.select(n);
        this.propertiesCombo.setEnabled(bl);
    }

    String[] getPropertyNames(List<ItemPropertyDescriptor> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (ItemPropertyDescriptor itemPropertyDescriptor : list) {
                arrayList.add(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    int getPropertyIndex(ItemPropertyDescriptor itemPropertyDescriptor, List<ItemPropertyDescriptor> list) {
        if (itemPropertyDescriptor != null) {
            return list.indexOf(itemPropertyDescriptor);
        }
        return 0;
    }

    public void addPropertySelectionListener(PropertySelectionListener propertySelectionListener) {
        this.propertySelectionListeners.add(propertySelectionListener);
    }

    public void removePropertySelectionListener(PropertySelectionListener propertySelectionListener) {
        this.propertySelectionListeners.remove(propertySelectionListener);
    }

    private void firePropertySelectionEvent(PropertySelectionEvent propertySelectionEvent) {
        for (PropertySelectionListener propertySelectionListener : this.propertySelectionListeners) {
            propertySelectionListener.propertySelected(propertySelectionEvent);
        }
    }

    public void setPropertySieve(PropertySieve propertySieve) {
        this.propertySieve = propertySieve;
    }

    public String getInitialPropertyName() {
        return this.initialPropertyName;
    }

    public void setInitialPropertyName(String string) {
        this.initialPropertyName = string;
    }

    public ItemPropertyDescriptor getSelectedProperty() {
        return this.selectedProperty;
    }

    public static class PropertySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient ItemPropertyDescriptor property;

        public PropertySelectionEvent(ItemPropertyDescriptor itemPropertyDescriptor, Object object) {
            super(object);
            this.property = itemPropertyDescriptor;
        }

        public final ItemPropertyDescriptor getProperty() {
            return this.property;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.property == null ? "null" : this.property.getDisplayName((Object)this.property));
            return stringBuilder.toString();
        }
    }

    public static interface PropertySelectionListener {
        public void propertySelected(PropertySelectionEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

