/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderChangedListener;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.stem.ui.widgets.ColorProviderPropertiesComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoViewOptionsBar
extends Composite {
    private final List<PropertySelectionListener> selectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    protected final List<IColorProviderChangedListener> colorProviderChangedListeners = new CopyOnWriteArrayList<IColorProviderChangedListener>();
    Combo decoratorsCombo;
    Combo colorProvidersCombo;
    static final int DECORATORS_WIDTH = 55;
    static final int PROVIDERS_WIDTH = 65;
    Combo edgesCombo;
    Composite colorProviderComposite;
    Composite colorsLegendComposite;
    Group geoViewOptionsGroup;
    Group edgesGroup;
    List<Decorator> decorators;
    List<Class> supportedColorProviders = null;
    List<String> supportedColorProvidersNames = null;
    Map<String, String> edgeTypeToUriPrefixMap = new HashMap<String, String>();
    Class selectedColorProvider = null;
    Decorator selectedDecorator;
    private DecoratorFilter decoratorFilter = new DecoratorFilter(){

        public boolean accept(Decorator decorator) {
            EList eList = decorator.getLabelsToUpdate();
            if (eList == null) {
                return false;
            }
            for (DynamicLabel dynamicLabel : eList) {
                RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
                if (relativeValueProviderAdapter == null) continue;
                return true;
            }
            return false;
        }
    };

    public GeoViewOptionsBar(Composite composite, int n) {
        super(composite, n);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        this.setLayout((Layout)rowLayout);
        this.geoViewOptionsGroup = new Group((Composite)this, 0);
        FormLayout formLayout = new FormLayout();
        this.geoViewOptionsGroup.setLayout((Layout)formLayout);
        this.geoViewOptionsGroup.setText(Messages.getString("IMView.MProp"));
        this.geoViewOptionsGroup.setVisible(false);
        this.decoratorsCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        this.colorProvidersCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(55, 0);
        this.decoratorsCombo.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.decoratorsCombo, 5);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(65, 0);
        this.colorProvidersCombo.setLayoutData((Object)formData2);
        this.supportedColorProviders = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProviders();
        this.supportedColorProvidersNames = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProvidersNames();
        this.pack();
        this.decoratorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Decorator decorator;
                if (!GeoViewOptionsBar.this.decorators.isEmpty() && GeoViewOptionsBar.this.selectedDecorator != (decorator = GeoViewOptionsBar.this.decorators.get(GeoViewOptionsBar.this.decoratorsCombo.getSelectionIndex()))) {
                    GeoViewOptionsBar.this.selectedDecorator = decorator;
                    GeoViewOptionsBar.this.updateColorProviderComposites();
                    GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(GeoViewOptionsBar.this.selectedDecorator, null, GeoViewOptionsBar.this.colorProvidersCombo));
                }
            }
        });
        this.colorProvidersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GeoViewOptionsBar.this.selectedColorProvider = GeoViewOptionsBar.this.supportedColorProviders.get(GeoViewOptionsBar.this.colorProvidersCombo.getSelectionIndex());
                GeoViewOptionsBar.this.updateColorProviderComposites();
            }
        });
        this.edgesGroup = new Group((Composite)this, 0);
        this.edgesCombo = new Combo((Composite)this.edgesGroup, 0x100000C);
        this.edgesCombo.add("");
        this.edgesGroup.setLayout((Layout)new FormLayout());
        this.edgesGroup.setVisible(false);
        this.edgesGroup.setText(Messages.getString("IMView.Edges"));
        this.edgesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = GeoViewOptionsBar.this.edgesCombo.getText();
                if (string == null || string.equals("")) {
                    GeoViewOptionsBar.this.firePropertySelectionEvent(null);
                } else {
                    String string2 = GeoViewOptionsBar.this.edgeTypeToUriPrefixMap.get(string);
                    GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(null, null, string2));
                }
            }
        });
        this.setSimulation(null);
    }

    public boolean isInitialized() {
        return this.decorators != null && !this.decorators.isEmpty();
    }

    public void setDecorators(List<Decorator> list) {
        this.decorators = list;
        this.selectedDecorator = list.isEmpty() ? null : list.get(0);
        this.initializeCombo(this.decoratorsCombo, this.getDecoratorNames(list), this.getDecoratorIndex(this.selectedDecorator, list));
    }

    public void setColorProviders(List<Decorator> list) {
        if (this.supportedColorProviders.isEmpty()) {
            return;
        }
        for (String string : this.supportedColorProvidersNames) {
            this.colorProvidersCombo.add(string);
        }
        this.colorProvidersCombo.select(0);
        this.selectedColorProvider = this.supportedColorProviders.get(0);
        this.updateColorProviderComposites();
    }

    private void setEdges() {
        if (this.selectedDecorator == null) {
            return;
        }
        Set set = this.selectedDecorator.getGraph().getEdges().keySet();
        for (URI uRI : set) {
            String string = uRI.trimSegments(1).toString();
            String string2 = org.eclipse.stem.ui.preferences.Messages.getString(string);
            if (string2.startsWith("!") && string2.endsWith("!")) {
                string = uRI.trimSegments(2).toString();
                string2 = org.eclipse.stem.ui.preferences.Messages.getString(string);
            }
            if (this.edgeTypeToUriPrefixMap.containsKey(string2)) continue;
            this.edgeTypeToUriPrefixMap.put(string2, string);
            this.edgesCombo.add(string2);
        }
    }

    public void setSimulation(ISimulation iSimulation) {
        if (iSimulation == null) {
            return;
        }
        this.setDecorators(this.getDecoratorsToDisplay(iSimulation));
        if (this.decorators != null) {
            this.setColorProviders(this.decorators);
            this.geoViewOptionsGroup.setVisible(true);
            this.setEdges();
            this.edgesGroup.setVisible(true);
            this.getInformation(iSimulation);
        }
    }

    public void setDecoratorFilter(DecoratorFilter decoratorFilter) {
        this.decoratorFilter = decoratorFilter;
    }

    protected void updateColorProviderComposites() {
        AdapterFactory adapterFactory;
        if (this.colorProviderComposite != null) {
            this.colorProviderComposite.dispose();
        }
        if (this.colorsLegendComposite != null) {
            this.colorsLegendComposite.dispose();
        }
        if ((adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(this.selectedColorProvider)) instanceof IColorProviderAdapterFactory) {
            IColorProviderAdapterFactory iColorProviderAdapterFactory = (IColorProviderAdapterFactory)adapterFactory;
            this.colorProviderComposite = iColorProviderAdapterFactory.createPropertiesComposite((Composite)this.geoViewOptionsGroup, 0, this.selectedDecorator);
            if (this.colorProviderComposite == null) {
                return;
            }
            if (this.colorProviderComposite instanceof ColorProviderPropertiesComposite) {
                ((ColorProviderPropertiesComposite)this.colorProviderComposite).addPropertySelectionListener(new ColorProviderPropertiesComposite.PropertySelectionListener(){

                    public void propertySelected(ColorProviderPropertiesComposite.PropertySelectionEvent propertySelectionEvent) {
                        GeoViewOptionsBar.this.firePropertySelectionEvent(new PropertySelectionEvent(null, null, propertySelectionEvent.getSource()));
                    }
                });
            }
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(55, 0);
            formData.right = new FormAttachment(65, 0);
            this.colorProviderComposite.setLayoutData((Object)formData);
            this.geoViewOptionsGroup.layout();
            this.colorsLegendComposite = iColorProviderAdapterFactory.createColorsLegendComposite(this, 0);
            if (this.colorsLegendComposite != null) {
                this.colorsLegendComposite.pack();
                this.colorsLegendComposite.layout();
            }
            this.layout();
        }
        this.fireColorProviderChangedEvent();
    }

    private List<Decorator> getDecoratorsToDisplay(ISimulation iSimulation) {
        Graph graph;
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (iSimulation != null && (graph = iSimulation.getScenario().getCanonicalGraph()) != null) {
            for (Object e : graph.getDecorators()) {
                Decorator decorator = (Decorator)e;
                if (!this.decoratorFilter.accept(decorator)) continue;
                arrayList.add(decorator);
            }
        }
        return arrayList;
    }

    private void getInformation(ISimulation iSimulation) {
        Graph graph;
        if (iSimulation != null && (graph = iSimulation.getScenario().getCanonicalGraph()) != null) {
            graph.getGraphLabels();
            graph.getNodeLabelsByTypeURI(URI.createURI((String)"stemtype://org.eclipse.stem/label/population"));
        }
    }

    private void initializeCombo(Combo combo, String[] stringArray, int n) {
        combo.setItems(stringArray);
        combo.select(n);
    }

    private String[] getDecoratorNames(List<Decorator> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (Decorator decorator : list) {
                String string = decorator.getDublinCore().getTitle();
                string = string == null ? "null" : string;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private int getDecoratorIndex(Decorator decorator, List<Decorator> list) {
        if (decorator != null && list != null && !list.isEmpty()) {
            return list.indexOf(decorator);
        }
        return 0;
    }

    public void addPropertySelectionListener(PropertySelectionListener propertySelectionListener) {
        this.selectionListeners.add(propertySelectionListener);
    }

    public void removePropertySelectionListener(PropertySelectionListener propertySelectionListener) {
        this.selectionListeners.remove(propertySelectionListener);
    }

    protected void firePropertySelectionEvent(PropertySelectionEvent propertySelectionEvent) {
        for (PropertySelectionListener propertySelectionListener : this.selectionListeners) {
            propertySelectionListener.propertySelected(propertySelectionEvent);
        }
    }

    public void addColorProviderChangedListener(IColorProviderChangedListener iColorProviderChangedListener) {
        this.colorProviderChangedListeners.add(iColorProviderChangedListener);
    }

    public void removeColorProviderChangedListener(IColorProviderChangedListener iColorProviderChangedListener) {
        this.colorProviderChangedListeners.remove(iColorProviderChangedListener);
    }

    protected void fireColorProviderChangedEvent() {
        for (IColorProviderChangedListener iColorProviderChangedListener : this.colorProviderChangedListeners) {
            iColorProviderChangedListener.colorProviderChanged(this.selectedColorProvider);
        }
    }

    public Decorator getSelectedDecorator() {
        return this.selectedDecorator;
    }

    public static interface DecoratorFilter {
        public boolean accept(Decorator var1);
    }

    public static class PropertySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient ItemPropertyDescriptor property;
        private final transient Decorator decorator;

        public PropertySelectionEvent(Decorator decorator, ItemPropertyDescriptor itemPropertyDescriptor, Object object) {
            super(object);
            this.decorator = decorator;
            this.property = itemPropertyDescriptor;
        }

        public final Decorator getDecorator() {
            return this.decorator;
        }

        public final ItemPropertyDescriptor getProperty() {
            return this.property;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.decorator == null ? "null," : this.decorator.getDublinCore().getTitle());
            stringBuilder.append(this.property == null ? "null" : this.property.getDisplayName((Object)this.property));
            return stringBuilder.toString();
        }
    }

    public static interface PropertySelectionListener {
        public void propertySelected(PropertySelectionEvent var1);
    }
}

