/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySelector
extends Composite {
    private final List<PropertySelectionListener> propertySelectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    private ISimulation simulation = null;
    private String initialPropertyName;
    private final Label displayLabel;
    Combo decoratorsCombo;
    Combo propertiesCombo;
    List<Decorator> decorators;
    Decorator selectedDecorator;
    List<ItemPropertyDescriptor> properties;
    ItemPropertyDescriptor selectedProperty;
    private DecoratorFilter decoratorFilter = new DecoratorFilter(){

        public boolean accept(Decorator decorator) {
            return true;
        }
    };
    private PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (relativeValueProviderAdapter != null) {
                relativeValueProviderAdapter.setTarget((Notifier)dynamicLabel);
                for (Object e : relativeValueProviderAdapter.getProperties()) {
                    ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)e;
                    arrayList.add(itemPropertyDescriptor);
                }
            }
            return arrayList;
        }
    };

    public PropertySelector(Composite composite, int n) {
        super(composite, n);
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.displayLabel = new Label((Composite)this, 0x1000000);
        this.displayLabel.setText(String.valueOf(Messages.getString("IMView.MProp")) + " :");
        this.decoratorsCombo = new Combo((Composite)this, 0x100000C);
        this.propertiesCombo = new Combo((Composite)this, 0x100000C);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.displayLabel, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.decoratorsCombo.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.decoratorsCombo, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        this.propertiesCombo.setLayoutData((Object)formData2);
        this.pack();
        this.decoratorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Decorator decorator;
                if (!PropertySelector.this.decorators.isEmpty() && PropertySelector.this.selectedDecorator != (decorator = PropertySelector.this.decorators.get(PropertySelector.this.decoratorsCombo.getSelectionIndex()))) {
                    PropertySelector.this.selectedDecorator = decorator;
                    PropertySelector.this.properties = PropertySelector.this.getPropertiesToDisplay(PropertySelector.this.selectedDecorator);
                    PropertySelector.this.selectedProperty = PropertySelector.this.selectCurrentDecoratorProperty(PropertySelector.this.properties);
                    PropertySelector.this.initializeCombo(PropertySelector.this.propertiesCombo, PropertySelector.this.getPropertyNames(PropertySelector.this.properties), PropertySelector.this.getPropertyIndex(PropertySelector.this.selectedProperty, PropertySelector.this.properties));
                    PropertySelector.this.notifyPropertySelection(PropertySelector.this.selectedProperty);
                }
            }
        });
        this.propertiesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemPropertyDescriptor itemPropertyDescriptor;
                if (!PropertySelector.this.properties.isEmpty() && PropertySelector.this.selectedProperty != (itemPropertyDescriptor = PropertySelector.this.properties.get(PropertySelector.this.propertiesCombo.getSelectionIndex()))) {
                    PropertySelector.this.selectedProperty = itemPropertyDescriptor;
                    PropertySelector.this.notifyPropertySelection(PropertySelector.this.selectedProperty);
                }
            }
        });
        this.setSimulation(null);
    }

    void notifyPropertySelection(ItemPropertyDescriptor itemPropertyDescriptor) {
        if (itemPropertyDescriptor != null) {
            this.firePropertySelectionEvent(new PropertySelectionEvent(this.selectedDecorator, itemPropertyDescriptor, (Object)this));
        }
    }

    public boolean isInitialized() {
        return this.decorators != null && !this.decorators.isEmpty();
    }

    public void setDecorators(List<Decorator> list) {
        this.decorators = list;
        this.selectedDecorator = list.isEmpty() ? null : list.get(0);
        this.properties = this.getPropertiesToDisplay(this.selectedDecorator);
        this.selectedProperty = this.selectCurrentDecoratorProperty(this.properties);
        this.initializeCombo(this.decoratorsCombo, this.getDecoratorNames(list), this.getDecoratorIndex(this.selectedDecorator, list));
        this.initializeCombo(this.propertiesCombo, this.getPropertyNames(this.properties), this.getPropertyIndex(this.selectedProperty, this.properties));
        this.notifyPropertySelection(this.selectedProperty);
    }

    public void setSimulation(ISimulation iSimulation) {
        this.simulation = iSimulation;
        this.setDecorators(this.getDecoratorsToDisplay(iSimulation));
    }

    public final ISimulation getSimulation() {
        return this.simulation;
    }

    public void setDecoratorFilter(DecoratorFilter decoratorFilter) {
        this.decoratorFilter = decoratorFilter;
    }

    public void setPropertySieve(PropertySieve propertySieve) {
        this.propertySieve = propertySieve;
    }

    private List<Decorator> getDecoratorsToDisplay(ISimulation iSimulation) {
        Graph graph;
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (iSimulation != null && (graph = iSimulation.getScenario().getCanonicalGraph()) != null) {
            for (Object e : graph.getDecorators()) {
                Decorator decorator = (Decorator)e;
                if (!this.decoratorFilter.accept(decorator)) continue;
                arrayList.add(decorator);
            }
        }
        return arrayList;
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            arrayList.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return arrayList;
    }

    ItemPropertyDescriptor selectCurrentDecoratorProperty(List<ItemPropertyDescriptor> list) {
        for (ItemPropertyDescriptor itemPropertyDescriptor : list) {
            if (!itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor).equals(this.initialPropertyName)) continue;
            return itemPropertyDescriptor;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    void initializeCombo(Combo combo, String[] stringArray, int n) {
        combo.setItems(stringArray);
        combo.select(n);
    }

    private String[] getDecoratorNames(List<Decorator> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (Decorator decorator : list) {
                arrayList.add(decorator.getDublinCore().getTitle());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private int getDecoratorIndex(Decorator decorator, List<Decorator> list) {
        if (decorator != null && list != null && !list.isEmpty()) {
            return list.indexOf(decorator);
        }
        return 0;
    }

    String[] getPropertyNames(List<ItemPropertyDescriptor> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (ItemPropertyDescriptor itemPropertyDescriptor : list) {
                arrayList.add(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    int getPropertyIndex(ItemPropertyDescriptor itemPropertyDescriptor, List<ItemPropertyDescriptor> list) {
        if (itemPropertyDescriptor != null) {
            return list.indexOf(itemPropertyDescriptor);
        }
        return 0;
    }

    public boolean setDisplayedProperty(String string) {
        int n = this.propertiesCombo.indexOf(string);
        if (n >= 0) {
            this.propertiesCombo.select(n);
            this.initialPropertyName = string;
            this.properties = this.getPropertiesToDisplay(this.selectedDecorator);
            for (ItemPropertyDescriptor itemPropertyDescriptor : this.properties) {
                if (!itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor).equals(this.initialPropertyName)) continue;
                this.selectedProperty = itemPropertyDescriptor;
                break;
            }
            this.firePropertySelectionEvent(new PropertySelectionEvent(this.selectedDecorator, this.selectedProperty, this.propertiesCombo));
            return true;
        }
        return false;
    }

    public void addPropertySelectionListener(PropertySelectionListener propertySelectionListener) {
        this.propertySelectionListeners.add(propertySelectionListener);
    }

    public void removePropertySelectionListener(PropertySelectionListener propertySelectionListener) {
        this.propertySelectionListeners.remove(propertySelectionListener);
    }

    private void firePropertySelectionEvent(PropertySelectionEvent propertySelectionEvent) {
        for (PropertySelectionListener propertySelectionListener : this.propertySelectionListeners) {
            propertySelectionListener.propertySelected(propertySelectionEvent);
        }
    }

    public String getDisplayLabel() {
        return this.displayLabel.getText();
    }

    public void setDisplayLabel(String string) {
        this.displayLabel.setText(string);
    }

    public static interface DecoratorFilter {
        public boolean accept(Decorator var1);
    }

    public static class PropertySelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient ItemPropertyDescriptor property;
        private final transient Decorator decorator;

        public PropertySelectionEvent(Decorator decorator, ItemPropertyDescriptor itemPropertyDescriptor, Object object) {
            super(object);
            this.decorator = decorator;
            this.property = itemPropertyDescriptor;
        }

        public final Decorator getDecorator() {
            return this.decorator;
        }

        public final ItemPropertyDescriptor getProperty() {
            return this.property;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.decorator == null ? "null," : this.decorator.getDublinCore().getTitle());
            stringBuilder.append(this.property == null ? "null" : this.property.getDisplayName((Object)this.property));
            return stringBuilder.toString();
        }
    }

    public static interface PropertySelectionListener {
        public void propertySelected(PropertySelectionEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

