/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.common.CommonFactory;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DublinCorePage
extends WizardPage {
    private static final String REQUIRED_FIELD_CHAR = "*";
    private final ModifyListener dcValidator = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            DublinCorePage.this.setPageComplete(DublinCorePage.this.validateDublinCorePage());
        }
    };
    protected Text title;
    protected Text description;
    protected Text creator;
    protected Text date;
    protected Text format;
    protected Text publisher;
    protected Text coverage;
    protected Text contributor;
    protected Text relation;
    protected Text rights;
    protected Text source;
    protected Text subject;
    protected Text type;
    protected Text language;
    protected Text bibliographicCitation;
    protected Text created;
    protected Text license;
    protected Text required;
    protected Text spatial;
    protected Text valid;

    protected DublinCorePage() {
        super(Messages.getString("NDublinCore.page_title"));
        this.setTitle(Messages.getString("NDublinCore.page_title"));
        this.setDescription(Messages.getString("NDublinCore.page_description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 12;
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        composite2.setLayoutData((Object)gridData);
        this.title = this.createDCAttribute(composite2, Messages.getString("NDublinCore.title"), Messages.getString("NDublinCore.titleDesc"), true, true);
        this.description = this.createDCAttribute(composite2, Messages.getString("NDublinCore.desc"), Messages.getString("NDublinCore.descDesc"), false, false);
        this.creator = this.createDCAttribute(composite2, Messages.getString("NDublinCore.creator"), Messages.getString("NDublinCore.creatorDesc"), false, false);
        this.date = this.createDCAttribute(composite2, Messages.getString("NDublinCore.date"), Messages.getString("NDublinCore.dateDesc"), false, true);
        this.valid = this.createDCAttribute(composite2, Messages.getString("NDublinCore.valid"), Messages.getString("NDublinCore.validDesc"), false, true);
        this.created = this.createDCAttribute(composite2, Messages.getString("NDublinCore.created"), Messages.getString("NDublinCore.createdDesc"), false, true);
        this.source = this.createDCAttribute(composite2, Messages.getString("NDublinCore.source"), Messages.getString("NDublinCore.sourceDesc"), false, false);
        this.publisher = this.createDCAttribute(composite2, Messages.getString("NDublinCore.publisher"), Messages.getString("NDublinCore.publisherDesc"), false, false);
        this.coverage = this.createDCAttribute(composite2, Messages.getString("NDublinCore.coverage"), Messages.getString("NDublinCore.coverageDesc"), false, false);
        this.contributor = this.createDCAttribute(composite2, Messages.getString("NDublinCore.contributor"), Messages.getString("NDublinCore.contributorDesc"), false, false);
        this.relation = this.createDCAttribute(composite2, Messages.getString("NDublinCore.relation"), Messages.getString("NDublinCore.relationDesc"), false, false);
        this.rights = this.createDCAttribute(composite2, Messages.getString("NDublinCore.rights"), Messages.getString("NDublinCore.rightsDesc"), false, false);
        this.subject = this.createDCAttribute(composite2, Messages.getString("NDublinCore.subject"), Messages.getString("NDublinCore.subjectDesc"), false, false);
        this.language = this.createDCAttribute(composite2, Messages.getString("NDublinCore.language"), Messages.getString("NDublinCore.languageDesc"), false, false);
        this.bibliographicCitation = this.createDCAttribute(composite2, Messages.getString("NDublinCore.citation"), Messages.getString("NDublinCore.citationDesc"), false, false);
        this.license = this.createDCAttribute(composite2, Messages.getString("NDublinCore.license"), Messages.getString("NDublinCore.licensDesc"), false, false);
        this.required = this.createDCAttribute(composite2, Messages.getString("NDublinCore.required"), Messages.getString("NDublinCore.requiredDesc"), false, false);
        this.spatial = this.createDCAttribute(composite2, Messages.getString("NDublinCore.spatial"), Messages.getString("NDublinCore.spatialDesc"), false, false);
        this.format = this.createDCAttribute(composite2, Messages.getString("NDublinCore.format"), Messages.getString("NDublinCore.formatDesc"), true, false);
        this.type = this.createDCAttribute(composite2, Messages.getString("NDublinCore.type"), Messages.getString("NDublinCore.typeDesc"), true, false);
        Label label = new Label(composite2, 0);
        label.setText(REQUIRED_FIELD_CHAR + Messages.getString("NDublinCore.requiredField"));
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        label.setLayoutData((Object)gridData2);
        this.initializeDCAttributes();
        this.setPageComplete(this.validateDublinCorePage());
        this.setControl((Control)composite2);
    }

    protected void initializeDCAttributes() {
        this.created.setText(DublinCoreImpl.createISO8601DateString((Date)Calendar.getInstance().getTime()));
        this.creator.setText(System.getProperty("user.name"));
    }

    private Text createDCAttribute(Composite composite, String string, String string2, boolean bl, boolean bl2) {
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(string) + ":" + (bl ? REQUIRED_FIELD_CHAR : ""));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite, 2048);
        text.setToolTipText(string2);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        text.setLayoutData((Object)gridData2);
        if (bl2) {
            text.addModifyListener(this.dcValidator);
        }
        return text;
    }

    protected boolean validateDublinCorePage() {
        boolean bl = true;
        this.setErrorMessage(null);
        if (this.title.getText() == null || this.title.getText().equals("")) {
            this.setErrorMessage(Messages.getString("NDublinCore.titleErr"));
            bl = false;
        }
        if (bl && this.created.getText() != null && !this.created.getText().equals("") && !DublinCorePage.isValidDateString(this.created.getText())) {
            this.setErrorMessage(Messages.getString("NDublinCore.createdErr"));
            bl = false;
        }
        if (bl && this.date.getText() != null && !this.date.getText().equals("") && !DublinCorePage.isValidDateString(this.date.getText())) {
            this.setErrorMessage(Messages.getString("NDublinCore.dateErr"));
            bl = false;
        }
        if (bl && this.valid.getText() != null && !this.valid.getText().equals("") && !DublinCorePage.isValidValidDateString(this.valid.getText())) {
            this.setErrorMessage(Messages.getString("NDublinCore.validErr"));
            bl = false;
        }
        return bl;
    }

    protected static boolean isValidValidDateString(String string) {
        return DublinCoreImpl.isValidStartDateValid((String)string) && DublinCoreImpl.isValidEndDateValid((String)string);
    }

    protected static boolean isValidDateString(String string) {
        boolean bl;
        block3: {
            bl = false;
            String string2 = string.trim();
            if (string2.length() == "yyyy-dd-mm".length()) break block3;
            return false;
        }
        try {
            DublinCoreImpl.createDateFromISO8601DateString((String)string);
            bl = true;
        }
        catch (ParseException parseException) {
            bl = false;
        }
        return bl;
    }

    public static boolean isEndBeforeStart(String string, String string2) {
        boolean bl = false;
        try {
            Date date = DublinCoreImpl.createDateFromISO8601DateString((String)string);
            Date date2 = DublinCoreImpl.createDateFromISO8601DateString((String)string2);
            bl = date2.before(date);
        }
        catch (ParseException parseException) {
            bl = true;
        }
        return bl;
    }

    public DublinCore createDublinCore() {
        DublinCore dublinCore = CommonFactory.eINSTANCE.createDublinCore();
        if (this.isSet(this.title.getText())) {
            dublinCore.setTitle(this.title.getText());
        }
        if (this.isSet(this.description.getText())) {
            dublinCore.setDescription(this.description.getText());
        }
        if (this.isSet(this.creator.getText())) {
            dublinCore.setCreator(this.creator.getText());
        }
        if (this.isSet(this.date.getText())) {
            dublinCore.setDate(this.date.getText());
        }
        if (this.isSet(this.format.getText())) {
            dublinCore.setFormat(this.format.getText());
        }
        if (this.isSet(this.publisher.getText())) {
            dublinCore.setPublisher(this.publisher.getText());
        }
        if (this.isSet(this.coverage.getText())) {
            dublinCore.setCoverage(this.coverage.getText());
        }
        if (this.isSet(this.contributor.getText())) {
            dublinCore.setContributor(this.contributor.getText());
        }
        if (this.isSet(this.relation.getText())) {
            dublinCore.setRelation(this.relation.getText());
        }
        if (this.isSet(this.rights.getText())) {
            dublinCore.setRights(this.rights.getText());
        }
        if (this.isSet(this.source.getText())) {
            dublinCore.setSource(this.source.getText());
        }
        if (this.isSet(this.subject.getText())) {
            dublinCore.setSubject(this.subject.getText());
        }
        if (this.isSet(this.type.getText())) {
            dublinCore.setType(this.type.getText());
        }
        if (this.isSet(this.language.getText())) {
            dublinCore.setBibliographicCitation(this.language.getText());
        }
        if (this.isSet(this.bibliographicCitation.getText())) {
            dublinCore.setBibliographicCitation(this.bibliographicCitation.getText());
        }
        if (this.isSet(this.created.getText())) {
            dublinCore.setCreated(this.created.getText());
        }
        if (this.isSet(this.license.getText())) {
            dublinCore.setLicense(this.license.getText());
        }
        if (this.isSet(this.required.getText())) {
            dublinCore.setRequired(this.required.getText());
        }
        if (this.isSet(this.spatial.getText())) {
            dublinCore.setSpatial(this.spatial.getText());
        }
        if (this.isSet(this.valid.getText())) {
            dublinCore.setValid(this.valid.getText());
        }
        return dublinCore;
    }

    private boolean isSet(String string) {
        return string != null && !string.equals("");
    }
}

