/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.experiment.ExperimentFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewExperimentWizard
extends NewIdentifiableWizard {
    protected String getWizardTitle() {
        return Messages.getString("NExperimentWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        NewExperimentPage newExperimentPage = new NewExperimentPage(Messages.getString("NExperimentWiz.page_title"));
        newExperimentPage.setTitle(Messages.getString("NExperimentWiz.page_title"));
        newExperimentPage.setDescription(Messages.getString("NExperimentWiz.page_description"));
        return newExperimentPage;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/experiment.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.EXPERIMENT_TYPE_URI.toString());
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Experiment experiment = ExperimentFactory.eINSTANCE.createExperiment();
        return experiment;
    }

    protected String getSerializationFolderName() {
        return "experiments";
    }

    protected String getSerializationFileNameExtension() {
        return "experiment";
    }

    protected static class NewExperimentPage
    extends NewIdentifiablePage {
        protected NewExperimentPage(String string) {
            super(string);
        }

        protected String getDCDescription() {
            return MessageFormat.format(Messages.getString("NExperimentWiz.DC_DESCRIPTION"), this.serializationFileNameField.getText());
        }
    }

    public static class NewExperimentWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewExperimentWizard newExperimentWizard = new NewExperimentWizard();
            newExperimentWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newExperimentWizard);
            wizardDialog.open();
            return null;
        }
    }
}

