/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.presentation.CoreEditorAdvisor;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewIdentifiablePage
extends WizardPage {
    protected Combo projectNamesCombo;
    protected Text serializationFileNameField;
    private Composite specificComposite;
    protected List<IProject> stemProjects = null;
    protected ModifyListener projectValidator = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            NewIdentifiablePage.this.setPageComplete(NewIdentifiablePage.this.validatePage());
        }
    };

    protected NewIdentifiablePage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 12;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite2.setLayout((Layout)gridLayout);
        this.createProjectComposite(composite2);
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)new GridData(768));
        Composite composite3 = this.createSerializationComposite(composite2);
        composite3.setLayoutData((Object)new GridData(768));
        this.specificComposite = this.createSpecificComposite(composite2);
        if (this.specificComposite != null) {
            GridData gridData2 = new GridData(768);
            gridData2.grabExcessHorizontalSpace = true;
            this.specificComposite.setLayoutData((Object)gridData2);
        }
        this.setPageComplete(this.validatePage());
        composite.pack();
        this.setControl((Control)composite2);
    }

    private void createProjectComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 12;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(String.valueOf(Messages.getString("NIdWiz.project")) + ":");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 1;
        gridData2.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData2);
        this.projectNamesCombo = new Combo(composite2, 2056);
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalSpan = 1;
        this.projectNamesCombo.setLayoutData((Object)gridData3);
        this.initializeProjectCombo(this.projectNamesCombo);
        this.projectNamesCombo.addModifyListener(this.projectValidator);
        Button button = new Button(composite2, 8);
        button.setText(Messages.getString("NIdWiz.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = CoreEditorAdvisor.openFilePathDialog(NewIdentifiablePage.this.getShell(), "*", 4096);
                if (string != null) {
                    NewIdentifiablePage.this.projectNamesCombo.setText(string);
                }
            }
        });
    }

    private Composite createSerializationComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 12;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(String.valueOf(Messages.getString("NIdWiz.name")) + ":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 16384;
        label.setLayoutData((Object)gridData);
        this.serializationFileNameField = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.serializationFileNameField.setLayoutData((Object)gridData);
        this.serializationFileNameField.addModifyListener(this.projectValidator);
        return composite2;
    }

    protected Composite createSpecificComposite(Composite composite) {
        return null;
    }

    public IProject getSelectedProject() {
        return this.stemProjects.get(this.projectNamesCombo.getSelectionIndex());
    }

    private void initializeProjectCombo(Combo combo) {
        IProject iProject = this.getWorkSpaceSelectedProject();
        int n = 0;
        int n2 = 0;
        for (IProject iProject2 : this.getSTEMProjects()) {
            if (iProject2.equals((Object)iProject)) {
                n = n2;
            }
            String string = iProject2.getName();
            combo.add(string);
            ++n2;
        }
        combo.setFocus();
        combo.select(n);
    }

    private IProject getWorkSpaceSelectedProject() {
        IProject iProject = null;
        ISelection iSelection = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            for (Object e : ((IStructuredSelection)iSelection).toList()) {
                if (e instanceof IProject) {
                    iProject = (IProject)e;
                    break;
                }
                if (e instanceof IResource) {
                    iProject = ((IResource)e).getProject();
                    break;
                }
                if (e instanceof Identifiable) {
                    Path path = new Path(((Identifiable)e).getURI().toPlatformString(true));
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getProject();
                    break;
                }
                if (!(e instanceof IdentifiableTreeNode)) continue;
                iProject = ((IdentifiableTreeNode)e).getProject();
                break;
            }
        }
        return iProject;
    }

    private List<IProject> getSTEMProjects() {
        this.stemProjects = Utility.getSTEMProjectsFromWorkspace();
        return this.stemProjects;
    }

    protected boolean validatePage() {
        boolean bl = true;
        this.setErrorMessage(null);
        if (this.getSTEMProjects().size() == 0) {
            this.setErrorMessage(Messages.getString("NIdWiz.noProjErr"));
            bl = false;
        }
        if (bl && this.serializationFileNameField.getText() == null || "".equals(this.serializationFileNameField.getText().trim())) {
            this.setErrorMessage(Messages.getString("NIdWiz.nameMissingErr"));
            bl = false;
        }
        if (bl && !this.serializationFileNameIsValid()) {
            this.setErrorMessage(Messages.getString("NIdWiz.nameErr"));
            bl = false;
        }
        return bl;
    }

    private boolean serializationFileNameIsValid() {
        String string = this.serializationFileNameField.getText();
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        return !string2.equals("") && !string2.contains(" ");
    }

    protected String getDCTitle() {
        return this.getDCDescription();
    }

    protected abstract String getDCDescription();

    protected String getDCValidDateRange() {
        return "";
    }
}

