/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.presentation.CoreEditorAdvisor;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class NewIdentifiableWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected NewIdentifiablePage newIdentifiablePage = null;
    protected DublinCorePage newDublinCorePage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.setWindowTitle(this.getWizardTitle());
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(false);
        this.newIdentifiablePage = this.createNewIdentifiablePage();
        if (this.newIdentifiablePage == null) {
            return;
        }
        this.newDublinCorePage = this.createDublinCorePage();
        if (this.newDublinCorePage == null) {
            return;
        }
        this.addPage((IWizardPage)this.newIdentifiablePage);
        this.addPage((IWizardPage)this.newDublinCorePage);
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = super.getNextPage(iWizardPage);
        if (iWizardPage2 instanceof DublinCorePage) {
            DublinCorePage dublinCorePage = (DublinCorePage)iWizardPage2;
            dublinCorePage.title.setText(this.newIdentifiablePage.getDCTitle());
            dublinCorePage.description.setText(this.newIdentifiablePage.getDCDescription());
            dublinCorePage.valid.setText(this.newIdentifiablePage.getDCValidDateRange());
        }
        return iWizardPage2;
    }

    public boolean performFinish() {
        try {
            final URI uRI = this.createSerializationURI();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) {
                    NewIdentifiableWizard.this.createIdentifiable((IProgressMonitor)(iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor), uRI);
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
            try {
                this.newIdentifiablePage.getSelectedProject().refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
            return CoreEditorAdvisor.openEditor(this.workbench, CommonPlugin.asLocalURI((URI)uRI));
        }
        catch (InvocationTargetException invocationTargetException) {
            Activator.logError("org.eclipse.stem.ui", invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            Activator.logInformation("org.eclipse.stem.ui", interruptedException);
        }
        return true;
    }

    void createIdentifiable(IProgressMonitor iProgressMonitor, URI uRI) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(Messages.getString("NIdWiz.creating"), 100);
        try {
            try {
                Identifiable identifiable = this.createIdentifiable();
                identifiable.setURI(uRI);
                assert (identifiable.sane());
                Utility.serializeIdentifiable((Identifiable)identifiable, (URI)uRI);
            }
            catch (IOException iOException) {
                Activator.logError(Messages.getString("NIdWiz.saveErr"), iOException);
                iProgressMonitor.done();
            }
            catch (Exception exception) {
                Activator.logError(Messages.getString("NIdWiz.saveErr"), exception);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private URI createSerializationURI() {
        StringBuilder stringBuilder = new StringBuilder(this.newIdentifiablePage.getSelectedProject().getName());
        stringBuilder.append("/");
        stringBuilder.append(this.getSerializationFolderName());
        stringBuilder.append("/");
        stringBuilder.append(this.getSerializationFileName());
        stringBuilder.append(".");
        stringBuilder.append(this.getSerializationFileNameExtension());
        return URI.createPlatformResourceURI((String)stringBuilder.toString(), (boolean)true);
    }

    private String getSerializationFileName() {
        return this.newIdentifiablePage.serializationFileNameField.getText();
    }

    protected abstract String getWizardTitle();

    protected abstract NewIdentifiablePage createNewIdentifiablePage();

    protected abstract DublinCorePage createDublinCorePage();

    protected abstract Identifiable createIdentifiable();

    protected abstract String getSerializationFolderName();

    protected abstract String getSerializationFileNameExtension();

    protected static abstract class NewIdentifiableWizardAction
    extends WorkbenchWindowActionDelegate {
        protected NewIdentifiableWizardAction() {
        }

        protected void run(NewIdentifiableWizard newIdentifiableWizard) {
            newIdentifiableWizard.init(this.getWindow().getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(this.getWindow().getShell(), (IWizard)newIdentifiableWizard);
            wizardDialog.open();
        }
    }
}

