/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.modifier.ModifierFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.newmodifierpage.NewModifierPageAdapter;
import org.eclipse.stem.ui.adapters.newmodifierpage.NewModifierPageAdapterFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.NewModifierPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewModifierWizard
extends NewIdentifiableWizard {
    private Identifiable identifiable;
    private NewModifierPage newModifierPage;

    protected String getWizardTitle() {
        return Messages.getString("NModifierWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        NewModifierPageAdapter newModifierPageAdapter = (NewModifierPageAdapter)NewModifierPageAdapterFactory.INSTANCE.adapt((Notifier)this.identifiable, NewModifierPageAdapter.class);
        if (newModifierPageAdapter != null) {
            newModifierPageAdapter.setTarget((Notifier)this.identifiable);
            this.newModifierPage = newModifierPageAdapter.createNewModifierPage();
        } else {
            Activator.logError("Internal Error: could not create NewModifierPage for \"" + this.identifiable.getClass().getName() + "\"", null);
            this.newModifierPage = new NewModifierPage(this.identifiable){

                protected Composite createSpecificComposite(Composite composite) {
                    return null;
                }
            };
        }
        return this.newModifierPage;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/modifier.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.MODIFIER_TYPE_URI.toString());
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Modifier modifier = ModifierFactory.eINSTANCE.createModifier();
        modifier.setDublinCore(this.newDublinCorePage.createDublinCore());
        if (this.identifiable instanceof Edge) {
            Edge edge = (Edge)this.identifiable;
            modifier.setTargetURI(edge.getLabel().getURI());
        } else {
            modifier.setTargetURI(this.identifiable.getURI());
        }
        modifier.getFeatureModifiers().addAll(this.newModifierPage.getFeatureModifiers());
        return modifier;
    }

    protected String getSerializationFolderName() {
        return "modifiers";
    }

    protected String getSerializationFileNameExtension() {
        return "modifier";
    }

    public final void setIdentifiable(Identifiable identifiable) {
        this.identifiable = identifiable;
    }

    public static class NewModifierWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            ISelection iSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
            if (iSelection instanceof StructuredSelection) {
                try {
                    Object object = ((StructuredSelection)iSelection).toArray()[0];
                    Identifiable identifiable = (Identifiable)Platform.getAdapterManager().getAdapter(object, Identifiable.class);
                    if (identifiable != null) {
                        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
                        NewModifierWizard newModifierWizard = new NewModifierWizard();
                        newModifierWizard.setIdentifiable(identifiable);
                        newModifierWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                        WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newModifierWizard);
                        wizardDialog.open();
                    } else {
                        Activator.logError("Internal error: attempting to create Modifier Wizard for \"" + object.getClass().getName() + "\"", null);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            return null;
        }
    }
}

