/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewSTEMProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String ID_STEM_PROJECT_WIZARD = "org.eclipse.stem.ui.wizards.newstemproject";
    public static final String GRAPHS_FOLDER_NAME = "graphs";
    public static final String RECORDED_SIMULATIONS_FOLDER_NAME = "Recorded Simulations";
    public static final String MODELS_FOLDER_NAME = "models";
    public static final String SCEANARIOS_FOLDER_NAME = "scenarios";
    public static final String DECORATORS_FOLDER_NAME = "decorators";
    public static final String SEQUENCERS_FOLDER_NAME = "sequencers";
    public static final String EXPERIMENTS_FOLDER_NAME = "experiments";
    public static final String MODIFIERS_FOLDER_NAME = "modifiers";
    public static final String TRIGGERS_FOLDER_NAME = "triggers";
    public static final String PREDICATES_FOLDER_NAME = "predicates";
    WizardNewProjectCreationPage newProjectPage = null;
    private final String[] defaultFolders = new String[]{"graphs", "models", "scenarios", "decorators", "sequencers", "experiments", "modifiers", "triggers", "predicates", "Recorded Simulations"};

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(Messages.getString("NSTEMProWiz.title"));
        this.newProjectPage = new WizardNewProjectCreationPage(Messages.getString("NSTEMProWiz.title"));
        this.newProjectPage.setTitle(Messages.getString("NSTEMProWiz.page_title"));
        this.newProjectPage.setDescription(Messages.getString("NSTEMProWiz.page_description"));
        this.addPage((IWizardPage)this.newProjectPage);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) {
                    NewSTEMProjectWizard.this.createProject((IProgressMonitor)(iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            Activator.logError(ID_STEM_PROJECT_WIZARD, invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            Activator.logInformation(ID_STEM_PROJECT_WIZARD, interruptedException);
        }
        return true;
    }

    void createProject(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(Messages.getString("NSTEMProWiz.title"), 1 + this.defaultFolders.length);
        try {
            try {
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                iProgressMonitor.subTask(Messages.getString("NSTEMProWiz.creating_project"));
                IProject iProject = iWorkspaceRoot.getProject(this.newProjectPage.getProjectName());
                IProjectDescription iProjectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(iProject.getName());
                if (!Platform.getLocation().equals((Object)this.newProjectPage.getLocationPath())) {
                    iProjectDescription.setLocation(this.newProjectPage.getLocationPath());
                }
                iProjectDescription.setNatureIds(new String[]{"org.eclipse.stem.stemnature"});
                iProject.create(iProjectDescription, iProgressMonitor);
                iProgressMonitor.worked(1);
                iProgressMonitor.subTask(Messages.getString("NSTEMProWiz.creating_directories"));
                iProject.open(iProgressMonitor);
                IPath iPath = iProject.getFullPath();
                String[] stringArray = this.defaultFolders;
                int n = this.defaultFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    IPath iPath2 = iPath.append(string);
                    IFolder iFolder = iWorkspaceRoot.getFolder(iPath2);
                    this.createFolder(iFolder, iProgressMonitor);
                    iProgressMonitor.worked(1);
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                Activator.logError(Messages.getString("NSTEMProWiz.Create_Problem"), coreException);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void createFolder(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFolder.exists()) {
            IContainer iContainer = iFolder.getParent();
            if (iContainer instanceof IFolder && !((IFolder)iContainer).exists()) {
                this.createFolder((IFolder)iContainer, iProgressMonitor);
            }
            iFolder.create(false, true, iProgressMonitor);
        }
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
    }

    public static class NewSTEMProjectWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewSTEMProjectWizard newSTEMProjectWizard = new NewSTEMProjectWizard();
            newSTEMProjectWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newSTEMProjectWizard);
            wizardDialog.open();
            return null;
        }
    }
}

