/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioFactory;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyComposite;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewScenarioWizard
extends NewIdentifiableWizard {
    protected String getWizardTitle() {
        return Messages.getString("NScenarioWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        return new NewScenarioPage();
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/scenario.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.SCENARIO_TYPE_URI.toString());
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Scenario scenario = ScenarioFactory.eINSTANCE.createScenario();
        scenario.setDublinCore(this.newDublinCorePage.createDublinCore());
        SolverPropertyComposite solverPropertyComposite = ((NewScenarioPage)this.newIdentifiablePage).solverPC;
        Solver solver = solverPropertyComposite.createSolver();
        scenario.setSolver(solver);
        return scenario;
    }

    protected String getSerializationFolderName() {
        return "scenarios";
    }

    protected String getSerializationFileNameExtension() {
        return "scenario";
    }

    protected static class NewScenarioPage
    extends NewIdentifiablePage {
        private Solver[] solvers = null;
        SolverPropertyComposite solverPC;
        private Combo combo;

        protected NewScenarioPage() {
            super(Messages.getString("NScenarioWiz.page_title"));
            this.setTitle(Messages.getString("NScenarioWiz.page_title"));
            this.setDescription(Messages.getString("NScenarioWiz.page_description"));
        }

        protected Composite createSpecificComposite(Composite composite) {
            Solver[] solverArray = this.getSolvers();
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 1;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = 100;
            label.setLayoutData((Object)gridData);
            label.setText(Messages.getString("NScenarioWiz.solver"));
            this.combo = new Combo(composite2, 8);
            this.combo.setTextLimit(30);
            GridData gridData2 = new GridData(4, 0x1000000, true, false);
            gridData2.widthHint = 303;
            this.combo.setLayoutData((Object)gridData2);
            this.combo.setToolTipText(Messages.getString("NScenarioWiz.solver"));
            this.combo.setItems(this.getSolverNames(solverArray));
            final NewScenarioPage newScenarioPage = this;
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    newScenarioPage.displaySolver(NewScenarioPage.this.getSolvers()[NewScenarioPage.this.combo.getSelectionIndex()]);
                }
            });
            this.combo.select(0);
            this.combo.addModifyListener(this.projectValidator);
            this.solverPC = new SolverPropertyComposite(composite2, 1, solverArray, this.projectValidator);
            return composite2;
        }

        protected String getDCDescription() {
            return MessageFormat.format(Messages.getString("NScenarioWiz.DC_DESCRIPTION"), this.serializationFileNameField.getText());
        }

        private Solver[] getSolvers() {
            Preferences preferences = Activator.getDefault().getPluginPreferences();
            String string = preferences.getString("defaultSolver");
            if (this.solvers == null) {
                IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.stem.core.solver");
                ArrayList<Solver> arrayList = new ArrayList<Solver>();
                this.solvers = new Solver[iConfigurationElementArray.length];
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                    if (iConfigurationElement.getName().equals("classdef")) {
                        try {
                            Solver solver = (Solver)iConfigurationElement.createExecutableExtension("class");
                            if (solver.getClass().getName().equals(string) && n > 0) {
                                Solver solver2 = (Solver)arrayList.get(0);
                                arrayList.set(0, solver);
                                arrayList.add(solver2);
                            } else {
                                arrayList.add(solver);
                            }
                        }
                        catch (CoreException coreException) {
                            Activator.logError("Can't create solver", coreException);
                        }
                    }
                    ++n;
                }
                this.solvers = arrayList.toArray(new Solver[0]);
            }
            return this.solvers;
        }

        private String[] getSolverNames(Solver[] solverArray) {
            Preferences preferences = Activator.getDefault().getPluginPreferences();
            String string = preferences.getString("defaultSolver");
            String[] stringArray = new String[solverArray.length];
            int n = 0;
            while (n < solverArray.length) {
                String string2 = solverArray[n].getDublinCore().getTitle();
                if (string2 == null || string2.equals("")) {
                    string2 = solverArray[n].getClass().getSimpleName();
                }
                if (solverArray[n].getClass().getName().equals(string) && n > 0) {
                    String string3 = stringArray[0];
                    stringArray[0] = string2;
                    stringArray[n] = string3;
                } else {
                    stringArray[n] = string2;
                }
                ++n;
            }
            return stringArray;
        }

        void displaySolver(Solver solver) {
            this.solverPC.displaySolver(solver);
        }
    }

    public static class NewScenarioWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewScenarioWizard newScenarioWizard = new NewScenarioWizard();
            newScenarioWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newScenarioWizard);
            wizardDialog.open();
            return null;
        }
    }
}

