/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.RealTimeSequencer;
import org.eclipse.stem.core.sequencer.SequencerFactory;
import org.eclipse.stem.core.sequencer.SequentialSequencer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewSequencerWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class NewSequentialSequencerWizard
extends NewSequencerWizard {

    public static class NewFixedSequentialSequencerWizard
    extends NewSequentialSequencerWizard {
        protected String getWizardTitle() {
            return Messages.getString("NSeqSequencerWiz.wizard_title");
        }

        protected NewIdentifiablePage createNewIdentifiablePage() {
            return new FixedSequentialSequencerPage();
        }

        protected Identifiable createIdentifiable() {
            SequentialSequencer sequentialSequencer = SequencerFactory.eINSTANCE.createSequentialSequencer();
            sequentialSequencer.setDublinCore(this.newDublinCorePage.createDublinCore());
            Date date = ((FixedSequentialSequencerPage)this.newIdentifiablePage).getStartDate();
            Date date2 = ((FixedSequentialSequencerPage)this.newIdentifiablePage).getEndDate();
            try {
                sequentialSequencer.setTimeIncrement(((FixedSequentialSequencerPage)this.newIdentifiablePage).getCycleDuration());
                STEMTime sTEMTime = ModelFactory.eINSTANCE.createSTEMTime();
                sTEMTime.setTime(date);
                sequentialSequencer.setStartTime(sTEMTime);
                if (date2 != null) {
                    STEMTime sTEMTime2 = ModelFactory.eINSTANCE.createSTEMTime();
                    sTEMTime2.setTime(date2);
                    sequentialSequencer.setEndTime(sTEMTime2);
                }
            }
            catch (Exception exception) {
                Activator.logError("NewSequentialSequencer", exception);
            }
            return sequentialSequencer;
        }

        protected static class FixedSequentialSequencerPage
        extends SequentialSequencerPage {
            private static final boolean END_DATE_INITIALLY_ENABLED = false;
            Button endDateEnabledButton;
            private DateTime startDate;
            DateTime endDate;

            protected FixedSequentialSequencerPage() {
            }

            public Date getStartDate() {
                Calendar calendar = Calendar.getInstance();
                calendar.set(this.startDate.getYear(), this.startDate.getMonth(), this.startDate.getDay(), 12, 0, 0);
                return calendar.getTime();
            }

            public Date getEndDate() {
                Date date = null;
                if (this.endDateEnabledButton.getSelection()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(this.endDate.getYear(), this.endDate.getMonth(), this.endDate.getDay(), 11, 59, 59);
                    date = calendar.getTime();
                }
                return date;
            }

            protected boolean validatePage() {
                boolean bl = super.validatePage();
                if (bl && this.endDateEnabledButton.getSelection()) {
                    if (this.endDate.getYear() < this.startDate.getYear()) {
                        bl = false;
                    } else if (this.endDate.getYear() == this.startDate.getYear() && this.endDate.getMonth() < this.startDate.getMonth()) {
                        bl = false;
                    } else if (this.endDate.getYear() == this.startDate.getYear() && this.endDate.getMonth() == this.startDate.getMonth() && this.endDate.getDay() <= this.startDate.getDay()) {
                        bl = false;
                    }
                    if (!bl) {
                        this.setErrorMessage(Messages.getString("NSeqSequencerWiz.endBeforeErr"));
                    }
                }
                return bl;
            }

            protected Composite createSequentialSequencerSpecificComposite(Composite composite) {
                Composite composite2 = new Composite(composite, 0);
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 2;
                gridLayout.verticalSpacing = 12;
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                composite2.setLayout((Layout)gridLayout);
                GridData gridData = new GridData();
                gridData.horizontalAlignment = 4;
                composite2.setLayoutData((Object)gridData);
                new Label(composite2, 0);
                Label label = new Label(composite2, 0x1000000);
                label.setLayoutData((Object)new GridData());
                label.setText(String.valueOf(Messages.getString("NSeqSequencerWiz.startTime")) + ":");
                new Label(composite2, 0);
                this.startDate = new DateTime(composite2, 1024);
                this.startDate.setLayoutData((Object)new GridData());
                this.startDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        FixedSequentialSequencerPage.this.setPageComplete(FixedSequentialSequencerPage.this.validatePage());
                    }
                });
                new Label(composite2, 0);
                this.endDateEnabledButton = new Button(composite2, 32);
                this.endDateEnabledButton.setText(String.valueOf(Messages.getString("NSeqSequencerWiz.endTime")) + ":");
                this.endDateEnabledButton.setLayoutData((Object)new GridData());
                this.endDateEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        FixedSequentialSequencerPage.this.endDate.setEnabled(FixedSequentialSequencerPage.this.endDateEnabledButton.getSelection());
                        FixedSequentialSequencerPage.this.setPageComplete(FixedSequentialSequencerPage.this.validatePage());
                    }
                });
                new Label(composite2, 0);
                this.endDate = new DateTime(composite2, 1024);
                this.endDate.setEnabled(false);
                this.endDate.setLayoutData((Object)new GridData());
                this.endDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        FixedSequentialSequencerPage.this.setPageComplete(FixedSequentialSequencerPage.this.validatePage());
                    }
                });
                return composite2;
            }

            protected String getDCTitle() {
                String string = null;
                String string2 = DublinCoreImpl.createISO8601DateString((Date)this.getStartDate());
                Date date = this.getEndDate();
                String string3 = date != null ? DublinCoreImpl.createISO8601DateString((Date)date) : null;
                string = string3 != null && !string3.equals("") ? MessageFormat.format(Messages.getString("NSeqSequencerWiz.DC_TITLE1"), string2, string3, this.getCycleDurationDescription()) : MessageFormat.format(Messages.getString("NSeqSequencerWiz.DC_TITLE2"), string2, this.getCycleDurationDescription());
                return string;
            }

            protected String getDCDescription() {
                String string = null;
                String string2 = DublinCoreImpl.createISO8601DateString((Date)this.getStartDate());
                Date date = this.getEndDate();
                String string3 = date != null ? DublinCoreImpl.createISO8601DateString((Date)date) : null;
                string = string3 != null && !string3.equals("") ? MessageFormat.format(Messages.getString("NSeqSequencerWiz.DC_DESCRIPTION1"), string2, string3, this.getCycleDurationDescription()) : MessageFormat.format(Messages.getString("NSeqSequencerWiz.DC_DESCRIPTION2"), string2, this.getCycleDurationDescription());
                return string;
            }

            protected String getDCValidDateRange() {
                StringBuilder stringBuilder = new StringBuilder("start=");
                stringBuilder.append(DublinCoreImpl.createISO8601DateString((Date)this.getStartDate()));
                stringBuilder.append(";");
                Date date = this.getEndDate();
                if (date != null) {
                    stringBuilder.append(" end=");
                    stringBuilder.append(DublinCoreImpl.createISO8601DateString((Date)date));
                    stringBuilder.append(";");
                }
                return stringBuilder.toString();
            }
        }

        public static class NewSequentialSequencerWizardCommandHandler
        extends AbstractHandler
        implements IHandler {
            public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
                IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
                NewFixedSequentialSequencerWizard newFixedSequentialSequencerWizard = new NewFixedSequentialSequencerWizard();
                newFixedSequentialSequencerWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newFixedSequentialSequencerWizard);
                wizardDialog.open();
                return null;
            }
        }
    }

    public static class NewRealTimeSequencerWizard
    extends NewSequentialSequencerWizard {
        protected String getWizardTitle() {
            return Messages.getString("NRTSequencerWiz.wizard_title");
        }

        protected NewIdentifiablePage createNewIdentifiablePage() {
            return new RealTimeSequentialSequencerPage();
        }

        protected Identifiable createIdentifiable() {
            RealTimeSequencer realTimeSequencer = SequencerFactory.eINSTANCE.createRealTimeSequencer();
            realTimeSequencer.setDublinCore(this.newDublinCorePage.createDublinCore());
            realTimeSequencer.setTimeIncrement(((RealTimeSequentialSequencerPage)this.newIdentifiablePage).getCycleDuration());
            return realTimeSequencer;
        }

        public static class NewRealTimeSequencerWizardCommandHandler
        extends AbstractHandler
        implements IHandler {
            public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
                IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
                NewRealTimeSequencerWizard newRealTimeSequencerWizard = new NewRealTimeSequencerWizard();
                newRealTimeSequencerWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newRealTimeSequencerWizard);
                wizardDialog.open();
                return null;
            }
        }

        protected static class RealTimeSequentialSequencerPage
        extends SequentialSequencerPage {
            protected RealTimeSequentialSequencerPage() {
            }

            protected Composite createSequentialSequencerSpecificComposite(Composite composite) {
                Composite composite2 = new Composite(composite, 0);
                return composite2;
            }

            protected String getDCTitle() {
                return MessageFormat.format(Messages.getString("NSRTSequencerWiz.DC_TITLE"), this.getCycleDurationDescription());
            }

            protected String getDCDescription() {
                return MessageFormat.format(Messages.getString("NSRTSequencerWiz.DC_DESCRIPTION1"), this.getCycleDurationDescription());
            }

            protected String getDCValidDateRange() {
                return "";
            }
        }
    }

    protected static abstract class SequentialSequencerPage
    extends NewSequencerWizard.SequencerPage {
        protected static final String DEFAULT_CYCLE_PERIOD_TIME_VALUE = "1";
        private static final STEMTime.Units DEFAULT_CYCLE_PERIOD_TIME_UNIT = STEMTime.Units.DAY;
        private static final String[] cyclePeriodTimeUnitStringsPlural = new String[]{Messages.getString("NSequencerWiz.milliseconds"), Messages.getString("NSequencerWiz.seconds"), Messages.getString("NSequencerWiz.minutes"), Messages.getString("NSequencerWiz.hours"), Messages.getString("NSequencerWiz.days")};
        private static final String[] cyclePeriodTimeUnitStringsSingular = new String[]{Messages.getString("NSequencerWiz.millisecond"), Messages.getString("NSequencerWiz.second"), Messages.getString("NSequencerWiz.minute"), Messages.getString("NSequencerWiz.hour"), Messages.getString("NSequencerWiz.day")};
        private Text cyclePeriodTimeValueField;
        private Combo cyclePeriodTimeComboBox;

        public SequentialSequencerPage() {
            super(Messages.getString("NSeqSequencerWiz.page_title"));
            this.setTitle(Messages.getString("NSeqSequencerWiz.page_title"));
            this.setDescription(Messages.getString("NSeqSequencerWiz.page_description"));
        }

        protected Composite createSpecificComposite(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.verticalSpacing = 12;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(String.valueOf(Messages.getString("NSequencerWiz.cycleTime")) + ":");
            GridData gridData2 = new GridData();
            gridData2.horizontalSpan = 1;
            gridData2.horizontalAlignment = 16384;
            label.setLayoutData((Object)gridData2);
            this.cyclePeriodTimeValueField = new Text(composite2, 2048);
            this.cyclePeriodTimeValueField.setText(DEFAULT_CYCLE_PERIOD_TIME_VALUE);
            GridData gridData3 = new GridData();
            gridData3.horizontalAlignment = 4;
            gridData3.grabExcessHorizontalSpace = true;
            gridData3.horizontalSpan = 1;
            this.cyclePeriodTimeValueField.setLayoutData((Object)gridData3);
            this.cyclePeriodTimeValueField.addModifyListener(this.projectValidator);
            this.cyclePeriodTimeComboBox = new Combo(composite2, 12);
            this.cyclePeriodTimeComboBox.setItems(cyclePeriodTimeUnitStringsPlural);
            this.cyclePeriodTimeComboBox.select(DEFAULT_CYCLE_PERIOD_TIME_UNIT.ordinal());
            GridData gridData4 = new GridData();
            gridData4.horizontalAlignment = 131072;
            gridData4.horizontalSpan = 1;
            this.cyclePeriodTimeComboBox.setLayoutData((Object)gridData4);
            Composite composite3 = this.createSequentialSequencerSpecificComposite(composite2);
            GridData gridData5 = new GridData();
            gridData5.horizontalAlignment = 4;
            gridData5.grabExcessHorizontalSpace = true;
            gridData5.horizontalSpan = 2;
            composite3.setLayoutData((Object)gridData5);
            return composite2;
        }

        protected boolean validatePage() {
            boolean bl = super.validatePage();
            if (bl) {
                try {
                    int n = Integer.parseInt(this.cyclePeriodTimeValueField.getText());
                    if (n < 1) {
                        bl = false;
                        this.setErrorMessage(Messages.getString("NSeqSequencerWiz.cycleTimeErr"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                    this.setErrorMessage(Messages.getString("NSeqSequencerWiz.cycleTimeFormatErr"));
                }
            }
            return bl;
        }

        protected long getCycleDuration() {
            long l = 1L;
            String string = this.cyclePeriodTimeValueField.getText();
            long l2 = STEMTime.Units.values()[this.cyclePeriodTimeComboBox.getSelectionIndex()].getMilliseconds();
            try {
                int n = Integer.parseInt(string);
                l = (long)n * l2;
            }
            catch (Exception exception) {
                Activator.logError("NewRealTimeSequentialSequencer", exception);
            }
            return l;
        }

        protected String getCycleDurationDescription() {
            String string = this.cyclePeriodTimeValueField.getText();
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" ");
            stringBuilder.append(DEFAULT_CYCLE_PERIOD_TIME_VALUE.equals(string) ? cyclePeriodTimeUnitStringsSingular[this.cyclePeriodTimeComboBox.getSelectionIndex()] : cyclePeriodTimeUnitStringsPlural[this.cyclePeriodTimeComboBox.getSelectionIndex()]);
            return stringBuilder.toString();
        }

        protected abstract Composite createSequentialSequencerSpecificComposite(Composite var1);
    }
}

