/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.core.trigger.TriggerFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewTriggerWizard
extends NewIdentifiableWizard {
    protected String getWizardTitle() {
        return Messages.getString("NTriggerWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        return new NewTriggerPage();
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/trigger.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.TRIGGER_TYPE_URI.toString());
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Trigger trigger = TriggerFactory.eINSTANCE.createTrigger();
        trigger.setDublinCore(this.newDublinCorePage.createDublinCore());
        return trigger;
    }

    protected String getSerializationFolderName() {
        return "triggers";
    }

    protected String getSerializationFileNameExtension() {
        return "trigger";
    }

    protected static class NewTriggerPage
    extends NewIdentifiablePage {
        protected NewTriggerPage() {
            super(Messages.getString("NTriggerWiz.page_title"));
            this.setTitle(Messages.getString("NTriggerWiz.page_title"));
            this.setDescription(Messages.getString("NTriggerWiz.page_description"));
        }

        protected String getDCDescription() {
            return MessageFormat.format(Messages.getString("NTriggerWiz.DC_DESCRIPTION"), this.serializationFileNameField.getText());
        }
    }

    public static class NewTriggerWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewTriggerWizard newTriggerWizard = new NewTriggerWizard();
            newTriggerWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newTriggerWizard);
            wizardDialog.open();
            return null;
        }
    }
}

