/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioFactory;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.sequencer.SequencerFactory;
import org.eclipse.stem.core.sequencer.SequentialSequencer;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.specifications.IdentifiableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiseaseModelScenarioSpecification
extends IdentifiableSpecification
implements Comparable<DiseaseModelScenarioSpecification> {
    private static final int INFECTIOUS_COUNT = 10000;
    private final ModelPackage modelPackage = ModelPackage.eINSTANCE;
    private final StandardPackage standardPackage = StandardPackage.eINSTANCE;
    private final DublinCore diseaseModelModelDC;
    private final ISOKey isoKey;
    private final AdminLevelSet adminLevelSet;
    private Model diseaseModelModel;
    private DiseaseModel diseaseModel;
    private Sequencer sequencer;
    private SIInfector infector;
    private String infectedRegionName;

    static {
        String string = System.getProperty("user.dir");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        String string3 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.diseasemodels.models" + File.separator;
        String string4 = String.valueOf(string2) + File.separator + "org.eclipse.stem.diseases" + File.separator;
        String string5 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.geography.population.human" + File.separator;
        String string6 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.geography.population.human.models" + File.separator;
        Map map = EcorePlugin.getPlatformResourceMap();
        map.put("org.eclipse.stem.data.diseasemodels.models", URI.createFileURI((String)string3));
        map.put("org.eclipse.stem.diseases", URI.createFileURI((String)string4));
        map.put("org.eclipse.stem.data.geography.population.human", URI.createFileURI((String)string5));
        map.put("org.eclipse.stem.data.geography.population.human.models", URI.createFileURI((String)string6));
    }

    public DiseaseModelScenarioSpecification(ISOKey iSOKey, AdminLevelSet adminLevelSet, DublinCore dublinCore) {
        this.diseaseModelModelDC = dublinCore;
        this.isoKey = iSOKey;
        this.adminLevelSet = adminLevelSet;
        this.getDublinCore().setFormat("http:///org/eclipse/stem/core/scenario.ecore");
    }

    protected Scenario createIdentifiableInstance() {
        Scenario scenario = ScenarioFactory.eINSTANCE.createScenario();
        this.diseaseModelModel = (Model)Utility.getIdentifiable((URI)DiseaseModelScenarioSpecification.getIdentifiableProjectURI((DublinCore)this.diseaseModelModelDC));
        scenario.setModel(this.diseaseModelModel);
        this.diseaseModel = this.extractDiseaseModel(this.diseaseModelModel);
        this.sequencer = this.createSequencer();
        scenario.setSequencer(this.sequencer);
        this.infector = this.createInfector(this.diseaseModelModel);
        scenario.getScenarioDecorators().add((Object)this.infector);
        return scenario;
    }

    private DiseaseModel extractDiseaseModel(Model model) {
        DiseaseModel diseaseModel = null;
        for (NodeDecorator nodeDecorator : model.getNodeDecorators()) {
            if (!nodeDecorator.eIsProxy()) continue;
            diseaseModel = (DiseaseModel)Utility.getIdentifiable((URI)URI.createURI((String)IdentifiableSpecification.convertToProjectURI((String)((InternalEObject)nodeDecorator).eProxyURI().toString())));
            break;
        }
        return diseaseModel;
    }

    protected String getRelativeSerializationPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("country");
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.isoKey.toString());
        return stringBuilder.toString();
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevelSet.toString());
        stringBuilder.append("_disease_");
        if (this.diseaseModel != null) {
            stringBuilder.append(this.diseaseModel.getDiseaseName().trim().replace(" ", "_"));
        }
        return stringBuilder.toString();
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.diseasemodels.scenarios";
    }

    protected String getTitleDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append(" ");
        stringBuilder.append(this.adminLevelSet.getNumAdminLevels() > 1 ? " (Levels: " : " (Level: ");
        stringBuilder.append(this.adminLevelSet.toString(","));
        stringBuilder.append(") ");
        stringBuilder.append(this.diseaseModel.getDiseaseName());
        stringBuilder.append(", ");
        stringBuilder.append(this.infector.getInfectiousCount());
        stringBuilder.append(" infections in ");
        stringBuilder.append(this.infectedRegionName);
        return stringBuilder.toString();
    }

    private Sequencer createSequencer() {
        SequentialSequencer sequentialSequencer = SequencerFactory.eINSTANCE.createSequentialSequencer();
        STEMTime sTEMTime = ModelFactory.eINSTANCE.createSTEMTime();
        sTEMTime.setTime((java.util.Date)Date.valueOf("2000-01-01"));
        sequentialSequencer.setStartTime(sTEMTime);
        sequentialSequencer.setCycle((int)STEMTime.Units.DAY.getMilliseconds());
        return sequentialSequencer;
    }

    private SIInfector createInfector(Model model) {
        SIInfector sIInfector = null;
        for (Model model2 : model.getModels()) {
            String string;
            Model model3;
            if (!model2.eIsProxy() || !(model3 = (Model)Utility.getIdentifiable((URI)URI.createURI((String)IdentifiableSpecification.convertToProjectURI((String)((InternalEObject)model2).eProxyURI().toString())))).getURI().toString().contains("population")) continue;
            Graph graph = (Graph)model3.getGraphs().get(0);
            Graph graph2 = (Graph)Utility.getIdentifiable((URI)URI.createURI((String)IdentifiableSpecification.convertToProjectURI((String)((InternalEObject)graph).eProxyURI().toString())));
            EMap eMap = graph2.getNodeLabels();
            NodeLabel nodeLabel = (NodeLabel)eMap.values().toArray()[0];
            URI uRI = nodeLabel.getURIOfIdentifiableToBeLabeled();
            this.infectedRegionName = string = uRI.lastSegment();
            sIInfector = StandardFactory.eINSTANCE.createSIInfector();
            sIInfector.setTargetURI(uRI);
            sIInfector.setDiseaseName(this.diseaseModel.getDiseaseName());
            sIInfector.setPopulationIdentifier(this.diseaseModel.getPopulationIdentifier());
            sIInfector.setInfectiousCount(10000.0);
            sIInfector.getDublinCore().setTitle("Infect 10000 " + this.diseaseModel.getPopulationIdentifier() + " in " + this.infectedRegionName);
            break;
        }
        return sIInfector;
    }

    public void serialize(String string) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getIdentifiable());
        arrayList.add(this.sequencer);
        if (this.infector != null) {
            arrayList.add(this.infector);
        }
        Utility.serializeIdentifiables(arrayList, (URI)converter.normalize(URI.createFileURI((String)(String.valueOf(string) + File.separator + this.getRelativeSerializationPathAndFileName()))));
    }

    @Override
    public int compareTo(DiseaseModelScenarioSpecification diseaseModelScenarioSpecification) {
        return 0;
    }

    protected String getSerializationFileNameExtension() {
        return "scenario";
    }
}

