/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.diseasemodels.scenarios;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.internal.data.ModelGenerator;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;
import org.eclipse.stem.internal.data.generatedplugin.Extension;
import org.eclipse.stem.internal.data.generatedplugin.GeneratedpluginFactory;
import org.eclipse.stem.internal.data.generatedplugin.Plugin;
import org.eclipse.stem.internal.data.generatedplugin.StemCategory;
import org.eclipse.stem.internal.data.geography.models.GeographyModelGenerator;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.DiseaseModelScenarioSpecification;
import org.eclipse.stem.internal.data.specifications.IdentifiableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiseaseModelScenarioGenerator
extends GeographyModelGenerator {
    private final ModelPackage modelPackage = ModelPackage.eINSTANCE;
    private final StandardPackage standardPackage = StandardPackage.eINSTANCE;
    public static final String ID_SCENARIO_GEOGRAPHY_CATEGORY = "org.eclipse.stem.core.scenario.geography";
    public static final String ID_SCENARIO_GEOGRAPHY_POLITICAL_CATEGORY = "org.eclipse.stem.core.scenario.geography.political";
    public static final String ID_SCENARIO_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY = "org.eclipse.stem.core.scenario.geography.political.countries";

    static {
        String string = System.getProperty("user.dir");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        String string3 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.diseasemodels.models" + File.separator;
        String string4 = String.valueOf(string2) + File.separator + "org.eclipse.stem.diseases" + File.separator;
        Map map = EcorePlugin.getPlatformResourceMap();
        map.put("org.eclipse.stem.data.diseasemodels.models", URI.createFileURI((String)string3));
        map.put("org.eclipse.stem.diseases", URI.createFileURI((String)string4));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Missing specification of the plugin file");
        } else {
            Plugin plugin22;
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = String.valueOf(string) + File.separator + "resources" + File.separator + "data";
            File file = new File(".." + File.separator + string2 + File.separator + "plugin.xml");
            URI uRI = URI.createFileURI((String)file.getAbsolutePath());
            DiseaseModelScenarioGenerator diseaseModelScenarioGenerator = new DiseaseModelScenarioGenerator();
            Map<ISOKey, List<DiseaseModelScenarioSpecification>> map = diseaseModelScenarioGenerator.processFiles2(uRI);
            for (Plugin plugin22 : DiseaseModelScenarioGenerator.sortISOKeys(map)) {
                for (IdentifiableSpecification identifiableSpecification2 : map.get(plugin22)) {
                    try {
                        identifiableSpecification2.serialize(string3);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            plugin22 = GeneratedpluginFactory.eINSTANCE.createPlugin();
            Extension extension = GeneratedpluginFactory.eINSTANCE.createExtension();
            extension.setPoint("org.eclipse.stem.core.scenario");
            DiseaseModelScenarioGenerator.addCatagoriesToExtension(extension);
            plugin22.getExtensionelement().add((Object)extension);
            for (ISOKey iSOKey : DiseaseModelScenarioGenerator.sortISOKeys(map)) {
                StemCategory stemCategory = GeneratedpluginFactory.eINSTANCE.createStemCategory();
                String string4 = "org.eclipse.stem.core.scenario.geography.political.countries." + iSOKey.toString().toLowerCase();
                stemCategory.setId(string4);
                stemCategory.setName(iSOKey.toString());
                stemCategory.setParentId(ID_SCENARIO_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY);
                extension.getCategories().add((Object)stemCategory);
                for (IdentifiableSpecification identifiableSpecification : map.get(iSOKey)) {
                    DublinCore dublinCore = GeneratedpluginFactory.eINSTANCE.createDublinCore();
                    dublinCore.setCategoryId(string4);
                    extension.getDublinCores().add((Object)DiseaseModelScenarioGenerator.populateGeneratedDC((DublinCore)dublinCore, (org.eclipse.stem.core.common.DublinCore)identifiableSpecification.getDublinCore()));
                }
            }
            URI uRI2 = URI.createFileURI((String)(String.valueOf(string) + File.separator + "plugin.xml"));
            ModelGenerator.writePluginxml((Plugin)plugin22, (URI)uRI2);
            DiseaseModelScenarioGenerator.createPluginPropertties((String)string);
        }
    }

    private Map<ISOKey, List<DiseaseModelScenarioSpecification>> processFiles2(URI uRI) {
        HashMap<ISOKey, List<DiseaseModelScenarioSpecification>> hashMap = new HashMap<ISOKey, List<DiseaseModelScenarioSpecification>>();
        Plugin plugin = this.getPluginxml(uRI);
        for (Extension extension : plugin.getExtensionelement()) {
            for (DublinCore dublinCore : extension.getDublinCores()) {
                Map map = CountryGraphPropertyFileSpecification.parseDublinCoreCoverageString((String)dublinCore.getCoverage());
                AdminLevelSet adminLevelSet = (AdminLevelSet)map.values().toArray()[0];
                ISOKey iSOKey = (ISOKey)map.keySet().toArray()[0];
                ArrayList<DiseaseModelScenarioSpecification> arrayList = (ArrayList<DiseaseModelScenarioSpecification>)hashMap.get(iSOKey);
                if (arrayList == null) {
                    arrayList = new ArrayList<DiseaseModelScenarioSpecification>();
                    hashMap.put(iSOKey, arrayList);
                }
                arrayList.add(new DiseaseModelScenarioSpecification(iSOKey, adminLevelSet, dublinCore));
            }
        }
        return hashMap;
    }

    private static void addCatagoriesToExtension(Extension extension) {
        StemCategory stemCategory = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory.setId("org.eclipse.stem.core.scenario");
        stemCategory.setName("%_UI_Standard_Scenario_category");
        stemCategory.setParentId("/");
        extension.getCategories().add((Object)stemCategory);
        StemCategory stemCategory2 = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory2.setId(ID_SCENARIO_GEOGRAPHY_CATEGORY);
        stemCategory2.setName("%_UI_Geography_category");
        stemCategory2.setParentId("org.eclipse.stem.core.scenario");
        extension.getCategories().add((Object)stemCategory2);
        StemCategory stemCategory3 = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory3.setId(ID_SCENARIO_GEOGRAPHY_POLITICAL_CATEGORY);
        stemCategory3.setName("%_UI_Poltical_category");
        stemCategory3.setParentId(ID_SCENARIO_GEOGRAPHY_CATEGORY);
        extension.getCategories().add((Object)stemCategory3);
        StemCategory stemCategory4 = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory4.setId(ID_SCENARIO_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY);
        stemCategory4.setName("%_UI_Countries_category");
        stemCategory4.setParentId(ID_SCENARIO_GEOGRAPHY_POLITICAL_CATEGORY);
        extension.getCategories().add((Object)stemCategory4);
    }
}

