/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.definitions.labels.TransportMode;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.diseasemodels.standard.AggregatingDiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.SILabel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.AggregatingSIDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelStateImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingDiseaseModelStateImpl
extends DiseaseModelStateImpl
implements AggregatingDiseaseModelState {
    protected List<TransportMode> transportModes = null;
    protected Map<TransportMode, List<Edge>> childTransportEdges = null;
    protected Map<TransportMode, List<Edge>> parentPeerTransportEdges = null;
    protected EList<SILabel> childrensLabels;

    protected AggregatingDiseaseModelStateImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.AGGREGATING_DISEASE_MODEL_STATE;
    }

    @Override
    public EList<SILabel> getChildrensLabels() {
        if (this.childrensLabels == null) {
            this.childrensLabels = new EObjectResolvingEList(SILabel.class, (InternalEObject)this, 1);
        }
        return this.childrensLabels;
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 1: {
                return this.getChildrensLabels();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 1: {
                this.getChildrensLabels().clear();
                this.getChildrensLabels().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 1: {
                this.getChildrensLabels().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 1: {
                return this.childrensLabels != null && !this.childrensLabels.isEmpty();
            }
        }
        return super.eIsSet(n);
    }

    public List<TransportMode> getTransportModes() {
        if (this.transportModes == null) {
            this.initializeTransportCollections();
        }
        return this.transportModes;
    }

    public Map<TransportMode, List<Edge>> getChildTransportEdges() {
        if (this.childTransportEdges == null) {
            this.initializeTransportCollections();
        }
        return this.childTransportEdges;
    }

    public Map<TransportMode, List<Edge>> getParentPeerTransportEdges() {
        if (this.parentPeerTransportEdges == null) {
            this.initializeTransportCollections();
        }
        return this.parentPeerTransportEdges;
    }

    protected void initializeTransportCollections() {
        Edge edge2;
        this.transportModes = new ArrayList<TransportMode>();
        this.childTransportEdges = new HashMap<TransportMode, List<Edge>>();
        this.parentPeerTransportEdges = new HashMap<TransportMode, List<Edge>>();
        Node node = this.getLabel().getNode();
        List<Edge> list = AggregatingDiseaseModelStateImpl.getTransportEdges(node);
        for (Edge edge2 : list) {
            if (this.isEdgeWithAChildNode(edge2, node)) {
                this.addEdge(edge2, this.childTransportEdges);
                continue;
            }
            this.addEdge(edge2, this.parentPeerTransportEdges);
        }
        edge2 = new HashSet();
        edge2.addAll(this.childTransportEdges.keySet());
        edge2.addAll(this.parentPeerTransportEdges.keySet());
        this.transportModes.addAll((Collection<TransportMode>)edge2);
    }

    public static List<Edge> getTransportEdges(Node node) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : node.getEdges()) {
            EdgeLabel edgeLabel = edge.getLabel();
            if (!(edgeLabel instanceof TransportRelationshipLabel)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    private boolean isEdgeWithAChildNode(Edge edge, Node node) {
        boolean bl = false;
        Node node2 = edge.getOtherNode(node);
        bl = AggregatingSIDiseaseModelImpl.getParentNode(node2) == node;
        return bl;
    }

    private void addEdge(Edge edge, Map<TransportMode, List<Edge>> map) {
        TransportRelationshipLabel transportRelationshipLabel = (TransportRelationshipLabel)edge.getLabel();
        TransportMode transportMode = transportRelationshipLabel.getTransportMode();
        List<Edge> list = map.get(transportMode);
        if (list == null) {
            list = new ArrayList<Edge>();
            map.put(transportMode, list);
        }
        list.add(edge);
    }
}

