/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.impl.URIToNodeMapEntryImpl;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationship;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.definitions.labels.TransportMode;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.AggregatingDiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.AggregatingSIDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.SILabel;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.AggregatingDiseaseModelStateImpl;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelLabelImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingSIDiseaseModelImpl
extends SIImpl
implements AggregatingSIDiseaseModel {
    BasicEList reverseLabelsToUpdate = null;

    protected AggregatingSIDiseaseModelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.AGGREGATING_SI_DISEASE_MODEL;
    }

    @Override
    public void decorateGraph() {
        Node node = this.getRootNode(this.getGraph());
        if (node != null) {
            this.decorateGraph(node);
        } else {
            Activator.logInformation(String.valueOf(this.getDublinCore().getTitle()) + " didn't find a root node for the graph.  Missing containment relationship?", null);
        }
    }

    private Node getRootNode(Graph graph) {
        Node node = null;
        for (Node node2 : graph.getNodes().values()) {
            node = AggregatingSIDiseaseModelImpl.getParentNode(node2);
            if (node != null) break;
        }
        if (node != null) {
            Node node3 = node;
            while ((node3 = AggregatingSIDiseaseModelImpl.getParentNode(node = node3)) != null) {
            }
        }
        return node;
    }

    public static Node getParentNode(Node node) {
        Node node2 = null;
        if (node == null) {
            return null;
        }
        for (Edge edge : node.getEdges()) {
            RelativePhysicalRelationshipLabel relativePhysicalRelationshipLabel;
            EdgeLabel edgeLabel;
            if (!edge.isDirectedAt(node) || !((edgeLabel = edge.getLabel()) instanceof RelativePhysicalRelationshipLabel) || (relativePhysicalRelationshipLabel = (RelativePhysicalRelationshipLabel)edgeLabel).getCurrentRelationship().getRelationship() != RelativePhysicalRelationship.CONTAINS_LITERAL) continue;
            node2 = edge.getOtherNode(node);
            break;
        }
        return node2;
    }

    protected SILabel decorateGraph(Node node) {
        SILabel sILabel = null;
        if (node != null) {
            for (DiseaseModelLabel diseaseModelLabel : this.getDiseaseLabels(node)) {
                if (!(diseaseModelLabel instanceof SILabel) || !diseaseModelLabel.getPopulationLabel().getName().equals(this.getPopulationIdentifier())) continue;
                sILabel = (SILabel)diseaseModelLabel;
                break;
            }
            if (sILabel == null) {
                DiseaseModelLabel diseaseModelLabel;
                diseaseModelLabel = this.getChildrensLabels(node);
                PopulationLabel populationLabel = this.getOrCreatePopulationLabel(node, this.getPopulationIdentifier());
                DiseaseModelLabel diseaseModelLabel2 = this.createDiseaseModelLabel();
                DiseaseModelLabelImpl.labelNode(diseaseModelLabel2, populationLabel, node);
                this.getLabelsToUpdate().add((Object)diseaseModelLabel2);
                this.getGraph().putNodeLabel((NodeLabel)diseaseModelLabel2);
                DiseaseModelState diseaseModelState = this.createDiseaseModelState();
                AggregatingDiseaseModelState aggregatingDiseaseModelState = (AggregatingDiseaseModelState)diseaseModelState;
                aggregatingDiseaseModelState.getChildrensLabels().addAll((Collection)((Object)diseaseModelLabel));
                diseaseModelLabel2.setDiseaseModelState(aggregatingDiseaseModelState);
                sILabel = (SILabel)diseaseModelLabel2;
            }
        }
        return sILabel;
    }

    private List<DiseaseModelLabel> getDiseaseLabels(Node node) {
        ArrayList<DiseaseModelLabel> arrayList = new ArrayList<DiseaseModelLabel>();
        try {
            for (Label label : node.getLabels()) {
                if (!(label instanceof DiseaseModelLabel)) continue;
                DiseaseModelLabel diseaseModelLabel = (DiseaseModelLabel)label;
                arrayList.add(diseaseModelLabel);
            }
        }
        catch (NullPointerException nullPointerException) {
            Activator.logError("Internal error", nullPointerException);
        }
        return arrayList;
    }

    private EList getChildrensLabels(Node node) {
        BasicEList basicEList = new BasicEList();
        for (Node node2 : AggregatingSIDiseaseModelImpl.getChildNodes(node)) {
            basicEList.add((Object)this.decorateGraph(node2));
        }
        return basicEList;
    }

    public static List<Node> getChildNodes(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Edge edge : node.getEdges()) {
            Node node2;
            EdgeLabel edgeLabel = edge.getLabel();
            if (!(edgeLabel instanceof RelativePhysicalRelationshipLabel)) continue;
            RelativePhysicalRelationshipLabel relativePhysicalRelationshipLabel = (RelativePhysicalRelationshipLabel)edgeLabel;
            if (edge.isDirectedAt(node) || relativePhysicalRelationshipLabel.getCurrentRelationship().getRelationship() != RelativePhysicalRelationship.CONTAINS_LITERAL || (node2 = edge.getOtherNode(node)) == null) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    private PopulationLabel getOrCreatePopulationLabel(Node node, String string) {
        PopulationLabel populationLabel = null;
        for (Label label : node.getLabels()) {
            PopulationLabel populationLabel2;
            if (!(label instanceof PopulationLabel) || !(populationLabel2 = (PopulationLabel)label).getName().equals(string)) continue;
            populationLabel = populationLabel2;
            break;
        }
        if (populationLabel == null) {
            Label label;
            populationLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
            populationLabel.setURIOfIdentifiableToBeLabeled(node.getURI());
            node.getLabels().add((Object)populationLabel);
            Iterator iterator = (URIToNodeMapEntryImpl)node.eContainer();
            label = (Graph)iterator.eContainer();
            label.putNodeLabel((NodeLabel)populationLabel);
        }
        return populationLabel;
    }

    @Override
    public void updateLabels(STEMTime sTEMTime, long l, int n) {
        this.zeroOutPopulationCountsOnLabels();
        this.setProgress(0.0);
        double d = this.getLabelsToUpdate().size();
        double d2 = 0.0;
        for (SILabel sILabel : this.getLabelsToUpdate()) {
            AggregatingDiseaseModelState aggregatingDiseaseModelState = (AggregatingDiseaseModelState)sILabel.getDiseaseModelState();
            for (SILabel sILabel2 : aggregatingDiseaseModelState.getChildrensLabels()) {
                this.updateFromChildLabel(sILabel, sILabel2);
            }
            sILabel.setNextValueValid(true);
            this.setProgress(d2 / d);
            d2 += 1.0;
        }
        this.forwardTransportation(sTEMTime);
        this.setProgress(1.0);
    }

    protected void updateFromChildLabel(SILabel sILabel, SILabel sILabel2) {
        double d = sILabel.getNextDiseaseDeaths();
        sILabel.setNextDiseaseDeaths(d + sILabel2.getNextDiseaseDeaths());
        double d2 = sILabel.getNextS();
        double d3 = sILabel.getNextI();
        sILabel.setNextS(d2 + sILabel2.getNextS());
        sILabel.setNextI(d3 + sILabel2.getNextI());
    }

    @Override
    protected StandardDiseaseModelLabelValue computeDepartures(double d, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
        return super.computeDepartures(d, standardDiseaseModelLabelValue);
    }

    @Override
    public DiseaseModelState createDiseaseModelState() {
        return StandardFactory.eINSTANCE.createAggregatingDiseaseModelState();
    }

    @Override
    protected StandardDiseaseModelLabelValue getMigrationDeltas(StandardDiseaseModelLabel standardDiseaseModelLabel, STEMTime sTEMTime, DiseaseModelLabelValue diseaseModelLabelValue) {
        return super.getMigrationDeltas(standardDiseaseModelLabel, sTEMTime, diseaseModelLabelValue);
    }

    @Override
    public void initializeDiseaseState(DiseaseModelLabel diseaseModelLabel) {
    }

    @Override
    public DiseaseModelState initializeDiseaseState(DiseaseModelState diseaseModelState, DiseaseModelLabel diseaseModelLabel) {
        return diseaseModelState;
    }

    protected void forwardTransportation(STEMTime sTEMTime) {
        SILabelValue sILabelValue;
        Object object;
        Iterator iterator = this.getLabelsToUpdate().iterator();
        while (iterator.hasNext()) {
            SILabel sILabel = (SILabel)iterator.next();
            Object object2 = (AggregatingDiseaseModelStateImpl)sILabel.getDiseaseModelState();
            object = sILabel.getNode();
            boolean bl = !iterator.hasNext();
            for (TransportMode transportMode : ((AggregatingDiseaseModelStateImpl)object2).getTransportModes()) {
                sILabelValue = this.getArrivalsFromKids((Node)object, (AggregatingDiseaseModelStateImpl)object2, transportMode, sTEMTime);
                if (!bl) {
                    if (!(sILabelValue.getPopulationCount() > 0.0)) continue;
                    this.sendDeparturesToParentAndPeers(sILabelValue, (Node)object, (AggregatingDiseaseModelStateImpl)object2, transportMode, sTEMTime);
                    continue;
                }
                if (!(sILabelValue.getPopulationCount() > 0.0)) continue;
                this.sendDeparturesToKids(sILabelValue, (Node)object, (AggregatingDiseaseModelStateImpl)object2, transportMode, sTEMTime);
            }
        }
        boolean bl = true;
        for (Object object2 : this.getReverseLabelsToUpdate()) {
            object = (AggregatingDiseaseModelStateImpl)object2.getDiseaseModelState();
            Node node = object2.getNode();
            for (TransportMode transportMode : ((AggregatingDiseaseModelStateImpl)object).getTransportModes()) {
                if (!bl) {
                    sILabelValue = this.getArrivalsFromParentPeers(node, (AggregatingDiseaseModelStateImpl)object, transportMode, sTEMTime);
                    if (!(sILabelValue.getPopulationCount() > 0.0)) continue;
                    this.sendDeparturesToKids(sILabelValue, node, (AggregatingDiseaseModelStateImpl)object, transportMode, sTEMTime);
                    continue;
                }
                bl = false;
            }
        }
    }

    protected SILabelValue getArrivalsFromKids(Node node, AggregatingDiseaseModelStateImpl aggregatingDiseaseModelStateImpl, TransportMode transportMode, STEMTime sTEMTime) {
        return this.receiveFromEdges(node, aggregatingDiseaseModelStateImpl.getChildTransportEdges().get(transportMode), sTEMTime);
    }

    protected void sendDeparturesToKids(SILabelValue sILabelValue, Node node, AggregatingDiseaseModelStateImpl aggregatingDiseaseModelStateImpl, TransportMode transportMode, STEMTime sTEMTime) {
        this.sendToEdges(node, sILabelValue, aggregatingDiseaseModelStateImpl.getChildTransportEdges().get(transportMode), sTEMTime);
    }

    protected SILabelValue getArrivalsFromParentPeers(Node node, AggregatingDiseaseModelStateImpl aggregatingDiseaseModelStateImpl, TransportMode transportMode, STEMTime sTEMTime) {
        return this.receiveFromEdges(node, aggregatingDiseaseModelStateImpl.getParentPeerTransportEdges().get(transportMode), sTEMTime);
    }

    protected void sendDeparturesToParentAndPeers(SILabelValue sILabelValue, Node node, AggregatingDiseaseModelStateImpl aggregatingDiseaseModelStateImpl, TransportMode transportMode, STEMTime sTEMTime) {
        this.sendToEdges(node, sILabelValue, aggregatingDiseaseModelStateImpl.getParentPeerTransportEdges().get(transportMode), sTEMTime);
    }

    private SILabelValue receiveFromEdges(Node node, List<Edge> list, STEMTime sTEMTime) {
        SILabelValue sILabelValue = (SILabelValue)this.createDiseaseModelLabelValue();
        if (list != null) {
            for (Edge edge : list) {
                TransportRelationshipLabel transportRelationshipLabel = (TransportRelationshipLabel)edge.getLabel();
                EList eList = transportRelationshipLabel.receive(node, sTEMTime);
                for (SILabelValue sILabelValue2 : eList) {
                    sILabelValue.add(sILabelValue2);
                }
            }
        }
        return sILabelValue;
    }

    private void sendToEdges(Node node, SILabelValue sILabelValue, List<Edge> list, STEMTime sTEMTime) {
        if (list != null) {
            TransportRelationshipLabel transportRelationshipLabel;
            double d = 0.0;
            for (Edge edge : list) {
                transportRelationshipLabel = (TransportRelationshipLabel)edge.getLabel();
                d += (double)transportRelationshipLabel.getDepartureCapacity();
            }
            if (d > 0.0) {
                for (Edge edge : list) {
                    transportRelationshipLabel = (TransportRelationshipLabel)edge.getLabel();
                    double d2 = (double)transportRelationshipLabel.getDepartureCapacity() / d;
                    SILabelValue sILabelValue2 = (SILabelValue)this.createDiseaseModelLabelValue();
                    sILabelValue2.add(sILabelValue).scale(d2);
                    transportRelationshipLabel.send(node, (EObject)sILabelValue2);
                }
            }
        }
    }

    private BasicEList getReverseLabelsToUpdate() {
        if (this.reverseLabelsToUpdate == null) {
            EList eList = this.getLabelsToUpdate();
            int n = eList.size();
            this.reverseLabelsToUpdate = new BasicEList();
            int n2 = n - 1;
            while (n2 >= 0) {
                this.reverseLabelsToUpdate.add(eList.get(n2));
                --n2;
            }
        }
        return this.reverseLabelsToUpdate;
    }

    private void zeroOutPopulationCountsOnLabels() {
        for (SILabel sILabel : this.getLabelsToUpdate()) {
            ((StandardDiseaseModelLabelValue)sILabel.getCurrentValue()).zeroOutPopulationCount();
            ((StandardDiseaseModelLabelValue)sILabel.getNextValue()).zeroOutPopulationCount();
        }
    }

    @Override
    public void resetLabels() {
        super.resetLabels();
        for (SILabel sILabel : this.getLabelsToUpdate()) {
            sILabel.setS(0.0);
            sILabel.setNextS(0.0);
        }
    }

    public void doModelSpecificAdjustments(LabelValue labelValue) {
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean sane() {
        return true;
    }
}

