/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.NodeDecoratorImpl;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelLabelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiseaseModelImpl
extends NodeDecoratorImpl
implements DiseaseModel {
    protected static final double BACKGROUND_MORTALITY_RATE_EDEFAULT = 5.5E-5;
    protected double backgroundMortalityRate = 5.5E-5;
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    protected static final long TIME_PERIOD_EDEFAULT = STEMTime.Units.DAY.getMilliseconds();
    protected long timePeriod = TIME_PERIOD_EDEFAULT;
    protected static final String DISEASE_NAME_EDEFAULT = null;
    protected String diseaseName = DISEASE_NAME_EDEFAULT;
    protected static final double RELATIVE_TOLERANCE_EDEFAULT = 1.0E-9;
    protected double relativeTolerance = 1.0E-9;
    protected static final boolean FINITE_DIFFERENCE_EDEFAULT = true;
    protected boolean finiteDifference = true;
    protected static final boolean FREQUENCY_DEPENDENT_EDEFAULT = true;
    protected boolean frequencyDependent = true;
    protected static final double BACKGROUND_BIRTH_RATE_EDEFAULT = 5.5E-5;
    protected double backgroundBirthRate = 5.5E-5;

    protected DiseaseModelImpl() {
    }

    protected static DiseaseModel initializeDiseaseModel(DiseaseModel diseaseModel, String string, double d, long l, String string2) {
        diseaseModel.setDiseaseName(string);
        diseaseModel.getDublinCore().setTitle(string);
        diseaseModel.setBackgroundMortalityRate(d);
        diseaseModel.setTimePeriod(l);
        diseaseModel.setPopulationIdentifier(string2);
        return diseaseModel;
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.DISEASE_MODEL;
    }

    @Override
    public double getBackgroundMortalityRate() {
        return this.backgroundMortalityRate;
    }

    @Override
    public void setBackgroundMortalityRate(double d) {
        double d2 = this.backgroundMortalityRate;
        this.backgroundMortalityRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, d2, this.backgroundMortalityRate));
        }
    }

    @Override
    public long getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(long l) {
        long l2 = this.timePeriod;
        this.timePeriod = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, l2, this.timePeriod));
        }
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String string) {
        String string2 = this.populationIdentifier;
        this.populationIdentifier = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)string2, (Object)this.populationIdentifier));
        }
    }

    @Override
    public String getDiseaseName() {
        return this.diseaseName;
    }

    @Override
    public void setDiseaseName(String string) {
        String string2 = this.diseaseName;
        this.diseaseName = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)string2, (Object)this.diseaseName));
        }
    }

    @Override
    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    @Override
    public void setRelativeTolerance(double d) {
        double d2 = this.relativeTolerance;
        this.relativeTolerance = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, d2, this.relativeTolerance));
        }
    }

    @Override
    public boolean isFiniteDifference() {
        return this.finiteDifference;
    }

    @Override
    public void setFiniteDifference(boolean bl) {
        boolean bl2 = this.finiteDifference;
        this.finiteDifference = bl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, bl2, this.finiteDifference));
        }
    }

    @Override
    public boolean isFrequencyDependent() {
        return this.frequencyDependent;
    }

    @Override
    public void setFrequencyDependent(boolean bl) {
        boolean bl2 = this.frequencyDependent;
        this.frequencyDependent = bl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, bl2, this.frequencyDependent));
        }
    }

    @Override
    public double getBackgroundBirthRate() {
        return this.backgroundBirthRate;
    }

    @Override
    public void setBackgroundBirthRate(double d) {
        double d2 = this.backgroundBirthRate;
        this.backgroundBirthRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, d2, this.backgroundBirthRate));
        }
    }

    @Override
    public double getAdjustedBackgroundMortalityRate(long l) {
        return this.getBackgroundMortalityRate() * ((double)l / (double)this.getTimePeriod());
    }

    @Override
    public abstract DiseaseModelLabel createDiseaseModelLabel();

    @Override
    public abstract DiseaseModelLabelValue createDiseaseModelLabelValue();

    @Override
    public abstract DiseaseModelState createDiseaseModelState();

    @Override
    public abstract DiseaseModelState initializeDiseaseState(DiseaseModelState var1, DiseaseModelLabel var2);

    @Override
    public abstract void initializeDiseaseState(DiseaseModelLabel var1);

    @Override
    public abstract Infector createInfector();

    @Override
    public double getAdjustedBackgroundBirthRate(long l) {
        return this.getBackgroundBirthRate() * ((double)l / (double)this.getTimePeriod());
    }

    protected Collection<PopulationLabel> getPopulationLabels(String string, Graph graph) {
        ArrayList<PopulationLabel> arrayList = new ArrayList<PopulationLabel>();
        EList eList = graph.getNodeLabelsByTypeURI(PopulationLabel.URI_TYPE_POPULATION_LABEL);
        for (NodeLabel nodeLabel : eList) {
            PopulationLabel populationLabel = (PopulationLabel)nodeLabel;
            if (!populationLabel.getPopulationIdentifier().equals(string) || populationLabel.getNode() == null) continue;
            arrayList.add(populationLabel);
        }
        return arrayList;
    }

    public void decorateGraph() {
        for (PopulationLabel populationLabel : this.getPopulationLabels(this.getPopulationIdentifier(), this.getGraph())) {
            DiseaseModelLabel diseaseModelLabel = this.createDiseaseModelLabel();
            DiseaseModelLabelImpl.labelNode(diseaseModelLabel, populationLabel, populationLabel.getNode());
            this.getLabelsToUpdate().add((Object)diseaseModelLabel);
            this.getGraph().putNodeLabel((NodeLabel)diseaseModelLabel);
            DiseaseModelState diseaseModelState = this.createDiseaseModelState();
            diseaseModelLabel.setDiseaseModelState(this.initializeDiseaseState(diseaseModelState, diseaseModelLabel));
        }
        Iterator iterator = this.getLabelsToUpdate().iterator();
        while (iterator.hasNext()) {
            this.initializeDiseaseState((DiseaseModelLabel)iterator.next());
        }
        this.resetLabels();
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 8: {
                return new Double(this.getBackgroundMortalityRate());
            }
            case 9: {
                return this.getPopulationIdentifier();
            }
            case 10: {
                return new Long(this.getTimePeriod());
            }
            case 11: {
                return this.getDiseaseName();
            }
            case 12: {
                return new Double(this.getRelativeTolerance());
            }
            case 13: {
                return this.isFiniteDifference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.isFrequencyDependent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return new Double(this.getBackgroundBirthRate());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 8: {
                this.setBackgroundMortalityRate((Double)object);
                return;
            }
            case 9: {
                this.setPopulationIdentifier((String)object);
                return;
            }
            case 10: {
                this.setTimePeriod((Long)object);
                return;
            }
            case 11: {
                this.setDiseaseName((String)object);
                return;
            }
            case 12: {
                this.setRelativeTolerance((Double)object);
                return;
            }
            case 13: {
                this.setFiniteDifference((Boolean)object);
                return;
            }
            case 14: {
                this.setFrequencyDependent((Boolean)object);
                return;
            }
            case 15: {
                this.setBackgroundBirthRate((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 8: {
                this.setBackgroundMortalityRate(5.5E-5);
                return;
            }
            case 9: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 10: {
                this.setTimePeriod(TIME_PERIOD_EDEFAULT);
                return;
            }
            case 11: {
                this.setDiseaseName(DISEASE_NAME_EDEFAULT);
                return;
            }
            case 12: {
                this.setRelativeTolerance(1.0E-9);
                return;
            }
            case 13: {
                this.setFiniteDifference(true);
                return;
            }
            case 14: {
                this.setFrequencyDependent(true);
                return;
            }
            case 15: {
                this.setBackgroundBirthRate(5.5E-5);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 8: {
                return this.backgroundMortalityRate != 5.5E-5;
            }
            case 9: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 10: {
                return this.timePeriod != TIME_PERIOD_EDEFAULT;
            }
            case 11: {
                return DISEASE_NAME_EDEFAULT == null ? this.diseaseName != null : !DISEASE_NAME_EDEFAULT.equals(this.diseaseName);
            }
            case 12: {
                return this.relativeTolerance != 1.0E-9;
            }
            case 13: {
                return !this.finiteDifference;
            }
            case 14: {
                return !this.frequencyDependent;
            }
            case 15: {
                return this.backgroundBirthRate != 5.5E-5;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getDublinCore().getTitle();
        stringBuffer.append(string == null ? "<disease model>" : string);
        stringBuffer.append("(");
        stringBuffer.append(this.populationIdentifier);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.diseaseName != null;
        assert (bl);
        boolean bl3 = bl = bl && this.backgroundMortalityRate >= 0.0;
        assert (bl);
        boolean bl4 = bl = bl && !Double.isInfinite(this.backgroundMortalityRate);
        assert (bl);
        boolean bl5 = bl = bl && !Double.isNaN(this.backgroundMortalityRate);
        assert (bl);
        boolean bl6 = bl = bl && this.timePeriod >= TIME_PERIOD_EDEFAULT;
        assert (bl);
        return bl;
    }
}

