/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.impl.LabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;

public abstract class DiseaseModelLabelValueImpl
extends LabelValueImpl
implements DiseaseModelLabelValue {
    protected static final double DISEASE_DEATHS_EDEFAULT = 0.0;
    protected double diseaseDeaths = 0.0;
    protected static final double POPULATION_COUNT_EDEFAULT = 0.0;
    protected static final double INCIDENCE_EDEFAULT = 0.0;
    protected double incidence = 0.0;
    public static final double ABS_TOLERANCE = 1.0E-12;

    protected DiseaseModelLabelValueImpl() {
    }

    protected DiseaseModelLabelValueImpl(double d) {
        this.diseaseDeaths = d;
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.DISEASE_MODEL_LABEL_VALUE;
    }

    public abstract double getPopulationCount();

    public double getIncidence() {
        return this.incidence;
    }

    public void setIncidence(double d) {
        double d2 = this.incidence;
        this.incidence = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, d2, this.incidence));
        }
    }

    public abstract void zeroOutPopulationCount();

    public double getAdditions() {
        return 0.0;
    }

    public double getSubstractions() {
        return this.diseaseDeaths;
    }

    public double getDiseaseDeaths() {
        return this.diseaseDeaths;
    }

    public void setDiseaseDeaths(double d) {
        double d2 = this.diseaseDeaths;
        this.diseaseDeaths = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, d2, this.diseaseDeaths));
        }
    }

    public DiseaseModelLabelValue set(DiseaseModelLabelValue diseaseModelLabelValue) {
        this.setDiseaseDeaths(diseaseModelLabelValue.getDiseaseDeaths());
        this.setIncidence(diseaseModelLabelValue.getIncidence());
        return this;
    }

    public DiseaseModelLabelValue add(DiseaseModelLabelValue diseaseModelLabelValue) {
        return this;
    }

    public DiseaseModelLabelValue sub(DiseaseModelLabelValue diseaseModelLabelValue) {
        return this;
    }

    public DiseaseModelLabelValue scale(double d) {
        return this;
    }

    public void reset() {
        super.reset();
        this.setDiseaseDeaths(0.0);
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.diseaseDeaths >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && this.diseaseDeaths <= 1.0E12;
        assert (bl);
        boolean bl4 = bl = bl && !Double.isInfinite(this.diseaseDeaths);
        assert (bl);
        boolean bl5 = bl = bl && !Double.isNaN(this.diseaseDeaths);
        assert (bl);
        return bl;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 0: {
                return new Double(this.getDiseaseDeaths());
            }
            case 1: {
                return new Double(this.getPopulationCount());
            }
            case 2: {
                return new Double(this.getIncidence());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 0: {
                this.setDiseaseDeaths((Double)object);
                return;
            }
            case 2: {
                this.setIncidence((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 0: {
                this.setDiseaseDeaths(0.0);
                return;
            }
            case 2: {
                this.setIncidence(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 0: {
                return this.diseaseDeaths != 0.0;
            }
            case 1: {
                return this.getPopulationCount() != 0.0;
            }
            case 2: {
                return this.incidence != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("(DD: ");
        stringBuffer.append(this.diseaseDeaths);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

