/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.NodeDecoratorImpl;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabelValue;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfectorImpl
extends NodeDecoratorImpl
implements Infector {
    protected StandardDiseaseModel diseaseModel;
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected static final String DISEASE_NAME_EDEFAULT = null;
    protected String diseaseName = DISEASE_NAME_EDEFAULT;
    protected static final String TARGET_ISO_KEY_EDEFAULT = null;
    protected String targetISOKey = TARGET_ISO_KEY_EDEFAULT;
    protected EList<DiseaseModelLabel> labelsToInfect;
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = null;
    protected String populationIdentifier = POPULATION_IDENTIFIER_EDEFAULT;

    protected InfectorImpl() {
    }

    public void decorateGraph() {
        Graph graph = this.getGraph();
        if (this.diseaseModel == null) {
            for (Object object : graph.getDecorators()) {
                StandardDiseaseModel standardDiseaseModel;
                if (!(object instanceof StandardDiseaseModel) || !(standardDiseaseModel = (StandardDiseaseModel)object).getDiseaseName().equalsIgnoreCase(this.getDiseaseName())) continue;
                this.diseaseModel = standardDiseaseModel;
                break;
            }
        }
        if (this.diseaseModel != null) {
            Iterator iterator = this.getGraph().getNode(this.getTargetURI());
            if (iterator != null) {
                for (StandardDiseaseModel standardDiseaseModel : iterator.getLabels()) {
                    DiseaseModelLabel diseaseModelLabel;
                    if (!(standardDiseaseModel instanceof DiseaseModelLabel) || (diseaseModelLabel = (DiseaseModelLabel)((Object)standardDiseaseModel)).getDecorator() != this.diseaseModel) continue;
                    this.doInitialization(diseaseModelLabel);
                    this.getLabelsToInfect().add((Object)diseaseModelLabel);
                    break;
                }
            } else {
                Activator.logError("The node to infect specified by the URI \"" + this.getTargetURI() + "\" was not found.  The URI is likely incorrect.", null);
            }
        } else {
            Activator.logError("The disease named \"" + this.diseaseName + "\" was not found.", null);
        }
        this.setProgress(1.0);
    }

    public void resetLabels() {
        for (DiseaseModelLabel diseaseModelLabel : this.getLabelsToInfect()) {
            this.doInitialization(diseaseModelLabel);
        }
    }

    public void updateLabels(STEMTime sTEMTime, long l, int n) {
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.INFECTOR;
    }

    @Override
    public StandardDiseaseModel getDiseaseModel() {
        if (this.diseaseModel != null && this.diseaseModel.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.diseaseModel;
            this.diseaseModel = (StandardDiseaseModel)this.eResolveProxy(internalEObject);
            if (this.diseaseModel != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)internalEObject, (Object)this.diseaseModel));
            }
        }
        return this.diseaseModel;
    }

    public StandardDiseaseModel basicGetDiseaseModel() {
        return this.diseaseModel;
    }

    @Override
    public void setDiseaseModel(StandardDiseaseModel standardDiseaseModel) {
        StandardDiseaseModel standardDiseaseModel2 = this.diseaseModel;
        this.diseaseModel = standardDiseaseModel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)standardDiseaseModel2, (Object)this.diseaseModel));
        }
        this.setDiseaseName(this.diseaseModel != null ? this.diseaseModel.getDiseaseName() : null);
    }

    public Set<Node> getAllChildren(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        Set<Node> set = this.getChildSet(node);
        set.remove(node);
        HashSet<Node> hashSet2 = new HashSet<Node>();
        while (set.size() >= 1) {
            hashSet2.addAll(set);
            Iterator iterator = hashSet2.iterator();
            while (iterator != null && iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                hashSet.add(node2);
                Set<Node> set2 = this.getChildSet(node2);
                set2.removeAll(hashSet);
                set.addAll(set2);
            }
            set.removeAll(hashSet2);
            hashSet2.clear();
        }
        return hashSet;
    }

    public Set<Node> getChildSet(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        String string = this.getTargetURI().lastSegment();
        EList eList = node.getEdges();
        int n = 0;
        while (n < eList.size()) {
            Edge edge = (Edge)eList.get(n);
            LabelValue labelValue = edge.getLabel().getCurrentValue();
            if (labelValue instanceof RelativePhysicalRelationshipLabelValue) {
                RelativePhysicalRelationshipLabelValue cfr_ignored_0 = (RelativePhysicalRelationshipLabelValue)labelValue;
                Node node2 = edge.getOtherNode(node);
                String string2 = node2.getURI().lastSegment();
                if (string2.length() > string.length()) {
                    hashSet.add(node2);
                }
            }
            ++n;
        }
        hashSet.remove(node);
        return hashSet;
    }

    @Override
    public URI getTargetURI() {
        if (this.targetURI == null) {
            this.targetURI = RegionImpl.createRegionNodeURI((String)this.targetISOKey);
        }
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI uRI) {
        URI uRI2 = this.targetURI;
        this.targetURI = uRI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)uRI2, (Object)this.targetURI));
        }
    }

    @Override
    public String getDiseaseName() {
        return this.diseaseName;
    }

    @Override
    public void setDiseaseName(String string) {
        String string2 = this.diseaseName;
        this.diseaseName = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)string2, (Object)this.diseaseName));
        }
    }

    @Override
    public String getTargetISOKey() {
        return this.targetISOKey;
    }

    @Override
    public void setTargetISOKey(String string) {
        String string2 = this.targetISOKey;
        this.targetISOKey = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)string2, (Object)this.targetISOKey));
        }
        this.setTargetURI(null);
    }

    @Override
    public EList<DiseaseModelLabel> getLabelsToInfect() {
        if (this.labelsToInfect == null) {
            this.labelsToInfect = new EObjectResolvingEList(DiseaseModelLabel.class, (InternalEObject)this, 12);
        }
        return this.labelsToInfect;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String string) {
        String string2 = this.populationIdentifier;
        this.populationIdentifier = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)string2, (Object)this.populationIdentifier));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 8: {
                if (bl) {
                    return this.getDiseaseModel();
                }
                return this.basicGetDiseaseModel();
            }
            case 9: {
                return this.getTargetURI();
            }
            case 10: {
                return this.getDiseaseName();
            }
            case 11: {
                return this.getTargetISOKey();
            }
            case 12: {
                return this.getLabelsToInfect();
            }
            case 13: {
                return this.getPopulationIdentifier();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 8: {
                this.setDiseaseModel((StandardDiseaseModel)object);
                return;
            }
            case 9: {
                this.setTargetURI((URI)object);
                return;
            }
            case 10: {
                this.setDiseaseName((String)object);
                return;
            }
            case 11: {
                this.setTargetISOKey((String)object);
                return;
            }
            case 12: {
                this.getLabelsToInfect().clear();
                this.getLabelsToInfect().addAll((Collection)object);
                return;
            }
            case 13: {
                this.setPopulationIdentifier((String)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 8: {
                this.setDiseaseModel(null);
                return;
            }
            case 9: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 10: {
                this.setDiseaseName(DISEASE_NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setTargetISOKey(TARGET_ISO_KEY_EDEFAULT);
                return;
            }
            case 12: {
                this.getLabelsToInfect().clear();
                return;
            }
            case 13: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 8: {
                return this.diseaseModel != null;
            }
            case 9: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals((Object)this.targetURI);
            }
            case 10: {
                return DISEASE_NAME_EDEFAULT == null ? this.diseaseName != null : !DISEASE_NAME_EDEFAULT.equals(this.diseaseName);
            }
            case 11: {
                return TARGET_ISO_KEY_EDEFAULT == null ? this.targetISOKey != null : !TARGET_ISO_KEY_EDEFAULT.equals(this.targetISOKey);
            }
            case 12: {
                return this.labelsToInfect != null && !this.labelsToInfect.isEmpty();
            }
            case 13: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" (populationIdentifier: ");
        stringBuffer.append(this.populationIdentifier != null ? this.populationIdentifier : "\"\"");
        stringBuffer.append(", targetURI: ");
        stringBuffer.append(this.targetURI != null ? this.targetURI : "\"\"");
        stringBuffer.append(", diseaseName: ");
        stringBuffer.append(this.diseaseName != null ? this.diseaseName : "\"\"");
        stringBuffer.append(", targetISOKey: ");
        stringBuffer.append(this.targetISOKey != null ? this.targetISOKey : "\"\"");
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && (this.targetISOKey != null || this.targetURI != null);
        assert (bl);
        return bl;
    }

    protected abstract void doInitialization(DiseaseModelLabel var1);
}

