/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.impl.MigrationEdgeLabelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIR;
import org.eclipse.stem.diseasemodels.standard.SEIRLabel;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRImpl;

public abstract class SEIRImpl
extends SIRImpl
implements SEIR {
    protected static final double INCUBATION_RATE_EDEFAULT = 0.0;
    protected double incubationRate = 0.0;

    protected SEIRImpl() {
    }

    protected static SEIR initializeSEIRDiseaseModel(SEIR sEIR, String string, double d, double d2, double d3, double d4, double d5, double d6, double d7, long l, String string2) {
        SIRImpl.initializeSIRDiseaseModel(sEIR, string, d, d2, d3, d4, d5, d7, l, string2);
        sEIR.setIncubationRate(d6);
        return sEIR;
    }

    public SEIRLabelValue computeDiseaseDeathsDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SEIRLabelValue sEIRLabelValue = (SEIRLabelValue)standardDiseaseModelLabelValue;
        double d = this.getAdjustedInfectiousMortalityRate(l);
        double d2 = d * sEIRLabelValue.getI();
        SEIRLabelValueImpl sEIRLabelValueImpl = (SEIRLabelValueImpl)diseaseModelLabelValue;
        sEIRLabelValueImpl.setS(0.0);
        sEIRLabelValueImpl.setE(0.0);
        sEIRLabelValueImpl.setI(-d2);
        sEIRLabelValueImpl.setIncidence(0.0);
        sEIRLabelValueImpl.setR(0.0);
        sEIRLabelValueImpl.setDiseaseDeaths(d2);
        return sEIRLabelValueImpl;
    }

    public StandardDiseaseModelLabelValue computeDiseaseDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, StandardDiseaseModelLabel standardDiseaseModelLabel, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SEIRLabelValue sEIRLabelValue = (SEIRLabelValue)standardDiseaseModelLabelValue;
        double d = this.getAdjustedTransmissionRate(l);
        if (!this.isFrequencyDependent()) {
            d *= this.getTransmissionRateScaleFactor(standardDiseaseModelLabel);
        }
        double d2 = this.getNormalizedEffectiveInfectious(standardDiseaseModelLabel.getNode(), standardDiseaseModelLabel, sEIRLabelValue.getI());
        double d3 = this.getAdjustedRecoveryRate(l) * sEIRLabelValue.getI();
        double d4 = this.getAdjustedImmunityLossRate(l) * sEIRLabelValue.getR();
        double d5 = 0.0;
        d5 = this.getNonLinearityCoefficient() != 1.0 && d2 >= 0.0 ? d * sEIRLabelValue.getS() * Math.pow(d2, this.getNonLinearityCoefficient()) : d * sEIRLabelValue.getS() * d2;
        double d6 = this.getAdjustedIncubationRate(l) * sEIRLabelValue.getE();
        double d7 = d4 - d5;
        double d8 = d5 - d6;
        double d9 = d6 - d3;
        double d10 = d3 - d4;
        SEIRLabelValueImpl sEIRLabelValueImpl = (SEIRLabelValueImpl)diseaseModelLabelValue;
        sEIRLabelValueImpl.setS(d7);
        sEIRLabelValueImpl.setE(d8);
        sEIRLabelValueImpl.setI(d9);
        sEIRLabelValueImpl.setIncidence(d5);
        sEIRLabelValueImpl.setR(d10);
        sEIRLabelValueImpl.setDiseaseDeaths(0.0);
        return sEIRLabelValueImpl;
    }

    protected StandardDiseaseModelLabelValue getMigrationDeltas(StandardDiseaseModelLabel standardDiseaseModelLabel, STEMTime sTEMTime, DiseaseModelLabelValue diseaseModelLabelValue) {
        StandardDiseaseModelLabelValue cfr_ignored_0 = (StandardDiseaseModelLabelValue)this.createDiseaseModelLabelValue();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Node node = standardDiseaseModelLabel.getNode();
        block0: for (Edge edge : MigrationEdgeLabelImpl.getMigrationEdgesFromNode((Node)node)) {
            SEIRLabel sEIRLabel;
            MigrationEdgeLabel migrationEdgeLabel = (MigrationEdgeLabel)edge.getLabel();
            double d5 = migrationEdgeLabel.getCurrentValue().getMigrationRate();
            Node node2 = edge.getOtherNode(node);
            boolean bl = edge.getB().equals(node);
            if (bl) {
                for (NodeLabel nodeLabel : node2.getLabels()) {
                    if (!(nodeLabel instanceof StandardDiseaseModelLabel) || this != (sEIRLabel = (SEIRLabel)nodeLabel).getDecorator()) continue;
                    d += d5 * sEIRLabel.getCurrentSEIRValue().getS();
                    d2 += d5 * sEIRLabel.getCurrentSEIRValue().getE();
                    d3 += d5 * sEIRLabel.getCurrentSEIRValue().getI();
                    d4 += d5 * sEIRLabel.getCurrentSEIRValue().getR();
                    continue block0;
                }
                continue;
            }
            for (NodeLabel nodeLabel : node.getLabels()) {
                if (!(nodeLabel instanceof StandardDiseaseModelLabel) || this != (sEIRLabel = (SEIRLabel)nodeLabel).getDecorator()) continue;
                d -= d5 * sEIRLabel.getCurrentSEIRValue().getS();
                d2 -= d5 * sEIRLabel.getCurrentSEIRValue().getE();
                d3 -= d5 * sEIRLabel.getCurrentSEIRValue().getI();
                d4 -= d5 * sEIRLabel.getCurrentSEIRValue().getR();
                continue block0;
            }
        }
        SEIRLabelValueImpl sEIRLabelValueImpl = (SEIRLabelValueImpl)diseaseModelLabelValue;
        sEIRLabelValueImpl.setS(d);
        sEIRLabelValueImpl.setE(d2);
        sEIRLabelValueImpl.setI(d3);
        sEIRLabelValueImpl.setIncidence(0.0);
        sEIRLabelValueImpl.setR(d4);
        sEIRLabelValueImpl.setDiseaseDeaths(0.0);
        return sEIRLabelValueImpl;
    }

    protected StandardDiseaseModelLabelValue computeDepartures(double d, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
        SEIRLabelValue sEIRLabelValue = StandardFactory.eINSTANCE.createSEIRLabelValue();
        SEIRLabelValue sEIRLabelValue2 = (SEIRLabelValue)standardDiseaseModelLabelValue;
        sEIRLabelValue.setS(d * sEIRLabelValue2.getS());
        sEIRLabelValue.setE(d * sEIRLabelValue2.getE());
        sEIRLabelValue.setI(d * sEIRLabelValue2.getI());
        sEIRLabelValue.setR(d * sEIRLabelValue2.getR());
        return sEIRLabelValue;
    }

    public DiseaseModelLabel createDiseaseModelLabel() {
        return StandardFactory.eINSTANCE.createSEIRLabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue() {
        return StandardFactory.eINSTANCE.createSEIRLabelValue();
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.SEIR;
    }

    public double getIncubationRate() {
        return this.incubationRate;
    }

    public void setIncubationRate(double d) {
        double d2 = this.incubationRate;
        this.incubationRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 28, d2, this.incubationRate));
        }
    }

    public double getAdjustedIncubationRate(long l) {
        return this.getIncubationRate() * ((double)l / (double)this.getTimePeriod());
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 28: {
                return new Double(this.getIncubationRate());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 28: {
                this.setIncubationRate((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 28: {
                this.setIncubationRate(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 28: {
                return this.incubationRate != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (incubationRate: ");
        stringBuffer.append(this.incubationRate);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.incubationRate >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && !Double.isInfinite(this.incubationRate);
        assert (bl);
        boolean bl4 = bl = bl && !Double.isNaN(this.incubationRate);
        assert (bl);
        return bl;
    }
}

