/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class SEIRLabelValueImpl
extends SIRLabelValueImpl
implements SEIRLabelValue {
    protected static final double E_EDEFAULT = 0.0;
    protected double e = 0.0;

    protected SEIRLabelValueImpl() {
    }

    public SEIRLabelValueImpl(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d3, d4, d5, d6);
        this.e = d2;
    }

    public SEIRLabelValueImpl(double d, double d2, double d3, double d4, double d5) {
        super(d, d3, 0.0, d4, d5);
        this.e = d2;
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.SEIR_LABEL_VALUE;
    }

    public double getE() {
        return this.e;
    }

    public void setE(double d) {
        double d2 = this.e;
        this.e = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, d2, this.e));
        }
    }

    public double getPopulationCount() {
        return this.e + super.getPopulationCount();
    }

    public void zeroOutPopulationCount() {
        super.zeroOutPopulationCount();
        this.setE(0.0);
    }

    public DiseaseModelLabelValue set(IntegrationLabelValue integrationLabelValue) {
        super.set(integrationLabelValue);
        this.setE(((SEIRLabelValue)integrationLabelValue).getE());
        return this;
    }

    public DiseaseModelLabelValue add(IntegrationLabelValue integrationLabelValue) {
        super.add(integrationLabelValue);
        this.setE(this.getE() + ((SEIRLabelValue)integrationLabelValue).getE());
        return this;
    }

    public DiseaseModelLabelValue sub(IntegrationLabelValue integrationLabelValue) {
        super.sub(integrationLabelValue);
        this.setE(this.getE() - ((SEIRLabelValue)integrationLabelValue).getE());
        return this;
    }

    public DiseaseModelLabelValue scale(double d) {
        super.scale(d);
        this.setE(this.getE() * d);
        return this;
    }

    public DiseaseModelLabelValue add(double d) {
        super.add(d);
        this.setE(this.getE() + d);
        return this;
    }

    public DiseaseModelLabelValue abs() {
        super.abs();
        this.setE(Math.abs(this.getE()));
        return this;
    }

    public IntegrationLabelValue divide(IntegrationLabelValue integrationLabelValue) {
        SEIRLabelValue sEIRLabelValue = (SEIRLabelValue)integrationLabelValue;
        double d = Math.abs(this.s) / Math.abs(sEIRLabelValue.getS());
        double d2 = Math.abs(this.i) / Math.abs(sEIRLabelValue.getI());
        double d3 = Math.abs(this.r) / Math.abs(sEIRLabelValue.getR());
        double d4 = Math.abs(this.e) / Math.abs(sEIRLabelValue.getE());
        this.setS(d);
        this.setI(d2);
        this.setR(d3);
        this.setE(d4);
        return this;
    }

    public double max() {
        double d = this.s > this.i && this.s > this.r && this.s > this.e ? this.s : (this.i > this.r && this.i > this.e ? this.i : (this.r > this.e ? this.r : this.e));
        return d;
    }

    public boolean adjustDelta(IntegrationLabelValue integrationLabelValue) {
        SEIRLabelValue sEIRLabelValue = (SEIRLabelValue)integrationLabelValue;
        boolean bl = false;
        double d = this.getS() + sEIRLabelValue.getS();
        double d2 = this.getE() + sEIRLabelValue.getE();
        double d3 = this.getI() + sEIRLabelValue.getI();
        double d4 = this.getR() + sEIRLabelValue.getR();
        double d5 = 1.0;
        if (d < d2 && d < d3 && d < d4 && d < 0.0) {
            bl = true;
            d5 = -sEIRLabelValue.getS() / this.getS();
        } else if (d2 < d3 && d2 < d4 && d2 < 0.0) {
            bl = true;
            d5 = -sEIRLabelValue.getE() / this.getE();
        } else if (d3 < d4 && d3 < 0.0) {
            bl = true;
            d5 = -sEIRLabelValue.getI() / this.getI();
        } else if (d4 < 0.0) {
            bl = true;
            d5 = -sEIRLabelValue.getR() / this.getR();
        }
        if (bl) {
            this.scale(d5);
        }
        return bl;
    }

    public void reset() {
        super.reset();
        this.setE(0.0);
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.getE() >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && this.getE() <= 1.0E12;
        assert (bl);
        boolean bl4 = bl = bl && !Double.isInfinite(this.getE());
        assert (bl);
        boolean bl5 = bl = bl && !Double.isNaN(this.getE());
        assert (bl);
        return bl;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 6: {
                return new Double(this.getE());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 6: {
                this.setE((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 6: {
                this.setE(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 6: {
                return this.e != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("s:");
        stringBuffer.append(SEIRLabelValueImpl.getFormatter().format(this.s));
        stringBuffer.append(", e:");
        stringBuffer.append(SEIRLabelValueImpl.getFormatter().format(this.e));
        stringBuffer.append(", i:");
        stringBuffer.append(SEIRLabelValueImpl.getFormatter().format(this.i));
        stringBuffer.append(", r:");
        stringBuffer.append(SEIRLabelValueImpl.getFormatter().format(this.r));
        stringBuffer.append(", DD:");
        stringBuffer.append(SEIRLabelValueImpl.getFormatter().format(this.getDiseaseDeaths()));
        return stringBuffer.toString();
    }
}

