/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.impl.MigrationEdgeLabelImpl;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelValueImpl;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.SI;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.SILabel;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;

public abstract class SIImpl
extends StandardDiseaseModelImpl
implements SI {
    protected static final double TRANSMISSION_RATE_EDEFAULT = 0.0;
    protected double transmissionRate = 0.0;
    protected static final double NON_LINEARITY_COEFFICIENT_EDEFAULT = 1.0;
    protected double nonLinearityCoefficient = 1.0;
    protected static final double RECOVERY_RATE_EDEFAULT = 0.0;
    protected double recoveryRate = 0.0;
    protected static final double INFECTIOUS_MORTALITY_RATE_EDEFAULT = 0.0;
    protected double infectiousMortalityRate = 0.0;
    protected static final double PHYSICALLY_ADJACENT_INFECTIOUS_PROPORTION_EDEFAULT = 0.05;
    protected static final double REFERENCE_COMMUTE_DISTANCE = 45.0;
    protected double physicallyAdjacentInfectiousProportion = 0.05;
    protected static final double ROAD_NETWORK_INFECTIOUS_PROPORTION_EDEFAULT = 0.01;
    protected double roadNetworkInfectiousProportion = 0.01;
    protected static final double INFECTIOUS_MORTALITY_EDEFAULT = 0.0;
    protected double infectiousMortality = 0.0;

    protected SIImpl() {
    }

    protected static SI initializeSIDiseaseModel(SI sI, String string, double d, double d2, double d3, double d4, double d5, long l, String string2) {
        StandardDiseaseModelImpl.initializeStandardDiseaseModel(sI, string, d, l, string2);
        sI.setTransmissionRate(d3);
        sI.setRecoveryRate(d4);
        sI.setInfectiousMortalityRate(d2);
        sI.setNonLinearityCoefficient(d5);
        return sI;
    }

    public StandardDiseaseModelLabelValue computeDiseaseDeathsDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SILabelValue sILabelValue = (SILabelValue)standardDiseaseModelLabelValue;
        double d = this.getAdjustedInfectiousMortalityRate(l);
        double d2 = d * sILabelValue.getI();
        SILabelValueImpl sILabelValueImpl = (SILabelValueImpl)diseaseModelLabelValue;
        sILabelValueImpl.setS(0.0);
        sILabelValueImpl.setI(-d2);
        sILabelValueImpl.setIncidence(0.0);
        sILabelValueImpl.setDiseaseDeaths(d2);
        return sILabelValueImpl;
    }

    public StandardDiseaseModelLabelValue computeDiseaseDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, StandardDiseaseModelLabel standardDiseaseModelLabel, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SILabelValue sILabelValue = (SILabelValue)standardDiseaseModelLabelValue;
        double d = this.getAdjustedTransmissionRate(l);
        if (!this.isFrequencyDependent()) {
            d *= this.getTransmissionRateScaleFactor(standardDiseaseModelLabel);
        }
        double d2 = this.getNormalizedEffectiveInfectious(standardDiseaseModelLabel.getNode(), standardDiseaseModelLabel, sILabelValue.getI());
        double d3 = 0.0;
        d3 = this.getNonLinearityCoefficient() != 1.0 && d2 >= 0.0 ? d * sILabelValue.getS() * Math.pow(d2, this.getNonLinearityCoefficient()) : d * sILabelValue.getS() * d2;
        double d4 = this.getAdjustedRecoveryRate(l) * sILabelValue.getI();
        double d5 = -d3 + d4;
        double d6 = d3 - d4;
        SILabelValueImpl sILabelValueImpl = (SILabelValueImpl)diseaseModelLabelValue;
        sILabelValueImpl.setS(d5);
        sILabelValueImpl.setI(d6);
        sILabelValueImpl.setIncidence(d3);
        sILabelValueImpl.setDiseaseDeaths(0.0);
        return sILabelValueImpl;
    }

    protected StandardDiseaseModelLabelValue getMigrationDeltas(StandardDiseaseModelLabel standardDiseaseModelLabel, STEMTime sTEMTime, DiseaseModelLabelValue diseaseModelLabelValue) {
        StandardDiseaseModelLabelValue cfr_ignored_0 = (StandardDiseaseModelLabelValue)this.createDiseaseModelLabelValue();
        double d = 0.0;
        double d2 = 0.0;
        Node node = standardDiseaseModelLabel.getNode();
        block0: for (Edge edge : MigrationEdgeLabelImpl.getMigrationEdgesFromNode((Node)node)) {
            SILabel sILabel;
            MigrationEdgeLabel migrationEdgeLabel = (MigrationEdgeLabel)edge.getLabel();
            double d3 = migrationEdgeLabel.getCurrentValue().getMigrationRate();
            Node node2 = edge.getOtherNode(node);
            boolean bl = edge.getB().equals(node);
            if (bl) {
                for (NodeLabel nodeLabel : node2.getLabels()) {
                    if (!(nodeLabel instanceof StandardDiseaseModelLabel) || this != (sILabel = (SILabel)nodeLabel).getDecorator()) continue;
                    d += d3 * sILabel.getTempValue().getS();
                    d2 += d3 * sILabel.getTempValue().getI();
                    continue block0;
                }
                continue;
            }
            for (NodeLabel nodeLabel : node.getLabels()) {
                if (!(nodeLabel instanceof StandardDiseaseModelLabel) || this != (sILabel = (SILabel)nodeLabel).getDecorator()) continue;
                d -= d3 * sILabel.getTempValue().getS();
                d2 -= d3 * sILabel.getTempValue().getI();
                continue block0;
            }
        }
        SILabelValueImpl sILabelValueImpl = (SILabelValueImpl)diseaseModelLabelValue;
        sILabelValueImpl.setS(d);
        sILabelValueImpl.setI(d2);
        sILabelValueImpl.setIncidence(0.0);
        sILabelValueImpl.setDiseaseDeaths(0.0);
        return sILabelValueImpl;
    }

    protected StandardDiseaseModelLabelValue computeDepartures(double d, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
        SEIRLabelValue sEIRLabelValue = StandardFactory.eINSTANCE.createSEIRLabelValue();
        SILabelValue sILabelValue = (SILabelValue)standardDiseaseModelLabelValue;
        sEIRLabelValue.setS(d * sILabelValue.getS());
        sEIRLabelValue.setI(d * sILabelValue.getI());
        return sEIRLabelValue;
    }

    public double getTransmissionRateScaleFactor(StandardDiseaseModelLabel standardDiseaseModelLabel) {
        StandardDiseaseModelState cfr_ignored_0 = (StandardDiseaseModelState)standardDiseaseModelLabel.getDiseaseModelState();
        double d = this.getReferencePopulationDensity();
        assert (this.getArea(standardDiseaseModelLabel.getPopulationLabel()) > 0.0);
        double d2 = ((StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getTempValue()).getPopulationCount() / this.getArea(standardDiseaseModelLabel.getPopulationLabel());
        return d2 / d;
    }

    public DiseaseModelLabel createDiseaseModelLabel() {
        return StandardFactory.eINSTANCE.createSILabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue() {
        return StandardFactory.eINSTANCE.createSILabelValue();
    }

    public DiseaseModelState createDiseaseModelState() {
        return StandardFactory.eINSTANCE.createSIDiseaseModelState();
    }

    public Infector createInfector() {
        SIInfector sIInfector = StandardFactory.eINSTANCE.createSIInfector();
        sIInfector.setDiseaseName(this.getDiseaseName());
        sIInfector.setPopulationIdentifier(this.getPopulationIdentifier());
        return sIInfector;
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.SI;
    }

    public double getTransmissionRate() {
        return this.transmissionRate;
    }

    public void setTransmissionRate(double d) {
        double d2 = this.transmissionRate;
        this.transmissionRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, d2, this.transmissionRate));
        }
    }

    public double getRecoveryRate() {
        return this.recoveryRate;
    }

    public void setRecoveryRate(double d) {
        double d2 = this.recoveryRate;
        this.recoveryRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, d2, this.recoveryRate));
        }
    }

    public double getInfectiousMortalityRate() {
        return this.infectiousMortalityRate;
    }

    public void setInfectiousMortalityRate(double d) {
        double d2 = this.infectiousMortalityRate;
        this.infectiousMortalityRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, d2, this.infectiousMortalityRate));
        }
    }

    public double getPhysicallyAdjacentInfectiousProportion() {
        return this.physicallyAdjacentInfectiousProportion;
    }

    public void setPhysicallyAdjacentInfectiousProportion(double d) {
        double d2 = this.physicallyAdjacentInfectiousProportion;
        this.physicallyAdjacentInfectiousProportion = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 24, d2, this.physicallyAdjacentInfectiousProportion));
        }
    }

    public double getRoadNetworkInfectiousProportion() {
        return this.roadNetworkInfectiousProportion;
    }

    public void setRoadNetworkInfectiousProportion(double d) {
        double d2 = this.roadNetworkInfectiousProportion;
        this.roadNetworkInfectiousProportion = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 25, d2, this.roadNetworkInfectiousProportion));
        }
    }

    public double getInfectiousMortality() {
        return this.infectiousMortality;
    }

    public void setInfectiousMortality(double d) {
        double d2 = this.infectiousMortality;
        this.infectiousMortality = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 26, d2, this.infectiousMortality));
        }
    }

    public double getAdjustedInfectiousMortalityRate(long l) {
        return this.getInfectiousMortalityRate() * ((double)l / (double)this.getTimePeriod());
    }

    public double getNonLinearityCoefficient() {
        return this.nonLinearityCoefficient;
    }

    public void setNonLinearityCoefficient(double d) {
        double d2 = this.nonLinearityCoefficient;
        this.nonLinearityCoefficient = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, d2, this.nonLinearityCoefficient));
        }
    }

    public void doModelSpecificAdjustments(StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
    }

    public double getAdjustedTransmissionRate(long l) {
        return this.getTransmissionRate() * ((double)l / (double)this.getTimePeriod());
    }

    public double getAdjustedRecoveryRate(long l) {
        return this.getRecoveryRate() * ((double)l / (double)this.getTimePeriod());
    }

    public double getEffectiveInfectious(Node node, StandardDiseaseModelLabel standardDiseaseModelLabel, double d) {
        throw new UnsupportedOperationException();
    }

    public double getNormalizedEffectiveInfectious(Node node, StandardDiseaseModelLabel standardDiseaseModelLabel, double d) {
        double d2;
        double d3;
        Node node2;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (Edge edge : CommonBorderRelationshipLabelImpl.getCommonBorderEdgesFromNode((Node)node)) {
            node2 = edge.getOtherNode(node);
            d3 = this.getPhysicallyAdjacentInfectiousProportion();
            if (node2 instanceof Region) {
                double d7;
                d2 = -1.0;
                for (NodeLabel nodeLabel : node2.getLabels()) {
                    if (!(nodeLabel instanceof AreaLabel)) continue;
                    AreaLabel areaLabel = (AreaLabel)nodeLabel;
                    d2 = areaLabel.getCurrentAreaValue().getAverageExtent();
                    break;
                }
                if (d2 >= 1.0 && (d3 *= (d7 = 45.0 / d2)) >= 1.0) {
                    d3 = 1.0;
                }
            }
            d4 += this.getInfectiousChangeFromMixing(this, node2, standardDiseaseModelLabel, d, d3);
            d5 += this.getPhysicallyAdjacentInfectiousProportion() * this.getLocalPopulation(this, node2);
        }
        for (Edge edge : RoadTransportRelationshipLabelImpl.getRoadEdgesFromNode((Node)node)) {
            node2 = edge.getLabel();
            d3 = 1.0;
            if (node2 instanceof RoadTransportRelationshipLabelImpl) {
                RoadTransportRelationshipLabelValueImpl roadTransportRelationshipLabelValueImpl = (RoadTransportRelationshipLabelValueImpl)node2.getCurrentValue();
                d3 = roadTransportRelationshipLabelValueImpl.getNumberCrossings();
            }
            if ((d2 = this.getRoadNetworkInfectiousProportion() * d3) > 1.0) {
                d2 = 1.0;
            }
            Iterator iterator = edge.getOtherNode(node);
            d4 += this.getInfectiousChangeFromMixing(this, (Node)iterator, standardDiseaseModelLabel, d, d2);
            d6 += d2 * this.getLocalPopulation(this, (Node)iterator);
        }
        double d8 = ((StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getTempValue()).getPopulationCount() + d5 + d6;
        double d9 = 0.0;
        if (d8 > 0.0) {
            d9 = (d + d4) / d8;
        }
        return d9;
    }

    protected double getInfectiousChangeFromMixing(SI sI, Node node, StandardDiseaseModelLabel standardDiseaseModelLabel, double d, double d2) {
        this.getArea(standardDiseaseModelLabel.getPopulationLabel());
        ((StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getTempValue()).getPopulationCount();
        double d3 = 0.0;
        for (NodeLabel nodeLabel : node.getLabels()) {
            IntegrationLabel integrationLabel;
            if (!(nodeLabel instanceof StandardDiseaseModelLabel) || sI != (integrationLabel = (IntegrationLabel)nodeLabel).getDecorator()) continue;
            if (!this.isFrequencyDependent()) break;
            double d4 = ((SILabelValue)integrationLabel.getTempValue()).getI();
            double d5 = d2;
            d3 = d4 * d5;
            break;
        }
        return d3;
    }

    private double getLocalPopulation(SI sI, Node node) {
        for (NodeLabel nodeLabel : node.getLabels()) {
            IntegrationLabel integrationLabel;
            if (!(nodeLabel instanceof StandardDiseaseModelLabel) || sI != (integrationLabel = (IntegrationLabel)nodeLabel).getDecorator()) continue;
            return ((StandardDiseaseModelLabelValue)integrationLabel.getTempValue()).getPopulationCount();
        }
        return 0.0;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 20: {
                return new Double(this.getTransmissionRate());
            }
            case 21: {
                return new Double(this.getNonLinearityCoefficient());
            }
            case 22: {
                return new Double(this.getRecoveryRate());
            }
            case 23: {
                return new Double(this.getInfectiousMortalityRate());
            }
            case 24: {
                return new Double(this.getPhysicallyAdjacentInfectiousProportion());
            }
            case 25: {
                return new Double(this.getRoadNetworkInfectiousProportion());
            }
            case 26: {
                return new Double(this.getInfectiousMortality());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 20: {
                this.setTransmissionRate((Double)object);
                return;
            }
            case 21: {
                this.setNonLinearityCoefficient((Double)object);
                return;
            }
            case 22: {
                this.setRecoveryRate((Double)object);
                return;
            }
            case 23: {
                this.setInfectiousMortalityRate((Double)object);
                return;
            }
            case 24: {
                this.setPhysicallyAdjacentInfectiousProportion((Double)object);
                return;
            }
            case 25: {
                this.setRoadNetworkInfectiousProportion((Double)object);
                return;
            }
            case 26: {
                this.setInfectiousMortality((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 20: {
                this.setTransmissionRate(0.0);
                return;
            }
            case 21: {
                this.setNonLinearityCoefficient(1.0);
                return;
            }
            case 22: {
                this.setRecoveryRate(0.0);
                return;
            }
            case 23: {
                this.setInfectiousMortalityRate(0.0);
                return;
            }
            case 24: {
                this.setPhysicallyAdjacentInfectiousProportion(0.05);
                return;
            }
            case 25: {
                this.setRoadNetworkInfectiousProportion(0.01);
                return;
            }
            case 26: {
                this.setInfectiousMortality(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 20: {
                return this.transmissionRate != 0.0;
            }
            case 21: {
                return this.nonLinearityCoefficient != 1.0;
            }
            case 22: {
                return this.recoveryRate != 0.0;
            }
            case 23: {
                return this.infectiousMortalityRate != 0.0;
            }
            case 24: {
                return this.physicallyAdjacentInfectiousProportion != 0.05;
            }
            case 25: {
                return this.roadNetworkInfectiousProportion != 0.01;
            }
            case 26: {
                return this.infectiousMortality != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (transmissionRate: ");
        stringBuffer.append(this.transmissionRate);
        stringBuffer.append(", nonLinearityCoefficient: ");
        stringBuffer.append(this.nonLinearityCoefficient);
        stringBuffer.append(", recoveryRate: ");
        stringBuffer.append(this.recoveryRate);
        stringBuffer.append(", infectiousMortalityRate: ");
        stringBuffer.append(this.infectiousMortalityRate);
        stringBuffer.append(", physicallyAdjacentInfectiousProportion: ");
        stringBuffer.append(this.physicallyAdjacentInfectiousProportion);
        stringBuffer.append(", roadNetworkInfectiousProportion: ");
        stringBuffer.append(this.roadNetworkInfectiousProportion);
        stringBuffer.append(", infectiousMortality: ");
        stringBuffer.append(this.infectiousMortality);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.transmissionRate >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && !Double.isInfinite(this.transmissionRate);
        assert (bl);
        boolean bl4 = bl = bl && !Double.isNaN(this.transmissionRate);
        assert (bl);
        boolean bl5 = bl = bl && this.recoveryRate >= 0.0;
        assert (bl);
        boolean bl6 = bl = bl && !Double.isInfinite(this.recoveryRate);
        assert (bl);
        boolean bl7 = bl = bl && !Double.isNaN(this.recoveryRate);
        assert (bl);
        boolean bl8 = bl = bl && this.nonLinearityCoefficient >= 0.0;
        assert (bl);
        boolean bl9 = bl = bl && !Double.isInfinite(this.nonLinearityCoefficient);
        assert (bl);
        boolean bl10 = bl = bl && !Double.isNaN(this.nonLinearityCoefficient);
        assert (bl);
        return bl;
    }
}

