/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.impl.MigrationEdgeLabelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SIR;
import org.eclipse.stem.diseasemodels.standard.SIRLabel;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public abstract class SIRImpl
extends SIImpl
implements SIR {
    protected static final double IMMUNITY_LOSS_RATE_EDEFAULT = 0.0;
    protected double immunityLossRate = 0.0;

    protected SIRImpl() {
    }

    protected static SIR initializeSIRDiseaseModel(SIR sIR, String string, double d, double d2, double d3, double d4, double d5, double d6, long l, String string2) {
        SIImpl.initializeSIDiseaseModel(sIR, string, d, d2, d3, d4, d6, l, string2);
        sIR.setImmunityLossRate(d5);
        return sIR;
    }

    public DiseaseModelLabel createDiseaseModelLabel() {
        return StandardFactory.eINSTANCE.createSIRLabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue() {
        return StandardFactory.eINSTANCE.createSIRLabelValue();
    }

    public StandardDiseaseModelLabelValue computeDiseaseDeathsDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SIRLabelValue sIRLabelValue = (SIRLabelValue)standardDiseaseModelLabelValue;
        double d = this.getAdjustedInfectiousMortalityRate(l);
        double d2 = d * sIRLabelValue.getI();
        SIRLabelValueImpl sIRLabelValueImpl = (SIRLabelValueImpl)diseaseModelLabelValue;
        sIRLabelValueImpl.setS(0.0);
        sIRLabelValueImpl.setI(-d2);
        sIRLabelValueImpl.setIncidence(0.0);
        sIRLabelValueImpl.setR(0.0);
        sIRLabelValueImpl.setDiseaseDeaths(d2);
        return sIRLabelValueImpl;
    }

    public StandardDiseaseModelLabelValue computeDiseaseDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, StandardDiseaseModelLabel standardDiseaseModelLabel, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SIRLabelValue sIRLabelValue = (SIRLabelValue)standardDiseaseModelLabelValue;
        double d = this.getAdjustedTransmissionRate(l);
        if (!this.isFrequencyDependent()) {
            d *= this.getTransmissionRateScaleFactor(standardDiseaseModelLabel);
        }
        double d2 = this.getNormalizedEffectiveInfectious(standardDiseaseModelLabel.getNode(), standardDiseaseModelLabel, sIRLabelValue.getI());
        double d3 = this.getAdjustedRecoveryRate(l) * sIRLabelValue.getI();
        double d4 = this.getAdjustedImmunityLossRate(l) * sIRLabelValue.getR();
        double d5 = 0.0;
        d5 = this.getNonLinearityCoefficient() != 1.0 && d2 >= 0.0 ? d * sIRLabelValue.getS() * Math.pow(d2, this.getNonLinearityCoefficient()) : d * sIRLabelValue.getS() * d2;
        double d6 = d4 - d5;
        double d7 = d5 - d3;
        double d8 = d3 - d4;
        SIRLabelValueImpl sIRLabelValueImpl = (SIRLabelValueImpl)diseaseModelLabelValue;
        sIRLabelValueImpl.setS(d6);
        sIRLabelValueImpl.setI(d7);
        sIRLabelValueImpl.setIncidence(d3);
        sIRLabelValueImpl.setR(d8);
        sIRLabelValueImpl.setDiseaseDeaths(0.0);
        return sIRLabelValueImpl;
    }

    protected StandardDiseaseModelLabelValue getMigrationDeltas(StandardDiseaseModelLabel standardDiseaseModelLabel, STEMTime sTEMTime, DiseaseModelLabelValue diseaseModelLabelValue) {
        StandardDiseaseModelLabelValue cfr_ignored_0 = (StandardDiseaseModelLabelValue)this.createDiseaseModelLabelValue();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Node node = standardDiseaseModelLabel.getNode();
        block0: for (Edge edge : MigrationEdgeLabelImpl.getMigrationEdgesFromNode((Node)node)) {
            SIRLabel sIRLabel;
            MigrationEdgeLabel migrationEdgeLabel = (MigrationEdgeLabel)edge.getLabel();
            double d4 = migrationEdgeLabel.getCurrentValue().getMigrationRate();
            Node node2 = edge.getOtherNode(node);
            boolean bl = edge.getB().equals(node);
            if (bl) {
                for (NodeLabel nodeLabel : node2.getLabels()) {
                    if (!(nodeLabel instanceof StandardDiseaseModelLabel) || this != (sIRLabel = (SIRLabel)nodeLabel).getDecorator()) continue;
                    d += d4 * sIRLabel.getCurrentSIRValue().getS();
                    d2 += d4 * sIRLabel.getCurrentSIRValue().getI();
                    d3 += d4 * sIRLabel.getCurrentSIRValue().getR();
                    continue block0;
                }
                continue;
            }
            for (NodeLabel nodeLabel : node.getLabels()) {
                if (!(nodeLabel instanceof StandardDiseaseModelLabel) || this != (sIRLabel = (SIRLabel)nodeLabel).getDecorator()) continue;
                d -= d4 * sIRLabel.getCurrentSIRValue().getS();
                d2 -= d4 * sIRLabel.getCurrentSIRValue().getI();
                d3 -= d4 * sIRLabel.getCurrentSIRValue().getR();
                continue block0;
            }
        }
        SIRLabelValueImpl sIRLabelValueImpl = (SIRLabelValueImpl)diseaseModelLabelValue;
        sIRLabelValueImpl.setS(d);
        sIRLabelValueImpl.setI(d2);
        sIRLabelValueImpl.setIncidence(0.0);
        sIRLabelValueImpl.setR(d3);
        sIRLabelValueImpl.setDiseaseDeaths(0.0);
        return sIRLabelValueImpl;
    }

    protected StandardDiseaseModelLabelValue computeDepartures(double d, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
        SIRLabelValue sIRLabelValue = StandardFactory.eINSTANCE.createSIRLabelValue();
        SIRLabelValue sIRLabelValue2 = (SIRLabelValue)standardDiseaseModelLabelValue;
        sIRLabelValue.setS(d * sIRLabelValue2.getS());
        sIRLabelValue.setI(d * sIRLabelValue2.getI());
        sIRLabelValue.setR(d * sIRLabelValue2.getR());
        return sIRLabelValue;
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIR;
    }

    public double getImmunityLossRate() {
        return this.immunityLossRate;
    }

    public void setImmunityLossRate(double d) {
        double d2 = this.immunityLossRate;
        this.immunityLossRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 27, d2, this.immunityLossRate));
        }
    }

    public double getAdjustedImmunityLossRate(long l) {
        return this.getImmunityLossRate() * ((double)l / (double)this.getTimePeriod());
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 27: {
                return new Double(this.getImmunityLossRate());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 27: {
                this.setImmunityLossRate((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 27: {
                this.setImmunityLossRate(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 27: {
                return this.immunityLossRate != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (immunityLossRate: ");
        stringBuffer.append(this.immunityLossRate);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.immunityLossRate >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && !Double.isInfinite(this.immunityLossRate);
        assert (bl);
        boolean bl4 = bl = bl && !Double.isNaN(this.immunityLossRate);
        assert (bl);
        return bl;
    }
}

