/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.SEIRLabel;
import org.eclipse.stem.diseasemodels.standard.SIRInoculator;
import org.eclipse.stem.diseasemodels.standard.SIRLabel;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIInfectorImpl;

public class SIRInoculatorImpl
extends SIInfectorImpl
implements SIRInoculator {
    protected static final double INOCULATED_PERCENTAGE_EDEFAULT = 1.0;
    protected static final double INFECTIOUS_COUNT_EDEFAULT = 0.0;
    protected double inoculatedPercentage = 1.0;

    protected SIRInoculatorImpl() {
    }

    public void decorateGraph() {
        Object object;
        Graph graph = this.getGraph();
        if (this.diseaseModel == null) {
            for (Object object2 : graph.getDecorators()) {
                if (!(object2 instanceof StandardDiseaseModel) || !(object = (StandardDiseaseModel)object2).getDiseaseName().equalsIgnoreCase(this.getDiseaseName())) continue;
                this.diseaseModel = object;
                break;
            }
        }
        if (this.diseaseModel != null) {
            Object object2;
            Iterator iterator = this.getGraph().getNode(this.getTargetURI());
            object2 = this.getAllChildren((Node)iterator);
            object2.add(iterator);
            object = object2.iterator();
            block1: while (object != null && object.hasNext()) {
                Node node = (Node)object.next();
                if (node != null) {
                    for (NodeLabel nodeLabel : node.getLabels()) {
                        DiseaseModelLabel diseaseModelLabel;
                        if (!(nodeLabel instanceof DiseaseModelLabel) || (diseaseModelLabel = (DiseaseModelLabel)nodeLabel).getDecorator() != this.diseaseModel) continue;
                        this.doInitialization(diseaseModelLabel);
                        this.getLabelsToInfect().add((Object)diseaseModelLabel);
                        continue block1;
                    }
                    continue;
                }
                Activator.logError("The node to infect specified by the URI \"" + this.getTargetURI() + "\" was not found.  The URI is likely incorrect.", null);
            }
        } else {
            Activator.logError("The disease named \"" + this.diseaseName + "\" was not found.", null);
        }
        this.setProgress(1.0);
    }

    protected void doInitialization(DiseaseModelLabel diseaseModelLabel) {
        if (diseaseModelLabel instanceof SIRLabel || diseaseModelLabel instanceof SEIRLabel) {
            double d;
            double d2;
            diseaseModelLabel.getPopulationLabel().getCurrentPopulationValue().getCount();
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue = null;
            StandardDiseaseModelLabel standardDiseaseModelLabel = null;
            if (diseaseModelLabel instanceof SIRLabel) {
                standardDiseaseModelLabel = (SIRLabel)diseaseModelLabel;
                standardDiseaseModelLabelValue = (SIRLabelValue)standardDiseaseModelLabel.getCurrentValue();
            } else if (diseaseModelLabel instanceof SEIRLabel) {
                standardDiseaseModelLabel = (SEIRLabel)diseaseModelLabel;
                standardDiseaseModelLabelValue = (SIRLabelValue)standardDiseaseModelLabel.getCurrentValue();
            }
            double d3 = standardDiseaseModelLabelValue.getS();
            double d4 = this.getInoculatedPercentage();
            if (d4 > 100.0) {
                Activator.logError("InoculatedPercentage must be <= 100%. Was " + d4 + " Now resetting to 100%", null);
                d4 = 100.0;
            }
            d2 = (d2 = d3 - (d = d3 * (d4 / 100.0))) < 0.0 ? 0.0 : d2;
            d = d < 0.0 ? 0.0 : d;
            double d5 = standardDiseaseModelLabelValue.getR() + d;
            ((SIRLabelValue)standardDiseaseModelLabel.getCurrentValue()).setS(d2);
            ((SIRLabelValue)standardDiseaseModelLabel.getNextValue()).setS(d2);
            ((SIRLabelValue)standardDiseaseModelLabel.getCurrentValue()).setR(d5);
            ((SIRLabelValue)standardDiseaseModelLabel.getNextValue()).setR(d5);
        } else {
            Activator.logError("Can not Inoculated an SI diesase model. Disease Model must be SIR. Check compatibility of Innoculaor for Disease Model In scenario ", null);
        }
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIR_INOCULATOR;
    }

    public double getInoculatedPercentage() {
        return this.inoculatedPercentage;
    }

    public void setInoculatedPercentage(double d) {
        double d2 = this.inoculatedPercentage;
        this.inoculatedPercentage = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, d2, this.inoculatedPercentage));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 15: {
                return new Double(this.getInoculatedPercentage());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 15: {
                this.setInoculatedPercentage((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 15: {
                this.setInoculatedPercentage(1.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 15: {
                return this.inoculatedPercentage != 1.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (inoculatedPercentage: ");
        stringBuffer.append(this.inoculatedPercentage);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

