/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;

public class SIRLabelValueImpl
extends SILabelValueImpl
implements SIRLabelValue {
    protected static final double R_EDEFAULT = 0.0;
    protected double r = 0.0;

    protected SIRLabelValueImpl() {
    }

    public SIRLabelValueImpl(double d, double d2, double d3, double d4, double d5) {
        super(d, d2, d3, d5);
        this.r = d4;
    }

    public SIRLabelValueImpl(double d, double d2, double d3, double d4) {
        super(d, d2, 0.0, d4);
        this.r = d3;
    }

    protected EClass eStaticClass() {
        return StandardPackage.Literals.SIR_LABEL_VALUE;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double d) {
        double d2 = this.r;
        this.r = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, d2, this.r));
        }
    }

    public double getPopulationCount() {
        return super.getPopulationCount() + this.r;
    }

    public void zeroOutPopulationCount() {
        super.zeroOutPopulationCount();
        this.setR(0.0);
    }

    public DiseaseModelLabelValue set(IntegrationLabelValue integrationLabelValue) {
        super.set(integrationLabelValue);
        this.setR(((SIRLabelValue)integrationLabelValue).getR());
        return this;
    }

    public DiseaseModelLabelValue add(IntegrationLabelValue integrationLabelValue) {
        super.add(integrationLabelValue);
        this.setR(this.getR() + ((SIRLabelValue)integrationLabelValue).getR());
        return this;
    }

    public DiseaseModelLabelValue sub(IntegrationLabelValue integrationLabelValue) {
        super.sub(integrationLabelValue);
        this.setR(this.getR() - ((SIRLabelValue)integrationLabelValue).getR());
        return this;
    }

    public DiseaseModelLabelValue scale(double d) {
        super.scale(d);
        this.setR(this.getR() * d);
        return this;
    }

    public DiseaseModelLabelValue add(double d) {
        super.add(d);
        this.setR(this.getR() + d);
        return this;
    }

    public DiseaseModelLabelValue abs() {
        super.abs();
        this.setR(Math.abs(this.getR()));
        return this;
    }

    public IntegrationLabelValue divide(IntegrationLabelValue integrationLabelValue) {
        SIRLabelValue sIRLabelValue = (SIRLabelValue)integrationLabelValue;
        double d = Math.abs(this.s) / Math.abs(sIRLabelValue.getS());
        double d2 = Math.abs(this.i) / Math.abs(sIRLabelValue.getI());
        double d3 = Math.abs(this.r) / Math.abs(sIRLabelValue.getR());
        this.setS(d);
        this.setI(d2);
        this.setR(d3);
        return this;
    }

    public double max() {
        double d = this.s > this.i && this.s > this.r ? this.s : (this.i > this.r ? this.i : this.r);
        return d;
    }

    public boolean adjustDelta(IntegrationLabelValue integrationLabelValue) {
        SIRLabelValue sIRLabelValue = (SIRLabelValue)integrationLabelValue;
        boolean bl = false;
        double d = this.getS() + sIRLabelValue.getS();
        double d2 = this.getI() + sIRLabelValue.getI();
        double d3 = this.getR() + sIRLabelValue.getR();
        double d4 = 1.0;
        if (d < d2 && d < d3 && d < 0.0) {
            bl = true;
            d4 = -sIRLabelValue.getS() / this.getS();
        } else if (d2 < d3 && d2 < 0.0) {
            bl = true;
            d4 = -sIRLabelValue.getI() / this.getI();
        } else if (d3 < 0.0) {
            bl = true;
            d4 = -sIRLabelValue.getR() / this.getR();
        }
        if (bl) {
            this.scale(d4);
        }
        return bl;
    }

    public void reset() {
        super.reset();
        this.setR(0.0);
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.getR() >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && this.getR() <= 1.0E12;
        assert (bl);
        boolean bl4 = bl = bl && !Double.isInfinite(this.getR());
        assert (bl);
        boolean bl5 = bl = bl && !Double.isNaN(this.getR());
        assert (bl);
        return bl;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 5: {
                return new Double(this.getR());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 5: {
                this.setR((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 5: {
                this.setR(0.0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 5: {
                return this.r != 0.0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("s:");
        stringBuffer.append(SIRLabelValueImpl.getFormatter().format(this.s));
        stringBuffer.append(", i:");
        stringBuffer.append(SIRLabelValueImpl.getFormatter().format(this.i));
        stringBuffer.append(", r:");
        stringBuffer.append(SIRLabelValueImpl.getFormatter().format(this.r));
        stringBuffer.append(", DD:");
        stringBuffer.append(SIRLabelValueImpl.getFormatter().format(this.getDiseaseDeaths()));
        return stringBuffer.toString();
    }
}

