/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.SimpleDataExchangeLabelValue;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.impl.TransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.transport.PipeTransportEdge;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabelValue;
import org.eclipse.stem.definitions.transport.impl.PipeStyleTransportSystemImpl;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelState;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StandardDiseaseModelImpl
extends DiseaseModelImpl
implements StandardDiseaseModel {
    protected static final double TOTAL_POPULATION_COUNT_EDEFAULT = 0.0;
    protected double totalPopulationCount = 0.0;
    protected static final double TOTAL_POPULATION_COUNT_RECIPROCAL_EDEFAULT = 0.0;
    protected double totalPopulationCountReciprocal = 0.0;
    protected static final double TOTAL_AREA_EDEFAULT = 0.0;
    protected double totalArea = 0.0;
    protected static final double REFERENCE_POPULATION_DENSITY_EDEFAULT = 100.0;
    protected double referencePopulationDensity = 100.0;
    protected Map<Integer, List<PipeTransportEdge>> pipeTransportationUpEdgesMap;
    protected Map<Integer, List<PipeTransportEdge>> pipeTransportationDownEdgesMap;
    protected Map<Node, List<PipeTransportEdge>> pipeTransportationNodeEdgesMap;
    protected StandardDiseaseModelLabelValue departures = (StandardDiseaseModelLabelValue)this.createDiseaseModelLabelValue();

    protected StandardDiseaseModelImpl() {
    }

    protected static StandardDiseaseModel initializeStandardDiseaseModel(StandardDiseaseModel standardDiseaseModel, String string, double d, long l, String string2) {
        DiseaseModelImpl.initializeDiseaseModel(standardDiseaseModel, string, d, l, string2);
        return standardDiseaseModel;
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_DISEASE_MODEL;
    }

    @Override
    public double getTotalPopulationCount() {
        return this.totalPopulationCount;
    }

    @Override
    public void setTotalPopulationCount(double d) {
        double d2 = this.totalPopulationCount;
        this.totalPopulationCount = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, d2, this.totalPopulationCount));
        }
    }

    @Override
    public double getTotalPopulationCountReciprocal() {
        return this.totalPopulationCountReciprocal;
    }

    @Override
    public double getTotalArea() {
        return this.totalArea;
    }

    @Override
    public void setTotalArea(double d) {
        double d2 = this.totalArea;
        this.totalArea = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, d2, this.totalArea));
        }
    }

    @Override
    public double getReferencePopulationDensity() {
        return this.referencePopulationDensity;
    }

    @Override
    public void setReferencePopulationDensity(double d) {
        double d2 = this.referencePopulationDensity;
        this.referencePopulationDensity = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, d2, this.referencePopulationDensity));
        }
    }

    @Override
    public void addToTotalPopulationCount(double d) {
        this.setTotalPopulationCount(this.totalPopulationCount + d);
    }

    @Override
    public double computeTotalPopulationCountReciprocal() {
        this.totalPopulationCountReciprocal = 1.0 / this.totalPopulationCount;
        return this.totalPopulationCountReciprocal;
    }

    @Override
    public void addToTotalArea(double d) {
        this.setTotalArea(this.totalArea + d);
    }

    @Override
    public void calculateDelta(STEMTime sTEMTime, long l, EList<DynamicLabel> eList) {
        DiseaseModelLabelValue diseaseModelLabelValue = this.createDiseaseModelLabelValue();
        DiseaseModelLabelValue diseaseModelLabelValue2 = this.createDiseaseModelLabelValue();
        DiseaseModelLabelValue diseaseModelLabelValue3 = this.createDiseaseModelLabelValue();
        DiseaseModelLabelValue diseaseModelLabelValue4 = this.createDiseaseModelLabelValue();
        for (StandardDiseaseModelLabel standardDiseaseModelLabel : eList) {
            assert (standardDiseaseModelLabel.getPopulationLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier()));
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getProbeValue();
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue2 = this.getMigrationDeltas(standardDiseaseModelLabel, sTEMTime, diseaseModelLabelValue);
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue3 = this.getPipeTransportationDeltas(standardDiseaseModelLabel, sTEMTime, l, diseaseModelLabelValue2);
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue4 = this.computeDiseaseDeathsDeltas(sTEMTime, standardDiseaseModelLabelValue, l, diseaseModelLabelValue3);
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue5 = standardDiseaseModelLabelValue;
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue6 = this.computeDiseaseDeltas(sTEMTime, standardDiseaseModelLabelValue5, standardDiseaseModelLabel, l, diseaseModelLabelValue4);
            double d = standardDiseaseModelLabelValue6.getIncidence();
            double d2 = standardDiseaseModelLabelValue4.getDiseaseDeaths();
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue7 = (StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getDeltaValue();
            standardDiseaseModelLabelValue7.reset();
            standardDiseaseModelLabelValue7.add(standardDiseaseModelLabelValue2);
            standardDiseaseModelLabelValue7.add(standardDiseaseModelLabelValue3);
            standardDiseaseModelLabelValue7.add(standardDiseaseModelLabelValue4);
            standardDiseaseModelLabelValue7.add(standardDiseaseModelLabelValue6);
            standardDiseaseModelLabelValue7.setIncidence(d);
            standardDiseaseModelLabelValue7.setDiseaseDeaths(d2);
            diseaseModelLabelValue.reset();
            diseaseModelLabelValue2.reset();
            diseaseModelLabelValue3.reset();
            diseaseModelLabelValue4.reset();
        }
    }

    public void applyExternalDeltas(STEMTime sTEMTime, long l, EList<DynamicLabel> eList) {
        for (StandardDiseaseModelLabel standardDiseaseModelLabel : eList) {
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getDeltaValue();
            Node node = standardDiseaseModelLabel.getNode();
            EList eList2 = node.getLabels();
            for (NodeLabel nodeLabel : eList2) {
                if (!(nodeLabel instanceof IntegrationLabel) || nodeLabel.equals(standardDiseaseModelLabel)) continue;
                SimpleDataExchangeLabelValue simpleDataExchangeLabelValue = (SimpleDataExchangeLabelValue)((IntegrationLabel)nodeLabel).getDeltaValue();
                double d = simpleDataExchangeLabelValue.getAdditions();
                double d2 = simpleDataExchangeLabelValue.getSubstractions();
                standardDiseaseModelLabelValue.setS(standardDiseaseModelLabelValue.getS() + d);
                StandardDiseaseModelLabelValue standardDiseaseModelLabelValue2 = (StandardDiseaseModelLabelValue)EcoreUtil.copy((EObject)((StandardDiseaseModelLabelValue)standardDiseaseModelLabel.getTempValue()));
                double d3 = standardDiseaseModelLabelValue2.getPopulationCount();
                double d4 = d2 / d3;
                if (Double.isNaN(d4) || Double.isInfinite(d4)) {
                    d4 = 0.0;
                }
                standardDiseaseModelLabelValue2.scale(d4);
                standardDiseaseModelLabelValue.sub(standardDiseaseModelLabelValue2);
            }
        }
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 16: {
                return new Double(this.getTotalPopulationCount());
            }
            case 17: {
                return new Double(this.getTotalPopulationCountReciprocal());
            }
            case 18: {
                return new Double(this.getTotalArea());
            }
            case 19: {
                return new Double(this.getReferencePopulationDensity());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 16: {
                this.setTotalPopulationCount((Double)object);
                return;
            }
            case 18: {
                this.setTotalArea((Double)object);
                return;
            }
            case 19: {
                this.setReferencePopulationDensity((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 16: {
                this.setTotalPopulationCount(0.0);
                return;
            }
            case 18: {
                this.setTotalArea(0.0);
                return;
            }
            case 19: {
                this.setReferencePopulationDensity(100.0);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 16: {
                return this.totalPopulationCount != 0.0;
            }
            case 17: {
                return this.totalPopulationCountReciprocal != 0.0;
            }
            case 18: {
                return this.totalArea != 0.0;
            }
            case 19: {
                return this.referencePopulationDensity != 100.0;
            }
        }
        return super.eIsSet(n);
    }

    public void updateLabels(STEMTime sTEMTime, long l, int n) {
        throw new UnsupportedOperationException();
    }

    private void populatePipeSystemNodes() {
        Object object;
        PipeStyleTransportSystemImpl pipeStyleTransportSystemImpl;
        Graph graph = this.getGraph();
        if (this.pipeTransportationUpEdgesMap == null || this.pipeTransportationDownEdgesMap == null) {
            this.initPipeTransport(graph);
        }
        Map<Integer, List<PipeTransportEdge>> map = this.pipeTransportationUpEdgesMap;
        Integer[] integerArray = new Integer[map.keySet().size()];
        integerArray = map.keySet().toArray(integerArray);
        Arrays.sort(integerArray, 0, integerArray.length, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                if (n < n2) {
                    return 1;
                }
                if (n > n2) {
                    return -1;
                }
                return 0;
            }
        });
        Integer[] integerArray2 = integerArray;
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = integerArray2[n2];
            pipeStyleTransportSystemImpl = map.get(n3);
            for (Object object422 : pipeStyleTransportSystemImpl) {
                double d;
                object = object422.getA();
                Node node = object422.getB();
                if (object == null || node == null) continue;
                PipeTransportEdgeLabelValue pipeTransportEdgeLabelValue = (PipeTransportEdgeLabelValue)object422.getLabel().getCurrentValue();
                double d2 = pipeTransportEdgeLabelValue.getMaxFlow();
                StandardDiseaseModelLabelValue standardDiseaseModelLabelValue = null;
                StandardDiseaseModelLabelValue standardDiseaseModelLabelValue2 = null;
                PopulationLabelValue populationLabelValue = null;
                for (NodeLabel nodeLabel : object.getLabels()) {
                    if (nodeLabel instanceof DiseaseModelLabel) {
                        standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)((StandardDiseaseModelLabel)nodeLabel).getCurrentValue();
                        StandardDiseaseModelLabelValue cfr_ignored_0 = (StandardDiseaseModelLabelValue)((StandardDiseaseModelLabel)nodeLabel).getNextValue();
                        continue;
                    }
                    if (!(nodeLabel instanceof PopulationLabel)) continue;
                    ((PopulationLabel)nodeLabel).getCurrentPopulationValue();
                }
                for (NodeLabel nodeLabel : node.getLabels()) {
                    if (nodeLabel instanceof DiseaseModelLabel) {
                        standardDiseaseModelLabelValue2 = (StandardDiseaseModelLabelValue)((StandardDiseaseModelLabel)nodeLabel).getCurrentValue();
                        StandardDiseaseModelLabelValue cfr_ignored_1 = (StandardDiseaseModelLabelValue)((StandardDiseaseModelLabel)nodeLabel).getNextValue();
                        continue;
                    }
                    if (!(nodeLabel instanceof PopulationLabel)) continue;
                    populationLabelValue = ((PopulationLabel)nodeLabel).getCurrentPopulationValue();
                }
                if (standardDiseaseModelLabelValue == null || standardDiseaseModelLabelValue2 == null) continue;
                double d3 = d2;
                if (standardDiseaseModelLabelValue.getPopulationCount() < d3) {
                    d3 = standardDiseaseModelLabelValue.getPopulationCount();
                }
                if (Double.isNaN(d = d3 / standardDiseaseModelLabelValue.getPopulationCount())) {
                    d = 0.0;
                }
                DiseaseModelLabelValue diseaseModelLabelValue = null;
                diseaseModelLabelValue = (DiseaseModelLabelValue)EcoreUtil.copy((EObject)standardDiseaseModelLabelValue);
                diseaseModelLabelValue.scale(d);
                diseaseModelLabelValue.setDiseaseDeaths(0.0);
                standardDiseaseModelLabelValue2.add(diseaseModelLabelValue);
                populationLabelValue.setCount(standardDiseaseModelLabelValue2.getPopulationCount());
            }
            ++n2;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.pipeTransportationNodeEdgesMap.keySet()) {
            Object object422;
            boolean bl = false;
            if (!(node instanceof PipeStyleTransportSystemImpl)) continue;
            pipeStyleTransportSystemImpl = (PipeStyleTransportSystemImpl)node;
            for (Object object422 : pipeStyleTransportSystemImpl.getLabels()) {
                StandardDiseaseModelLabelValue standardDiseaseModelLabelValue;
                if (object422 instanceof StandardDiseaseModelLabel && (standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)(object = (StandardDiseaseModelLabel)object422).getCurrentValue()).getPopulationCount() == 0.0) {
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            object422 = new ArrayList();
            if (!bl) continue;
            Activator.logInformation("Warning, ignoring air transportation node without population " + node, new Exception());
            arrayList.add(node);
            for (List list : this.pipeTransportationDownEdgesMap.values()) {
                for (PipeTransportEdge pipeTransportEdge : list) {
                    if (pipeTransportEdge.getA() == null || pipeTransportEdge.getB() == null || !pipeTransportEdge.getA().equals(node) && !pipeTransportEdge.getB().equals(node) || ((ArrayList)object422).contains(pipeTransportEdge)) continue;
                    ((ArrayList)object422).add(pipeTransportEdge);
                }
            }
            for (List list : this.pipeTransportationUpEdgesMap.values()) {
                for (PipeTransportEdge pipeTransportEdge : list) {
                    if (pipeTransportEdge.getA() == null || pipeTransportEdge.getB() == null || !pipeTransportEdge.getA().equals(node) && !pipeTransportEdge.getB().equals(node) || ((ArrayList)object422).contains(pipeTransportEdge)) continue;
                    ((ArrayList)object422).add(pipeTransportEdge);
                }
            }
            object = ((ArrayList)object422).iterator();
            while (object.hasNext()) {
                PipeTransportEdge pipeTransportEdge = (PipeTransportEdge)object.next();
                for (List list : this.pipeTransportationDownEdgesMap.values()) {
                    list.remove(pipeTransportEdge);
                }
                for (List list : this.pipeTransportationUpEdgesMap.values()) {
                    list.remove(pipeTransportEdge);
                }
            }
            object = ((ArrayList)object422).iterator();
            while (object.hasNext()) {
                PipeTransportEdge pipeTransportEdge = (PipeTransportEdge)object.next();
                for (List list : this.pipeTransportationNodeEdgesMap.values()) {
                    list.remove(pipeTransportEdge);
                }
                for (List list : this.pipeTransportationNodeEdgesMap.values()) {
                    list.remove(pipeTransportEdge);
                }
            }
        }
        for (Node node : arrayList) {
            this.pipeTransportationNodeEdgesMap.remove(node);
        }
    }

    private void initPipeTransport(Graph graph) {
        this.pipeTransportationUpEdgesMap = new HashMap<Integer, List<PipeTransportEdge>>();
        this.pipeTransportationDownEdgesMap = new HashMap<Integer, List<PipeTransportEdge>>();
        this.pipeTransportationNodeEdgesMap = new HashMap<Node, List<PipeTransportEdge>>();
        for (URI uRI : graph.getEdges().keySet()) {
            ArrayList<PipeTransportEdge> arrayList;
            Node node;
            int n;
            Edge edge = (Edge)graph.getEdges().get((Object)uRI);
            if (!(edge instanceof PipeTransportEdge)) continue;
            PipeTransportEdge pipeTransportEdge = (PipeTransportEdge)edge;
            int n2 = Utility.keyLevel((String)edge.getNodeAURI().lastSegment());
            Map<Integer, List<PipeTransportEdge>> map = n2 > (n = Utility.keyLevel((String)edge.getNodeBURI().lastSegment())) ? this.pipeTransportationUpEdgesMap : this.pipeTransportationDownEdgesMap;
            if (map.containsKey(n2)) {
                map.get(n2).add(pipeTransportEdge);
            } else {
                node = new ArrayList();
                node.add(pipeTransportEdge);
                map.put(n2, (List<PipeTransportEdge>)node);
            }
            node = edge.getA();
            Node node2 = edge.getB();
            if (node != null) {
                if (this.pipeTransportationNodeEdgesMap.containsKey(node)) {
                    this.pipeTransportationNodeEdgesMap.get(node).add(pipeTransportEdge);
                } else {
                    arrayList = new ArrayList<PipeTransportEdge>();
                    arrayList.add(pipeTransportEdge);
                    this.pipeTransportationNodeEdgesMap.put(node, arrayList);
                }
            }
            if (node2 == null) continue;
            if (this.pipeTransportationNodeEdgesMap.containsKey(node2)) {
                this.pipeTransportationNodeEdgesMap.get(node2).add(pipeTransportEdge);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add(pipeTransportEdge);
            this.pipeTransportationNodeEdgesMap.put(node2, arrayList);
        }
    }

    @Override
    public DiseaseModelState initializeDiseaseState(DiseaseModelState diseaseModelState, DiseaseModelLabel diseaseModelLabel) {
        PopulationLabel populationLabel = diseaseModelLabel.getPopulationLabel();
        double d = populationLabel.getCurrentPopulationValue().getCount();
        this.addToTotalPopulationCount(d);
        double d2 = this.getArea(populationLabel);
        if (d2 <= 0.0) {
            this.reportBadAreaValue(populationLabel, d2);
            d2 = 1.0;
        }
        this.addToTotalArea(d2);
        return diseaseModelState;
    }

    @Override
    public void initializeDiseaseState(DiseaseModelLabel diseaseModelLabel) {
        StandardDiseaseModelState standardDiseaseModelState = (StandardDiseaseModelState)diseaseModelLabel.getDiseaseModelState();
        if (this.totalPopulationCount > 0.0) {
            double d = this.getArea(diseaseModelLabel.getPopulationLabel());
            if (d <= 0.0) {
                this.reportBadAreaValue(diseaseModelLabel.getPopulationLabel(), d);
                d = 1.0;
            }
            double d2 = this.getTotalArea() / d;
            standardDiseaseModelState.setAreaRatio(d2);
        }
    }

    public double getArea(PopulationLabel populationLabel) {
        double d = 0.0;
        d = populationLabel.getPopulatedArea();
        if (d == 0.0) {
            for (NodeLabel nodeLabel : populationLabel.getNode().getLabels()) {
                if (!(nodeLabel instanceof AreaLabel)) continue;
                AreaLabel areaLabel = (AreaLabel)nodeLabel;
                d = areaLabel.getCurrentAreaValue().getArea();
                break;
            }
        }
        return d;
    }

    private void reportBadAreaValue(PopulationLabel populationLabel, double d) {
        if (populationLabel.getPopulatedArea() == 0.0) {
            Activator.logError("The area value of \"" + d + "\" specified for \"" + populationLabel.getNode().toString() + "\" is not greater than zero (0.0)", null);
        } else {
            Activator.logError("The area value of \"" + d + "\" specified for the population \"" + populationLabel.getName() + "\" for the region \"" + populationLabel.getNode().toString() + "\" is not greater than zero (0.0)", null);
        }
    }

    @Override
    public void doModelSpecificAdjustments(StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
    }

    public abstract StandardDiseaseModelLabelValue computeDiseaseDeltas(STEMTime var1, StandardDiseaseModelLabelValue var2, StandardDiseaseModelLabel var3, long var4, DiseaseModelLabelValue var6);

    public abstract StandardDiseaseModelLabelValue computeDiseaseDeathsDeltas(STEMTime var1, StandardDiseaseModelLabelValue var2, long var3, DiseaseModelLabelValue var5);

    protected abstract StandardDiseaseModelLabelValue computeDepartures(double var1, StandardDiseaseModelLabelValue var3);

    protected abstract StandardDiseaseModelLabelValue getMigrationDeltas(StandardDiseaseModelLabel var1, STEMTime var2, DiseaseModelLabelValue var3);

    protected StandardDiseaseModelLabelValue getPipeTransportationDeltas(StandardDiseaseModelLabel standardDiseaseModelLabel, STEMTime sTEMTime, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        Node node = standardDiseaseModelLabel.getNode();
        List<PipeTransportEdge> list = this.pipeTransportationNodeEdgesMap.get(node);
        if (list == null) {
            return (StandardDiseaseModelLabelValue)this.createDiseaseModelLabelValue();
        }
        for (PipeTransportEdge pipeTransportEdge : list) {
            double d;
            long l2;
            double d2;
            double d3;
            double d4;
            PipeTransportEdgeLabelValue pipeTransportEdgeLabelValue;
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue;
            Object object;
            Object object22;
            boolean bl;
            boolean bl2 = pipeTransportEdge.getB().equals(node);
            if (bl2) {
                for (NodeLabel nodeLabel : pipeTransportEdge.getA().getLabels()) {
                    if (!(nodeLabel instanceof StandardDiseaseModelLabel) || ((StandardDiseaseModelLabel)nodeLabel).getDecorator() != this) continue;
                    bl = false;
                    for (Object object22 : pipeTransportEdge.getB().getLabels()) {
                        if (!(object22 instanceof StandardDiseaseModelLabel) || !((StandardDiseaseModelLabel)object22).getDecorator().equals(((StandardDiseaseModelLabel)nodeLabel).getDecorator())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    object22 = (StandardDiseaseModelLabel)nodeLabel;
                    object = (StandardDiseaseModelLabelValue)object22.getTempValue();
                    standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)EcoreUtil.copy((EObject)object);
                    pipeTransportEdgeLabelValue = (PipeTransportEdgeLabelValue)pipeTransportEdge.getLabel().getCurrentValue();
                    d4 = pipeTransportEdgeLabelValue.getMaxFlow();
                    d3 = d4;
                    if (d3 > (d2 = ((StandardDiseaseModelLabelValue)object22.getTempValue()).getPopulationCount())) {
                        d3 = d2;
                    }
                    l2 = pipeTransportEdgeLabelValue.getTimePeriod();
                    d = d3 / d2;
                    if (Double.isNaN(d = d * (double)l / (double)l2) || Double.isInfinite(d)) {
                        d = 0.0;
                    }
                    standardDiseaseModelLabelValue.scale(d);
                    diseaseModelLabelValue.add(standardDiseaseModelLabelValue);
                }
                continue;
            }
            for (NodeLabel nodeLabel : pipeTransportEdge.getA().getLabels()) {
                if (!(nodeLabel instanceof StandardDiseaseModelLabel) || ((StandardDiseaseModelLabel)nodeLabel).getDecorator() != this) continue;
                bl = false;
                for (Object object22 : pipeTransportEdge.getB().getLabels()) {
                    if (!(object22 instanceof StandardDiseaseModelLabel) || !((StandardDiseaseModelLabel)object22).getDecorator().equals(((StandardDiseaseModelLabel)nodeLabel).getDecorator())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                object22 = (StandardDiseaseModelLabel)nodeLabel;
                object = (StandardDiseaseModelLabelValue)object22.getTempValue();
                standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)EcoreUtil.copy((EObject)object);
                pipeTransportEdgeLabelValue = (PipeTransportEdgeLabelValue)pipeTransportEdge.getLabel().getCurrentValue();
                d4 = pipeTransportEdgeLabelValue.getMaxFlow();
                d2 = d4;
                if (d2 > (d3 = ((StandardDiseaseModelLabelValue)object22.getTempValue()).getPopulationCount())) {
                    d2 = d3;
                }
                l2 = pipeTransportEdgeLabelValue.getTimePeriod();
                d = d2 / d3;
                if (Double.isNaN(d = d * (double)l / (double)l2) || Double.isInfinite(d)) {
                    d = 0.0;
                }
                standardDiseaseModelLabelValue.scale(d);
                diseaseModelLabelValue.sub(standardDiseaseModelLabelValue);
            }
        }
        return (StandardDiseaseModelLabelValue)diseaseModelLabelValue;
    }

    public void resetLabels() {
        super.resetLabels();
        for (DynamicLabel dynamicLabel : this.getLabelsToUpdate()) {
            StandardDiseaseModelLabel standardDiseaseModelLabel = (StandardDiseaseModelLabel)dynamicLabel;
            Node node = standardDiseaseModelLabel.getNode();
            for (Edge edge : TransportRelationshipLabelImpl.getTransportEdgesToNode((Node)node, (String)this.populationIdentifier)) {
                TransportRelationshipLabel transportRelationshipLabel = (TransportRelationshipLabel)edge.getLabel();
                transportRelationshipLabel.reset();
            }
        }
        this.populatePipeSystemNodes();
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (totalPopulationCount: ");
        stringBuffer.append(this.totalPopulationCount);
        stringBuffer.append(", totalPopulationCountReciprocal: ");
        stringBuffer.append(this.totalPopulationCountReciprocal);
        stringBuffer.append(", totalArea: ");
        stringBuffer.append(this.totalArea);
        stringBuffer.append(", referencePopulationDensity: ");
        stringBuffer.append(this.referencePopulationDensity);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.totalPopulationCount >= 0.0;
        assert (bl);
        boolean bl3 = bl = bl && !Double.isInfinite(this.totalPopulationCount);
        assert (bl);
        boolean bl4 = bl = bl && !Double.isNaN(this.totalPopulationCount);
        assert (bl);
        boolean bl5 = bl = bl && this.totalPopulationCountReciprocal >= 0.0;
        assert (bl);
        boolean bl6 = bl = bl && !Double.isInfinite(this.totalPopulationCountReciprocal);
        assert (bl);
        boolean bl7 = bl = bl && !Double.isNaN(this.totalPopulationCountReciprocal);
        assert (bl);
        boolean bl8 = bl = bl && this.totalArea >= 0.0;
        assert (bl);
        boolean bl9 = bl = bl && !Double.isInfinite(this.totalArea);
        assert (bl);
        boolean bl10 = bl = bl && !Double.isNaN(this.totalArea);
        assert (bl);
        return bl;
    }
}

