/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.Random;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.StandardStochasticDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StochasticDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StochasticSIDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.impl.SIImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StandardStochasticDiseaseModelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StochasticSIDiseaseModelImpl
extends SIImpl
implements StochasticSIDiseaseModel {
    protected static final long SEED_EDEFAULT = 0L;
    protected long seed = 0L;
    protected static final Random RANDOM_GENERATOR_EDEFAULT = (Random)StandardFactory.eINSTANCE.createFromString(StandardPackage.eINSTANCE.getRandom(), "0");
    protected Random randomGenerator = RANDOM_GENERATOR_EDEFAULT;
    protected static final double GAIN_EDEFAULT = 0.01;
    protected double gain = 0.01;

    public static final StochasticSIDiseaseModel createStochasticSIDiseaseModel(String string, double d, double d2, double d3, double d4, double d5, long l, String string2, double d6) {
        StochasticSIDiseaseModel stochasticSIDiseaseModel = StandardFactory.eINSTANCE.createStochasticSIDiseaseModel();
        StochasticSIDiseaseModelImpl.initializeSIDiseaseModel(stochasticSIDiseaseModel, string, d, d2, d3, d4, d5, l, string2);
        stochasticSIDiseaseModel.setGain(d6);
        return stochasticSIDiseaseModel;
    }

    public void doModelSpecificAdjustments(LabelValue labelValue) {
        double d;
        SILabelValue sILabelValue = (SILabelValue)labelValue;
        sILabelValue.getI();
        double d2 = sILabelValue.getIncidence();
        double d3 = d2 * this.computeNoise();
        double d4 = d3 - d2;
        double d5 = sILabelValue.getI() + d4;
        double d6 = sILabelValue.getS() - d4;
        if (d5 < 0.0) {
            d = -d5 / sILabelValue.getI();
            if (Double.isInfinite(d)) {
                d = 0.0;
            }
            d5 = sILabelValue.getI() + (d4 *= d);
            d6 = sILabelValue.getS() - d4;
        }
        if (d6 < 0.0) {
            d = -d6 / sILabelValue.getS();
            if (Double.isInfinite(d)) {
                d = 0.0;
            }
            d5 = sILabelValue.getI() + (d4 *= d);
            d6 = sILabelValue.getS() - d4;
        }
        d3 = d2 + d4;
        sILabelValue.setS(d6);
        sILabelValue.setI(d5);
        sILabelValue.setIncidence(d3);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STOCHASTIC_SI_DISEASE_MODEL;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long l) {
        long l2 = this.seed;
        this.seed = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 27, l2, this.seed));
        }
        this.randomGenerator.setSeed(l);
    }

    @Override
    public Random getRandomGenerator() {
        return this.randomGenerator;
    }

    @Override
    public double getGain() {
        return this.gain;
    }

    @Override
    public void setGain(double d) {
        double d2 = this.gain;
        this.gain = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 29, d2, this.gain));
        }
    }

    @Override
    public double computeNoise() {
        return StandardStochasticDiseaseModelImpl.computeNoise(this.gain, this.randomGenerator);
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 27: {
                return new Long(this.getSeed());
            }
            case 28: {
                return this.getRandomGenerator();
            }
            case 29: {
                return new Double(this.getGain());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 27: {
                this.setSeed((Long)object);
                return;
            }
            case 29: {
                this.setGain((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 27: {
                this.setSeed(0L);
                return;
            }
            case 29: {
                this.setGain(0.01);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 27: {
                return this.seed != 0L;
            }
            case 28: {
                return RANDOM_GENERATOR_EDEFAULT == null ? this.randomGenerator != null : !RANDOM_GENERATOR_EDEFAULT.equals(this.randomGenerator);
            }
            case 29: {
                return this.gain != 0.01;
            }
        }
        return super.eIsSet(n);
    }

    public int eBaseStructuralFeatureID(int n, Class<?> clazz) {
        if (clazz == StochasticDiseaseModel.class) {
            switch (n) {
                case 27: {
                    return 16;
                }
                case 28: {
                    return 17;
                }
            }
            return -1;
        }
        if (clazz == StandardStochasticDiseaseModel.class) {
            switch (n) {
                case 29: {
                    return 18;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(n, clazz);
    }

    public int eDerivedStructuralFeatureID(int n, Class<?> clazz) {
        if (clazz == StochasticDiseaseModel.class) {
            switch (n) {
                case 16: {
                    return 27;
                }
                case 17: {
                    return 28;
                }
            }
            return -1;
        }
        if (clazz == StandardStochasticDiseaseModel.class) {
            switch (n) {
                case 18: {
                    return 29;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(n, clazz);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (seed: ");
        stringBuffer.append(this.seed);
        stringBuffer.append(", randomGenerator: ");
        stringBuffer.append(this.randomGenerator);
        stringBuffer.append(", gain: ");
        stringBuffer.append(this.gain);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

