/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.provider;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.stem.adapters.history.HistoryProvider;
import org.eclipse.stem.adapters.history.HistoryProviderAdapter;
import org.eclipse.stem.adapters.history.HistoryProviderAdapterFactory;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.util.StandardAdapterFactory;

public class StandardHistoryProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    public StandardHistoryProviderAdapterFactory() {
        HistoryProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public Adapter createDiseaseModelLabelAdapter() {
        return new DiseaseModelLabelHistoryProvider();
    }

    public void addListener(INotifyChangedListener iNotifyChangedListener) {
        this.changeNotifier.addListener(iNotifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener iNotifyChangedListener) {
        this.changeNotifier.removeListener(iNotifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory composedAdapterFactory) {
        this.parentAdapterFactory = composedAdapterFactory;
    }

    public boolean isFactoryForType(Object object) {
        return object == HistoryProvider.class || super.isFactoryForType(object);
    }

    public void dispose() {
    }

    private static class DiseaseModelLabelHistoryProvider
    extends HistoryProviderAdapter
    implements HistoryProvider {
        long cycle = 0L;
        final STEMTime startTime = ModelFactory.eINSTANCE.createSTEMTime();
        final Map<STEMTime, DiseaseModelLabel> history = Collections.synchronizedMap(new TreeMap());

        private DiseaseModelLabelHistoryProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification notification) {
            block2 : switch (notification.getEventType()) {
                case 1: {
                    switch (notification.getFeatureID(LabelValue.class)) {
                        case 7: {
                            if (notification.getNewValue() == null) break block2;
                            STEMTime sTEMTime = this.generateNextSTEMTime(this.cycle++);
                            Map<STEMTime, DiseaseModelLabel> map = this.history;
                            synchronized (map) {
                                DiseaseModelLabel diseaseModelLabel = (DiseaseModelLabel)EcoreUtil.copy((EObject)((DiseaseModelLabel)this.getTarget()));
                                diseaseModelLabel.getNode().getLabels().remove((Object)diseaseModelLabel);
                                this.history.put(sTEMTime, diseaseModelLabel);
                            }
                            this.fireHistoryExtended();
                            break block2;
                        }
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public STEMTime[] getAllHistoricTimeValues() {
            STEMTime[] sTEMTimeArray = null;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                sTEMTimeArray = this.history.keySet().toArray(new STEMTime[0]);
            }
            return sTEMTimeArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Identifiable[] getAllHistoricInstances() {
            Identifiable[] identifiableArray = null;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                identifiableArray = this.history.values().toArray(new Identifiable[0]);
            }
            return identifiableArray;
        }

        public Identifiable[] getHistoricInstances(STEMTime[] sTEMTimeArray) {
            Identifiable[] identifiableArray = this.getAllHistoricInstances();
            Identifiable[] identifiableArray2 = new Identifiable[sTEMTimeArray.length];
            System.arraycopy(identifiableArray, 0, identifiableArray2, 0, sTEMTimeArray.length);
            return identifiableArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEarliestCycleNumber() {
            long l = 0L;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                try {
                    l = this.history.keySet().toArray(new Long[0])[0];
                }
                catch (RuntimeException runtimeException) {}
            }
            return (int)l;
        }

        public STEMTime getEarliestTimeValue() {
            return this.generateHistoricSTEMTime(this.getEarliestCycleNumber());
        }

        private STEMTime generateHistoricSTEMTime(int n) {
            STEMTime sTEMTime = ModelFactory.eINSTANCE.createSTEMTime();
            long l = sTEMTime.getTime().getTime() - (long)n * STEMTime.Units.DAY.getMilliseconds();
            sTEMTime.setTime(new Date(l));
            return sTEMTime;
        }

        private STEMTime generateNextSTEMTime(long l) {
            STEMTime sTEMTime = ModelFactory.eINSTANCE.createSTEMTime();
            long l2 = this.startTime.getTime().getTime() + l * STEMTime.Units.DAY.getMilliseconds();
            sTEMTime.setTime(new Date(l2));
            return sTEMTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.cycle = 0L;
            Map<STEMTime, DiseaseModelLabel> map = this.history;
            synchronized (map) {
                this.history.clear();
            }
            super.reset();
        }
    }
}

